/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.bloomfilter.impls;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.MurmurHash128Bit;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class BloomFilter {
    private static final int METADATA_PAGE_ID = 0;
    private static final int NUM_PAGES_OFFSET = 0;
    private static final int NUM_HASHES_USED_OFFSET = 4;
    private static final int NUM_ELEMENTS_OFFSET = 8;
    private static final int NUM_BITS_OFFSET = 16;
    private final IBufferCache bufferCache;
    private final IFileMapProvider fileMapProvider;
    private final FileReference file;
    private final int[] keyFields;
    private int fileId = -1;
    private boolean isActivated = false;
    private int numPages;
    private int numHashes;
    private long numElements;
    private long numBits;
    private final int numBitsPerPage;
    private static final byte[] ZERO_BUFFER = new byte[131072];
    private static final long SEED = 0L;

    public BloomFilter(IBufferCache bufferCache, IFileMapProvider fileMapProvider, FileReference file, int[] keyFields) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.fileMapProvider = fileMapProvider;
        this.file = file;
        this.keyFields = keyFields;
        this.numBitsPerPage = bufferCache.getPageSize() * 8;
    }

    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public int getNumPages() throws HyracksDataException {
        if (!this.isActivated) {
            this.activate();
        }
        return this.numPages;
    }

    public long getNumElements() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("The bloom filter is not activated.");
        }
        return this.numElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ITupleReference tuple, long[] hashes) throws HyracksDataException {
        if (this.numPages == 0) {
            return false;
        }
        MurmurHash128Bit.hash3_x64_128(tuple, this.keyFields, 0L, hashes);
        for (int i = 0; i < this.numHashes; ++i) {
            long hash = Math.abs((hashes[0] + (long)i * hashes[1]) % this.numBits);
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)((int)(hash / (long)this.numBitsPerPage) + 1)), false);
            page.acquireReadLatch();
            try {
                ByteBuffer buffer = page.getBuffer();
                int byteIndex = (int)(hash % (long)this.numBitsPerPage) >> 3;
                byte b = buffer.get(byteIndex);
                int bitIndex = (int)(hash % (long)this.numBitsPerPage) & 7;
                if (((long)b & 1L << bitIndex) != 0L) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFile() throws HyracksDataException {
        boolean fileIsMapped = false;
        IFileMapProvider iFileMapProvider = this.fileMapProvider;
        synchronized (iFileMapProvider) {
            fileIsMapped = this.fileMapProvider.isMapped(this.file);
            if (!fileIsMapped) {
                this.bufferCache.createFile(this.file);
            }
            this.fileId = this.fileMapProvider.lookupFileId(this.file);
            try {
                this.bufferCache.openFile(this.fileId);
            }
            catch (HyracksDataException e) {
                if (!fileIsMapped) {
                    this.bufferCache.deleteFile(this.fileId, false);
                }
                throw e;
            }
        }
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the bloom filter since it is activated.");
        }
        this.prepareFile();
        this.bufferCache.closeFile(this.fileId);
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            return;
        }
        this.prepareFile();
        this.readBloomFilterMetaData();
        this.isActivated = true;
    }

    private void readBloomFilterMetaData() throws HyracksDataException {
        if (this.bufferCache.getNumPagesOfFile(this.fileId) == 0) {
            this.numPages = 0;
            this.numHashes = 0;
            this.numElements = 0L;
            this.numBits = 0L;
            return;
        }
        ICachedPage metaPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)0), false);
        metaPage.acquireReadLatch();
        try {
            this.numPages = metaPage.getBuffer().getInt(0);
            this.numHashes = metaPage.getBuffer().getInt(4);
            this.numElements = metaPage.getBuffer().getLong(8);
            this.numBits = metaPage.getBuffer().getLong(16);
        }
        finally {
            metaPage.releaseReadLatch();
            this.bufferCache.unpin(metaPage);
        }
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActivated) {
            return;
        }
        this.bufferCache.closeFile(this.fileId);
        this.isActivated = false;
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the bloom filter since it is activated.");
        }
        this.file.delete();
        if (this.fileId == -1) {
            return;
        }
        this.bufferCache.deleteFile(this.fileId, false);
        this.fileId = -1;
    }

    public IIndexBulkLoader createBuilder(long numElements, int numHashes, int numBitsPerElement) throws HyracksDataException {
        return new BloomFilterBuilder(numElements, numHashes, numBitsPerElement);
    }

    public class BloomFilterBuilder
    implements IIndexBulkLoader {
        private final long[] hashes = new long[2];
        private final long numElements;
        private final int numHashes;
        private final long numBits;
        private final int numPages;
        private IFIFOPageQueue queue;
        private ICachedPage[] pages;
        private ICachedPage metaDataPage = null;

        public BloomFilterBuilder(long numElements, int numHashes, int numBitsPerElement) throws HyracksDataException {
            if (!BloomFilter.this.isActivated) {
                throw new HyracksDataException("Failed to create the bloom filter builder since it is not activated.");
            }
            this.queue = BloomFilter.this.bufferCache.createFIFOQueue();
            this.numElements = numElements;
            this.numHashes = numHashes;
            this.numBits = this.numElements * (long)numBitsPerElement;
            long tmp = (long)Math.ceil((double)this.numBits / (double)BloomFilter.this.numBitsPerPage);
            if (tmp > Integer.MAX_VALUE) {
                throw new HyracksDataException("Cannot create a bloom filter with his huge number of pages.");
            }
            this.numPages = (int)tmp;
            this.pages = new ICachedPage[this.numPages];
            for (int currentPageId = 1; currentPageId <= this.numPages; ++currentPageId) {
                ICachedPage page = BloomFilter.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)BloomFilter.this.fileId, (int)currentPageId));
                this.initPage(page.getBuffer().array());
                this.pages[currentPageId - 1] = page;
            }
        }

        private void initPage(byte[] array) {
            int numRounds = array.length / ZERO_BUFFER.length;
            int leftOver = array.length % ZERO_BUFFER.length;
            int destPos = 0;
            for (int i = 0; i < numRounds; ++i) {
                System.arraycopy(ZERO_BUFFER, 0, array, destPos, ZERO_BUFFER.length);
                destPos = (i + 1) * ZERO_BUFFER.length;
            }
            if (leftOver > 0) {
                System.arraycopy(ZERO_BUFFER, 0, array, destPos, leftOver);
            }
        }

        private void allocateAndInitMetaDataPage() throws HyracksDataException {
            if (this.metaDataPage == null) {
                this.metaDataPage = BloomFilter.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)BloomFilter.this.fileId, (int)0));
            }
            this.metaDataPage.getBuffer().putInt(0, this.numPages);
            this.metaDataPage.getBuffer().putInt(4, this.numHashes);
            this.metaDataPage.getBuffer().putLong(8, this.numElements);
            this.metaDataPage.getBuffer().putLong(16, this.numBits);
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            if (this.numPages == 0) {
                throw new HyracksDataException("Cannot add elements to this filter since it is supposed to be empty (number of elements hint passed to the filter during construction was 0).");
            }
            MurmurHash128Bit.hash3_x64_128(tuple, BloomFilter.this.keyFields, 0L, this.hashes);
            for (int i = 0; i < this.numHashes; ++i) {
                long hash = Math.abs((this.hashes[0] + (long)i * this.hashes[1]) % this.numBits);
                ICachedPage page = this.pages[(int)(hash / (long)BloomFilter.this.numBitsPerPage)];
                ByteBuffer buffer = page.getBuffer();
                int byteIndex = (int)(hash % (long)BloomFilter.this.numBitsPerPage) >> 3;
                byte b = buffer.get(byteIndex);
                int bitIndex = (int)(hash % (long)BloomFilter.this.numBitsPerPage) & 7;
                b = (byte)(b | 1 << bitIndex);
                buffer.put(byteIndex, b);
            }
        }

        public void end() throws HyracksDataException, IndexException {
            this.allocateAndInitMetaDataPage();
            this.queue.put(this.metaDataPage);
            for (ICachedPage p : this.pages) {
                this.queue.put(p);
            }
            BloomFilter.this.bufferCache.finishQueue();
            BloomFilter.this.numBits = this.numBits;
            BloomFilter.this.numHashes = this.numHashes;
            BloomFilter.this.numElements = this.numElements;
            BloomFilter.this.numPages = this.numPages;
        }

        public void abort() throws HyracksDataException {
            for (ICachedPage p : this.pages) {
                if (p == null) continue;
                BloomFilter.this.bufferCache.returnPage(p, false);
            }
            if (this.metaDataPage != null) {
                BloomFilter.this.bufferCache.returnPage(this.metaDataPage, false);
            }
        }
    }
}

