/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.util.Map;
import org.apache.asterix.active.EntityId;

public class Activity
implements Comparable<Activity> {
    protected int activityId;
    protected final EntityId activeEntityId;
    protected final Map<String, String> activityDetails;

    public Activity(EntityId activeEntityId, Map<String, String> activityDetails) {
        this.activeEntityId = activeEntityId;
        this.activityDetails = activityDetails;
    }

    public String getDataverseName() {
        return this.activeEntityId.getDataverse();
    }

    public String getActiveEntityName() {
        return this.activeEntityId.getEntityName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Activity)) {
            return false;
        }
        return ((Activity)other).activeEntityId.equals(this.activeEntityId) && ((Activity)other).getActivityId() != this.activityId;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.activeEntityId + "." + this.activityId;
    }

    public int getActivityId() {
        return this.activityId;
    }

    public void setActivityId(int activityId) {
        this.activityId = activityId;
    }

    public Map<String, String> getActivityDetails() {
        return this.activityDetails;
    }

    @Override
    public int compareTo(Activity o) {
        return o.getActivityId() - this.activityId;
    }
}

