/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActiveSourceOperatorNodePushable;

public class ActiveRuntimeManager {
    private static final Logger LOGGER = Logger.getLogger(ActiveRuntimeManager.class.getName());
    private final Map<ActiveRuntimeId, ActiveSourceOperatorNodePushable> activeRuntimes = new ConcurrentHashMap<ActiveRuntimeId, ActiveSourceOperatorNodePushable>();
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public void close() throws IOException {
        if (this.executorService != null) {
            this.executorService.shutdown();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Shut down executor service for :" + ActiveRuntimeManager.class.getSimpleName());
            }
            try {
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.SEVERE, ActiveRuntimeManager.class.getSimpleName() + " was interrupted while waiting for runtime managers to shutdown", e);
            }
            if (!this.executorService.isTerminated()) {
                LOGGER.severe(ActiveRuntimeManager.class.getSimpleName() + " failed to shutdown successfully. Will be forced to shutdown");
                this.executorService.shutdownNow();
            }
        }
    }

    public ActiveSourceOperatorNodePushable getRuntime(ActiveRuntimeId runtimeId) {
        return this.activeRuntimes.get(runtimeId);
    }

    public void registerRuntime(ActiveRuntimeId runtimeId, ActiveSourceOperatorNodePushable feedRuntime) {
        this.activeRuntimes.put(runtimeId, feedRuntime);
    }

    public synchronized void deregisterRuntime(ActiveRuntimeId runtimeId) {
        this.activeRuntimes.remove(runtimeId);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Set<ActiveRuntimeId> getFeedRuntimes() {
        return this.activeRuntimes.keySet();
    }
}

