/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class ActiveJobNotificationHandler
implements Runnable {
    public static final ActiveJobNotificationHandler INSTANCE = new ActiveJobNotificationHandler();
    public static final String ACTIVE_ENTITY_PROPERTY_NAME = "ActiveJob";
    private static final Logger LOGGER = Logger.getLogger(ActiveJobNotificationHandler.class.getName());
    private static final boolean DEBUG = false;
    private final LinkedBlockingQueue<ActiveEvent> eventInbox = new LinkedBlockingQueue();
    private final Map<EntityId, IActiveEntityEventsListener> entityEventListeners;
    private final Map<JobId, EntityId> jobId2ActiveJobInfos = new HashMap<JobId, EntityId>();

    private ActiveJobNotificationHandler() {
        this.entityEventListeners = new HashMap<EntityId, IActiveEntityEventsListener>();
    }

    @Override
    public void run() {
        Thread.currentThread().setName(ActiveJobNotificationHandler.class.getSimpleName());
        LOGGER.log(Level.INFO, "Started " + ActiveJobNotificationHandler.class.getSimpleName());
        while (!Thread.interrupted()) {
            try {
                ActiveEvent event = this.getEventInbox().take();
                EntityId entityId = this.jobId2ActiveJobInfos.get(event.getJobId());
                if (entityId != null) {
                    IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
                    LOGGER.log(Level.FINER, "Next event is of type " + (Object)((Object)event.getEventKind()));
                    if (event.getEventKind() == ActiveEvent.Kind.JOB_FINISHED) {
                        LOGGER.log(Level.FINER, "Removing the job");
                        this.jobId2ActiveJobInfos.remove(event.getJobId());
                    }
                    if (listener == null) continue;
                    LOGGER.log(Level.FINER, "Notifying the listener");
                    listener.notify(event);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Entity not found for received message for job " + event.getJobId());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error handling an active job event", e);
            }
        }
        LOGGER.log(Level.INFO, "Stopped " + ActiveJobNotificationHandler.class.getSimpleName());
    }

    public synchronized void removeListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        LOGGER.log(Level.FINER, "Removing the listener since it is not active anymore");
        this.unregisterListener(listener);
    }

    public IActiveEntityEventsListener getActiveEntityListener(EntityId entityId) {
        return this.entityEventListeners.get(entityId);
    }

    public EntityId getEntity(JobId jobId) {
        return this.jobId2ActiveJobInfos.get(jobId);
    }

    public void notifyJobCreation(JobId jobId, JobSpecification jobSpecification) {
        LOGGER.log(Level.FINER, "notifyJobCreation(JobId jobId, JobSpecification jobSpecification) was called with jobId = " + jobId);
        Serializable property = jobSpecification.getProperty(ACTIVE_ENTITY_PROPERTY_NAME);
        if (property == null || !(property instanceof EntityId)) {
            LOGGER.log(Level.FINER, "Job was is not active. property found to be: " + property);
            return;
        }
        EntityId entityId = (EntityId)property;
        this.monitorJob(jobId, entityId);
        boolean found = this.jobId2ActiveJobInfos.get(jobId) != null;
        LOGGER.log(Level.FINER, "Job was found to be: " + (found ? "Active" : "Inactive"));
        IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
        if (listener != null) {
            listener.notify(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_CREATED, entityId, jobSpecification));
        }
        LOGGER.log(Level.FINER, "Listener was notified" + jobId);
    }

    public LinkedBlockingQueue<ActiveEvent> getEventInbox() {
        return this.eventInbox;
    }

    public synchronized IActiveEntityEventsListener[] getEventListeners() {
        return this.entityEventListeners.values().toArray(new IActiveEntityEventsListener[this.entityEventListeners.size()]);
    }

    public synchronized void registerListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.entityEventListeners.containsKey(listener.getEntityId())) {
            throw new HyracksDataException("Active Entity Listener " + listener.getEntityId() + " is already registered");
        }
        this.entityEventListeners.put(listener.getEntityId(), listener);
    }

    public synchronized void unregisterListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        LOGGER.log(Level.FINER, "unregisterListener(IActiveEntityEventsListener listener) was called for the entity " + listener.getEntityId());
        IActiveEntityEventsListener registeredListener = this.entityEventListeners.remove(listener.getEntityId());
        if (registeredListener == null) {
            throw new HyracksDataException("Active Entity Listener " + listener.getEntityId() + " hasn't been registered");
        }
    }

    public synchronized void monitorJob(JobId jobId, EntityId activeJob) {
        if (this.entityEventListeners.containsKey(activeJob)) {
            if (this.jobId2ActiveJobInfos.containsKey(jobId)) {
                LOGGER.severe("Job is already being monitored for job: " + jobId);
                return;
            }
        } else {
            LOGGER.severe("No listener was found for the entity: " + activeJob);
        }
        this.jobId2ActiveJobInfos.put(jobId, activeJob);
    }
}

