/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.partition.range.IRangeMap;

public class FieldRangePartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] rangeFields;
    private IRangeMap rangeMap;
    private IBinaryComparatorFactory[] comparatorFactories;

    public FieldRangePartitionComputerFactory(int[] rangeFields, IBinaryComparatorFactory[] comparatorFactories, IRangeMap rangeMap) {
        this.rangeFields = rangeFields;
        this.comparatorFactories = comparatorFactories;
        this.rangeMap = rangeMap;
    }

    public ITuplePartitionComputer createPartitioner() {
        final IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        return new ITuplePartitionComputer(){

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                if (nParts == 1) {
                    return 0;
                }
                int slotIndex = this.getRangePartition(accessor, tIndex);
                double rangesPerPart = 1.0;
                if (FieldRangePartitionComputerFactory.this.rangeMap.getSplitCount() + 1 > nParts) {
                    rangesPerPart = ((double)FieldRangePartitionComputerFactory.this.rangeMap.getSplitCount() + 1.0) / (double)nParts;
                }
                return (int)Math.floor((double)slotIndex / rangesPerPart);
            }

            public int getRangePartition(IFrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                int slotIndex = 0;
                for (int i = 0; i < FieldRangePartitionComputerFactory.this.rangeMap.getSplitCount(); ++i) {
                    int c = this.compareSlotAndFields(accessor, tIndex, i);
                    if (c < 0) {
                        return slotIndex;
                    }
                    ++slotIndex;
                }
                return slotIndex;
            }

            public int compareSlotAndFields(IFrameTupleAccessor accessor, int tIndex, int fieldIndex) throws HyracksDataException {
                int c = 0;
                int startOffset = accessor.getTupleStartOffset(tIndex);
                int slotLength = accessor.getFieldSlotsLength();
                for (int f = 0; f < comparators.length; ++f) {
                    int fIdx = FieldRangePartitionComputerFactory.this.rangeFields[f];
                    int fStart = accessor.getFieldStartOffset(tIndex, fIdx);
                    int fEnd = accessor.getFieldEndOffset(tIndex, fIdx);
                    c = comparators[f].compare(accessor.getBuffer().array(), startOffset + slotLength + fStart, fEnd - fStart, FieldRangePartitionComputerFactory.this.rangeMap.getByteArray(fieldIndex, f), FieldRangePartitionComputerFactory.this.rangeMap.getStartOffset(fieldIndex, f), FieldRangePartitionComputerFactory.this.rangeMap.getLength(fieldIndex, f));
                    if (c == 0) continue;
                    return c;
                }
                return c;
            }
        };
    }
}

