/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.util;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameFieldAppender;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FrameUtils {
    public static void copyWholeFrame(ByteBuffer srcFrame, ByteBuffer destFrame) {
        srcFrame.clear();
        destFrame.clear();
        destFrame.put(srcFrame);
    }

    public static void copyAndFlip(ByteBuffer srcFrame, ByteBuffer destFrame) {
        srcFrame.position(0);
        destFrame.clear();
        destFrame.put(srcFrame);
        destFrame.flip();
    }

    public static void flushFrame(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        writer.nextFrame(buffer);
        buffer.clear();
    }

    public static int appendSkipEmptyFieldToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, int[] fieldSlots, byte[] bytes, int offset, int length) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.appendSkipEmptyField(fieldSlots, bytes, offset, length)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.appendSkipEmptyField(fieldSlots, bytes, offset, length)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, byte[] bytes, int offset, int length) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.append(bytes, offset, length)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.append(bytes, offset, length)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, IFrameTupleAccessor tupleAccessor, int tStartOffset, int tEndOffset) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.append(tupleAccessor, tStartOffset, tEndOffset)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.append(tupleAccessor, tStartOffset, tEndOffset)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, IFrameTupleAccessor tupleAccessor, int tIndex) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.append(tupleAccessor, tIndex)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.append(tupleAccessor, tIndex)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendToWriter(IFrameWriter writer, IFrameTupleAppender tupleAppender, int[] fieldEndOffsets, byte[] byteArray, int start, int size) throws HyracksDataException {
        int flushedBytes = 0;
        if (!tupleAppender.append(fieldEndOffsets, byteArray, start, size)) {
            flushedBytes = tupleAppender.getBuffer().capacity();
            tupleAppender.write(writer, true);
            if (!tupleAppender.append(fieldEndOffsets, byteArray, start, size)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendConcatToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.appendConcat(accessor0, tIndex0, accessor1, tIndex1)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.appendConcat(accessor0, tIndex0, accessor1, tIndex1)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendConcatToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, IFrameTupleAccessor accessor0, int tIndex0, int[] fieldSlots1, byte[] bytes1, int offset1, int dataLen1) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.appendConcat(accessor0, tIndex0, fieldSlots1, bytes1, offset1, dataLen1)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.appendConcat(accessor0, tIndex0, fieldSlots1, bytes1, offset1, dataLen1)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendProjectionToWriter(IFrameWriter writer, IFrameTupleAppender frameTupleAppender, IFrameTupleAccessor accessor, int tIndex, int[] fields) throws HyracksDataException {
        int flushedBytes = 0;
        if (!frameTupleAppender.appendProjection(accessor, tIndex, fields)) {
            flushedBytes = frameTupleAppender.getBuffer().capacity();
            frameTupleAppender.write(writer, true);
            if (!frameTupleAppender.appendProjection(accessor, tIndex, fields)) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
        return flushedBytes;
    }

    public static int appendFieldToWriter(IFrameWriter writer, IFrameFieldAppender appender, byte[] array, int start, int length) throws HyracksDataException {
        int flushedBytes = 0;
        if (!appender.appendField(array, start, length)) {
            flushedBytes = appender.getBuffer().capacity();
            appender.write(writer, true);
            if (!appender.appendField(array, start, length)) {
                throw new HyracksDataException("Could not write frame: the size of the tuple is too long");
            }
        }
        return flushedBytes;
    }

    public static int appendFieldToWriter(IFrameWriter writer, IFrameFieldAppender appender, IFrameTupleAccessor accessor, int tid, int fid) throws HyracksDataException {
        int flushedBytes = 0;
        if (!appender.appendField(accessor, tid, fid)) {
            flushedBytes = appender.getBuffer().capacity();
            appender.write(writer, true);
            if (!appender.appendField(accessor, tid, fid)) {
                throw new HyracksDataException("Could not write frame: the size of the tuple is too long");
            }
        }
        return flushedBytes;
    }
}

