/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;

public class FrameOutputStream
extends ByteArrayAccessibleOutputStream {
    private static final Logger LOGGER = Logger.getLogger(FrameOutputStream.class.getName());
    private final FrameTupleAppender frameTupleAppender = new FrameTupleAppender();

    public FrameOutputStream(int initialStreamCapaciy) {
        super(initialStreamCapaciy);
    }

    public void reset(IFrame frame, boolean clear) throws HyracksDataException {
        this.frameTupleAppender.reset(frame, clear);
    }

    public int getTupleCount() {
        int tupleCount = this.frameTupleAppender.getTupleCount();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("appendTuple(): tuple count: " + tupleCount);
        }
        return tupleCount;
    }

    public boolean appendTuple() throws HyracksDataException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("appendTuple(): tuple size: " + this.count);
        }
        boolean appended = this.frameTupleAppender.append(this.buf, 0, this.count);
        this.count = 0;
        return appended;
    }

    public void flush(IFrameWriter writer) throws HyracksDataException {
        this.frameTupleAppender.write(writer, true);
    }
}

