/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class TypeUtil {
    private TypeUtil() {
    }

    public static Pair<ARecordType, ARecordType> createEnforcedType(ARecordType recordType, ARecordType metaType, List<Index> indexes) throws AlgebricksException {
        ARecordType enforcedRecordType = recordType;
        ARecordType enforcedMetaType = metaType;
        for (Index index : indexes) {
            if (!index.isSecondaryIndex() || !index.isEnforcingKeyFileds()) continue;
            if (index.hasMetaFields()) {
                throw new AlgebricksException("Indexing an open field is only supported on the record part");
            }
            for (int i = 0; i < index.getKeyFieldNames().size(); ++i) {
                int j;
                ArrayDeque<Pair> nestedTypeStack = new ArrayDeque<Pair>();
                List<String> splits = index.getKeyFieldNames().get(i);
                ARecordType nestedFieldType = enforcedRecordType;
                boolean openRecords = false;
                String bridgeName = nestedFieldType.getTypeName();
                for (j = 1; j < splits.size(); ++j) {
                    nestedTypeStack.push(new Pair((Object)nestedFieldType, (Object)splits.get(j - 1)));
                    bridgeName = nestedFieldType.getTypeName();
                    nestedFieldType = (ARecordType)enforcedRecordType.getSubFieldType(splits.subList(0, j));
                    if (nestedFieldType != null) continue;
                    openRecords = true;
                    break;
                }
                if (openRecords) {
                    enforcedRecordType = new ARecordType(splits.get(splits.size() - 2), new String[]{splits.get(splits.size() - 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)index.getKeyFieldTypes().get(i))}, true);
                    for (int k = splits.size() - 3; k > j - 2; --k) {
                        enforcedRecordType = new ARecordType(splits.get(k), new String[]{splits.get(k + 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)enforcedRecordType)}, true);
                    }
                    Pair gapPair = (Pair)nestedTypeStack.pop();
                    ARecordType parent = (ARecordType)gapPair.first;
                    IAType[] parentFieldTypes = (IAType[])ArrayUtils.addAll((Object[])((Object[])parent.getFieldTypes().clone()), (Object[])new IAType[]{AUnionType.createUnknownableType((IAType)enforcedRecordType)});
                    enforcedRecordType = new ARecordType(bridgeName, (String[])ArrayUtils.addAll((Object[])parent.getFieldNames(), (Object[])new String[]{enforcedRecordType.getTypeName()}), parentFieldTypes, true);
                } else {
                    Map<String, IAType> recordNameTypesMap = TypeUtil.createRecordNameTypeMap(nestedFieldType);
                    IAType enforcedFieldType = recordNameTypesMap.get(splits.get(splits.size() - 1));
                    if (enforcedFieldType != null && enforcedFieldType.getTypeTag() == ATypeTag.UNION && ((AUnionType)enforcedFieldType).isUnknownableType()) {
                        enforcedFieldType = ((AUnionType)enforcedFieldType).getActualType();
                    }
                    if (enforcedFieldType != null && !ATypeHierarchy.canPromote((ATypeTag)enforcedFieldType.getTypeTag(), (ATypeTag)index.getKeyFieldTypes().get(i).getTypeTag())) {
                        throw new AlgebricksException("Cannot enforce field " + index.getKeyFieldNames().get(i) + " to have type " + index.getKeyFieldTypes().get(i));
                    }
                    if (enforcedFieldType == null) {
                        recordNameTypesMap.put(splits.get(splits.size() - 1), AUnionType.createUnknownableType((IAType)index.getKeyFieldTypes().get(i)));
                    }
                    enforcedRecordType = new ARecordType(nestedFieldType.getTypeName(), recordNameTypesMap.keySet().toArray(new String[recordNameTypesMap.size()]), recordNameTypesMap.values().toArray(new IAType[recordNameTypesMap.size()]), nestedFieldType.isOpen());
                }
                if (nestedTypeStack.isEmpty()) continue;
                while (!nestedTypeStack.isEmpty()) {
                    Pair nestedTypePair = (Pair)nestedTypeStack.pop();
                    ARecordType nestedRecType = (ARecordType)nestedTypePair.first;
                    IAType[] nestedRecTypeFieldTypes = (IAType[])nestedRecType.getFieldTypes().clone();
                    nestedRecTypeFieldTypes[nestedRecType.getFieldIndex((String)((String)nestedTypePair.second))] = enforcedRecordType;
                    enforcedRecordType = new ARecordType(nestedRecType.getTypeName() + "_enforced", nestedRecType.getFieldNames(), nestedRecTypeFieldTypes, nestedRecType.isOpen());
                }
            }
        }
        return new Pair((Object)enforcedRecordType, (Object)enforcedMetaType);
    }

    public static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
        LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
        for (int j = 0; j < recordType.getFieldNames().length; ++j) {
            recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
        }
        return recordNameTypesMap;
    }
}

