/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.Map;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexCompactOperatorDescriptor;

public abstract class SecondaryTreeIndexOperationsHelper
extends SecondaryIndexOperationsHelper {
    protected SecondaryTreeIndexOperationsHelper(Dataset dataset, Index index, PhysicalOptimizationConfig physOptConf, IPropertiesProvider propertiesProvider, MetadataProvider metadataProvider, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType) {
        super(dataset, index, physOptConf, propertiesProvider, metadataProvider, recType, metaType, enforcedType, enforcedMetaType);
    }

    @Override
    public JobSpecification buildDropJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset, this.index.getIndexName());
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this.dataset, this.metadataProvider.getMetadataTxnContext());
        ARecordType recordType = (ARecordType)this.metadataProvider.findType(this.dataset.getItemTypeDataverseName(), this.dataset.getItemTypeName());
        ARecordType metaType = DatasetUtil.getMetaType(this.metadataProvider, this.dataset);
        IIndexDataflowHelperFactory dataflowHelperFactory = this.dataset.getIndexDataflowHelperFactory(this.metadataProvider, this.index, recordType, metaType, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
        IndexDropOperatorDescriptor btreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)spec, storageComponentProvider.getStorageManager(), storageComponentProvider.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, dataflowHelperFactory, (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)btreeDrop, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)btreeDrop);
        return spec;
    }

    @Override
    public JobSpecification buildCompactJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        IIndexDataflowHelperFactory indexDataflowHelperFactory = this.dataset.getIndexDataflowHelperFactory(this.metadataProvider, this.index, this.itemType, this.metaType, this.mergePolicyFactory, this.mergePolicyFactoryProperties);
        LSMTreeIndexCompactOperatorDescriptor compactOp = new LSMTreeIndexCompactOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.metadataProvider.getStorageComponentProvider().getStorageManager(), this.metadataProvider.getStorageComponentProvider().getIndexLifecycleManagerProvider(), this.secondaryFileSplitProvider, this.secondaryTypeTraits, this.secondaryComparatorFactories, this.secondaryBloomFilterKeyFields, indexDataflowHelperFactory, this.dataset.getModificationCallbackFactory(this.metadataProvider.getStorageComponentProvider(), this.index, null, IndexOperation.FULL_MERGE, null), (IPageManagerFactory)this.metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        spec.addRoot((IOperatorDescriptor)compactOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }
}

