/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.transactions.IResourceFactory;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.transaction.management.resource.LSMInvertedIndexLocalResourceMetadataFactory;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceFactoryProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexCompactOperator;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexCreateOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.common.file.ILocalResourceFactoryProvider;

public class SecondaryInvertedIndexOperationsHelper
extends SecondaryIndexOperationsHelper {
    private IAType secondaryKeyType;
    private ITypeTraits[] invListsTypeTraits;
    private IBinaryComparatorFactory[] tokenComparatorFactories;
    private ITypeTraits[] tokenTypeTraits;
    private IBinaryTokenizerFactory tokenizerFactory;
    private int numTokenKeyPairFields;
    private IBinaryComparatorFactory[] tokenKeyPairComparatorFactories;
    private RecordDescriptor tokenKeyPairRecDesc;
    private boolean isPartitioned;
    private int[] invertedIndexFields;
    private int[] invertedIndexFieldsForNonBulkLoadOps;
    private int[] secondaryFilterFieldsForNonBulkLoadOps;

    protected SecondaryInvertedIndexOperationsHelper(Dataset dataset, Index index, PhysicalOptimizationConfig physOptConf, IPropertiesProvider propertiesProvider, MetadataProvider metadataProvider, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType) {
        super(dataset, index, physOptConf, propertiesProvider, metadataProvider, recType, metaType, enforcedType, enforcedMetaType);
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        Pair<IAType, Boolean> keyTypePair;
        int numSecondaryKeys = this.index.getKeyFieldNames().size();
        DatasetConfig.IndexType indexType = this.index.getIndexType();
        boolean isEnforcingKeyTypes = this.index.isEnforcingKeyFileds();
        if (this.numPrimaryKeys > 1) {
            throw new CompilationException(1015, new Serializable[]{indexType, RecordUtil.toFullyQualifiedName((String[])new String[]{this.dataset.getDataverseName(), this.dataset.getDatasetName()})});
        }
        if (numSecondaryKeys > 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(numSecondaryKeys), indexType, Integer.valueOf(1)});
        }
        this.isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        this.secondaryFieldAccessEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeys + this.numFilterFields];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + numSecondaryKeys + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[numSecondaryKeys + this.numPrimaryKeys];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = FormatUtils.getDefaultFormat().getSerdeProvider();
        ITypeTraitProvider typeTraitProvider = FormatUtils.getDefaultFormat().getTypeTraitProvider();
        if (numSecondaryKeys > 0) {
            ISerializerDeserializer keySerde;
            this.secondaryFieldAccessEvalFactories[0] = FormatUtils.getDefaultFormat().getFieldAccessEvaluatorFactory(isEnforcingKeyTypes ? this.enforcedItemType : this.itemType, this.index.getKeyFieldNames().get(0), this.numPrimaryKeys);
            keyTypePair = Index.getNonNullableOpenFieldType(this.index.getKeyFieldTypes().get(0), this.index.getKeyFieldNames().get(0), this.itemType);
            this.secondaryKeyType = (IAType)keyTypePair.first;
            this.anySecondaryKeyIsNullable = this.anySecondaryKeyIsNullable || (Boolean)keyTypePair.second != false;
            secondaryRecFields[0] = keySerde = serdeProvider.getSerializerDeserializer((Object)this.secondaryKeyType);
            this.secondaryTypeTraits[0] = typeTraitProvider.getTypeTrait((Object)this.secondaryKeyType);
        }
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            this.secondaryFieldAccessEvalFactories[numSecondaryKeys] = FormatUtils.getDefaultFormat().getFieldAccessEvaluatorFactory(this.itemType, this.filterFieldName, this.numPrimaryKeys);
            keyTypePair = Index.getNonNullableKeyFieldType(this.filterFieldName, this.itemType);
            IAType type = (IAType)keyTypePair.first;
            secondaryRecFields[this.numPrimaryKeys + numSecondaryKeys] = serde = serdeProvider.getSerializerDeserializer((Object)type);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields);
        int numTokenFields = !this.isPartitioned ? numSecondaryKeys : numSecondaryKeys + 1;
        this.tokenComparatorFactories = new IBinaryComparatorFactory[numTokenFields];
        this.tokenTypeTraits = new ITypeTraits[numTokenFields];
        this.tokenComparatorFactories[0] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)this.secondaryKeyType);
        this.tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)this.secondaryKeyType);
        if (this.isPartitioned) {
            this.tokenComparatorFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)ShortPointable.FACTORY);
            this.tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
        }
        this.tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)this.secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)this.index.getGramLength());
        this.invListsTypeTraits = new ITypeTraits[this.numPrimaryKeys];
        if (this.numPrimaryKeys > 0) {
            this.invListsTypeTraits[0] = this.primaryRecDesc.getTypeTraits()[0];
            enforcedRecFields[0] = this.primaryRecDesc.getFields()[0];
            enforcedTypeTraits[0] = this.primaryRecDesc.getTypeTraits()[0];
        }
        enforcedRecFields[this.numPrimaryKeys] = serdeProvider.getSerializerDeserializer((Object)this.itemType);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
        this.numTokenKeyPairFields = !this.isPartitioned ? 1 + this.numPrimaryKeys : 2 + this.numPrimaryKeys;
        ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[this.numTokenKeyPairFields + this.numFilterFields];
        ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[this.numTokenKeyPairFields];
        this.tokenKeyPairComparatorFactories = new IBinaryComparatorFactory[this.numTokenKeyPairFields];
        tokenKeyPairFields[0] = serdeProvider.getSerializerDeserializer((Object)this.secondaryKeyType);
        tokenKeyPairTypeTraits[0] = this.tokenTypeTraits[0];
        this.tokenKeyPairComparatorFactories[0] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)this.secondaryKeyType);
        int pkOff = 1;
        if (this.isPartitioned) {
            tokenKeyPairFields[1] = ShortSerializerDeserializer.INSTANCE;
            tokenKeyPairTypeTraits[1] = this.tokenTypeTraits[1];
            this.tokenKeyPairComparatorFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)ShortPointable.FACTORY);
            pkOff = 2;
        }
        if (this.numPrimaryKeys > 0) {
            tokenKeyPairFields[pkOff] = this.primaryRecDesc.getFields()[0];
            tokenKeyPairTypeTraits[pkOff] = this.primaryRecDesc.getTypeTraits()[0];
            this.tokenKeyPairComparatorFactories[pkOff] = this.primaryComparatorFactories[0];
        }
        if (this.numFilterFields > 0) {
            tokenKeyPairFields[this.numPrimaryKeys + pkOff] = secondaryRecFields[this.numPrimaryKeys + numSecondaryKeys];
        }
        this.tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
        if (this.filterFieldName != null) {
            int i;
            this.invertedIndexFields = new int[this.numTokenKeyPairFields];
            for (i = 0; i < this.invertedIndexFields.length; ++i) {
                this.invertedIndexFields[i] = i;
            }
            this.secondaryFilterFieldsForNonBulkLoadOps = new int[this.numFilterFields];
            this.secondaryFilterFieldsForNonBulkLoadOps[0] = numSecondaryKeys + this.numPrimaryKeys;
            this.invertedIndexFieldsForNonBulkLoadOps = new int[numSecondaryKeys + this.numPrimaryKeys];
            for (i = 0; i < this.invertedIndexFieldsForNonBulkLoadOps.length; ++i) {
                this.invertedIndexFieldsForNonBulkLoadOps[i] = i;
            }
        }
    }

    @Override
    protected int getNumSecondaryKeys() {
        return this.numTokenKeyPairFields - this.numPrimaryKeys;
    }

    @Override
    public JobSpecification buildCreationJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        LSMInvertedIndexLocalResourceMetadataFactory localResourceMetadata = new LSMInvertedIndexLocalResourceMetadataFactory(this.invListsTypeTraits, this.primaryComparatorFactories, this.tokenTypeTraits, this.tokenComparatorFactories, this.tokenizerFactory, this.isPartitioned, this.dataset.getDatasetId(), this.mergePolicyFactory, this.mergePolicyFactoryProperties, this.filterTypeTraits, this.filterCmpFactories, this.invertedIndexFields, this.secondaryFilterFields, this.secondaryFilterFieldsForNonBulkLoadOps, this.invertedIndexFieldsForNonBulkLoadOps, this.dataset.getIndexOperationTrackerFactory(this.index), this.dataset.getIoOperationCallbackFactory(this.index), storageComponentProvider.getMetadataPageManagerFactory());
        PersistentLocalResourceFactoryProvider localResourceFactoryProvider = new PersistentLocalResourceFactoryProvider((IResourceFactory)localResourceMetadata, 3);
        IIndexDataflowHelperFactory dataflowHelperFactory = this.createDataflowHelperFactory();
        LSMInvertedIndexCreateOperatorDescriptor invIndexCreateOp = new LSMInvertedIndexCreateOperatorDescriptor((IOperatorDescriptorRegistry)spec, storageComponentProvider.getStorageManager(), this.secondaryFileSplitProvider, storageComponentProvider.getIndexLifecycleManagerProvider(), this.tokenTypeTraits, this.tokenComparatorFactories, this.invListsTypeTraits, this.primaryComparatorFactories, this.tokenizerFactory, dataflowHelperFactory, (ILocalResourceFactoryProvider)localResourceFactoryProvider, this.dataset.getModificationCallbackFactory(storageComponentProvider, this.index, null, IndexOperation.CREATE, null), (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)invIndexCreateOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        spec.addRoot((IOperatorDescriptor)invIndexCreateOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        BTreeSearchOperatorDescriptor primaryScanOp;
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        AbstractOperatorDescriptor keyProviderOp = this.createDummyKeyProviderOp(spec);
        BTreeSearchOperatorDescriptor sourceOp = primaryScanOp = this.createPrimaryIndexScanOp(spec);
        boolean isEnforcingKeyTypes = this.index.isEnforcingKeyFileds();
        int numSecondaryKeys = this.index.getKeyFieldNames().size();
        if (isEnforcingKeyTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
            sourceOp = this.createCastOp(spec, this.dataset.getDatasetType());
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)primaryScanOp, 0, (IOperatorDescriptor)sourceOp, 0);
        }
        AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createAssignOp(spec, numSecondaryKeys, this.secondaryRecDesc);
        AlgebricksMetaOperatorDescriptor selectOp = null;
        if (this.anySecondaryKeyIsNullable || isEnforcingKeyTypes) {
            selectOp = this.createFilterNullsSelectOp(spec, numSecondaryKeys, this.secondaryRecDesc);
        }
        AbstractOperatorDescriptor tokenizerOp = this.createTokenizerOp(spec);
        ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, this.tokenKeyPairComparatorFactories, this.tokenKeyPairRecDesc);
        LSMInvertedIndexBulkLoadOperatorDescriptor invIndexBulkLoadOp = this.createInvertedIndexBulkLoadOp(spec);
        AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{new SinkRuntimeFactory()}, new RecordDescriptor[0]);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)keyProviderOp, 0, (IOperatorDescriptor)primaryScanOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sourceOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
        if (this.anySecondaryKeyIsNullable || isEnforcingKeyTypes) {
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)selectOp, 0);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)selectOp, 0, (IOperatorDescriptor)tokenizerOp, 0);
        } else {
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, (IOperatorDescriptor)tokenizerOp, 0);
        }
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)tokenizerOp, 0, (IOperatorDescriptor)sortOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)invIndexBulkLoadOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)invIndexBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
        spec.addRoot((IOperatorDescriptor)metaOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    private AbstractOperatorDescriptor createTokenizerOp(JobSpecification spec) throws AlgebricksException {
        int docField = 0;
        int numSecondaryKeys = this.index.getKeyFieldNames().size();
        int[] primaryKeyFields = new int[this.numPrimaryKeys + this.numFilterFields];
        for (int i = 0; i < primaryKeyFields.length; ++i) {
            primaryKeyFields[i] = numSecondaryKeys + i;
        }
        BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.tokenKeyPairRecDesc, this.tokenizerFactory, docField, primaryKeyFields, this.isPartitioned, false);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)tokenizerOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return tokenizerOp;
    }

    @Override
    protected ExternalSortOperatorDescriptor createSortOp(JobSpecification spec, IBinaryComparatorFactory[] secondaryComparatorFactories, RecordDescriptor secondaryRecDesc) {
        int[] sortFields = new int[this.numTokenKeyPairFields];
        for (int i = 0; i < this.numTokenKeyPairFields; ++i) {
            sortFields[i] = i;
        }
        ExternalSortOperatorDescriptor sortOp = new ExternalSortOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.physOptConf.getMaxFramesExternalSort(), sortFields, this.tokenKeyPairComparatorFactories, secondaryRecDesc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)sortOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return sortOp;
    }

    private LSMInvertedIndexBulkLoadOperatorDescriptor createInvertedIndexBulkLoadOp(JobSpecification spec) throws AlgebricksException {
        int[] fieldPermutation = new int[this.numTokenKeyPairFields + this.numFilterFields];
        for (int i = 0; i < fieldPermutation.length; ++i) {
            fieldPermutation[i] = i;
        }
        IIndexDataflowHelperFactory dataflowHelperFactory = this.createDataflowHelperFactory();
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        LSMInvertedIndexBulkLoadOperatorDescriptor invIndexBulkLoadOp = new LSMInvertedIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.secondaryRecDesc, fieldPermutation, false, this.numElementsHint, false, storageComponentProvider.getStorageManager(), this.secondaryFileSplitProvider, storageComponentProvider.getIndexLifecycleManagerProvider(), this.tokenTypeTraits, this.tokenComparatorFactories, this.invListsTypeTraits, this.primaryComparatorFactories, this.tokenizerFactory, dataflowHelperFactory, (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)invIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return invIndexBulkLoadOp;
    }

    private IIndexDataflowHelperFactory createDataflowHelperFactory() throws AlgebricksException {
        return this.dataset.getIndexDataflowHelperFactory(this.metadataProvider, this.index, this.itemType, this.metaType, this.mergePolicyFactory, this.mergePolicyFactoryProperties);
    }

    @Override
    public JobSpecification buildCompactJobSpec() throws AsterixException, AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        IIndexDataflowHelperFactory dataflowHelperFactory = this.createDataflowHelperFactory();
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        LSMInvertedIndexCompactOperator compactOp = new LSMInvertedIndexCompactOperator((IOperatorDescriptorRegistry)spec, storageComponentProvider.getStorageManager(), this.secondaryFileSplitProvider, storageComponentProvider.getIndexLifecycleManagerProvider(), this.tokenTypeTraits, this.tokenComparatorFactories, this.invListsTypeTraits, this.primaryComparatorFactories, this.tokenizerFactory, dataflowHelperFactory, this.dataset.getModificationCallbackFactory(storageComponentProvider, this.index, null, IndexOperation.FULL_MERGE, null), (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        spec.addRoot((IOperatorDescriptor)compactOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    public JobSpecification buildDropJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        IStorageComponentProvider storageComponentProvider = this.metadataProvider.getStorageComponentProvider();
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset, this.index.getIndexName());
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this.dataset, this.metadataProvider.getMetadataTxnContext());
        ARecordType recordType = (ARecordType)this.metadataProvider.findType(this.dataset.getItemTypeDataverseName(), this.dataset.getItemTypeName());
        ARecordType metaType = DatasetUtil.getMetaType(this.metadataProvider, this.dataset);
        IIndexDataflowHelperFactory dataflowHelperFactory = this.dataset.getIndexDataflowHelperFactory(this.metadataProvider, this.index, recordType, metaType, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
        LSMInvertedIndexDropOperatorDescriptor invIdxDrop = new LSMInvertedIndexDropOperatorDescriptor((IOperatorDescriptorRegistry)spec, storageComponentProvider.getStorageManager(), storageComponentProvider.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, dataflowHelperFactory, (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)invIdxDrop, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)invIdxDrop);
        return spec;
    }
}

