/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.api.IIndexDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.PartitionedLSMInvertedIndexDataflowHelperFactory;

public class InvertedIndexDataflowHelperFactoryProvider
implements IIndexDataflowHelperFactoryProvider {
    public static final InvertedIndexDataflowHelperFactoryProvider INSTANCE = new InvertedIndexDataflowHelperFactoryProvider();

    private InvertedIndexDataflowHelperFactoryProvider() {
    }

    @Override
    public IIndexDataflowHelperFactory getIndexDataflowHelperFactory(MetadataProvider mdProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories) throws AlgebricksException {
        List<List<String>> primaryKeys = DatasetUtil.getPartitioningKeys(dataset);
        List<List<String>> secondaryKeys = index.getKeyFieldNames();
        List<String> filterFieldName = DatasetUtil.getFilterField(dataset);
        int numPrimaryKeys = primaryKeys.size();
        int numSecondaryKeys = secondaryKeys.size();
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            throw new CompilationException(1016, new Serializable[]{index.getIndexType().name(), dataset.getDatasetType()});
        }
        if (numPrimaryKeys > 1) {
            throw new AsterixException("Cannot create inverted index on dataset with composite primary key.");
        }
        if (numSecondaryKeys > 1) {
            throw new AsterixException("Cannot create composite inverted index on multiple fields.");
        }
        boolean isPartitioned = index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numTokenKeyPairFields = !isPartitioned ? 1 + numPrimaryKeys : 2 + numPrimaryKeys;
        int[] invertedIndexFields = null;
        int[] secondaryFilterFieldsForNonBulkLoadOps = null;
        int[] invertedIndexFieldsForNonBulkLoadOps = null;
        int[] secondaryFilterFields = null;
        if (filterFieldName != null) {
            int i;
            invertedIndexFields = new int[numTokenKeyPairFields];
            for (i = 0; i < invertedIndexFields.length; ++i) {
                invertedIndexFields[i] = i;
            }
            secondaryFilterFieldsForNonBulkLoadOps = new int[filterFieldName.size()];
            secondaryFilterFieldsForNonBulkLoadOps[0] = numSecondaryKeys + numPrimaryKeys;
            invertedIndexFieldsForNonBulkLoadOps = new int[numSecondaryKeys + numPrimaryKeys];
            for (i = 0; i < invertedIndexFieldsForNonBulkLoadOps.length; ++i) {
                invertedIndexFieldsForNonBulkLoadOps[i] = i;
            }
            secondaryFilterFields = new int[filterFieldName.size()];
            secondaryFilterFields[0] = numTokenKeyPairFields - numPrimaryKeys + numPrimaryKeys;
        }
        IStorageComponentProvider storageComponentProvider = mdProvider.getStorageComponentProvider();
        if (!isPartitioned) {
            return new LSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, secondaryFilterFields, secondaryFilterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !dataset.getDatasetDetails().isTemp());
        }
        return new PartitionedLSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, secondaryFilterFields, secondaryFilterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !dataset.getDatasetDetails().isTemp());
    }
}

