/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.transactions.IResourceFactory;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IIndexingAdapterFactory;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalDatasetIndexesAbortOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalDatasetIndexesCommitOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalDatasetIndexesRecoverOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalFilesIndexOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.external.operators.IndexInfoOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.declared.BTreeDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.utils.RuntimeComponentsProvider;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.transaction.management.resource.ExternalBTreeLocalResourceMetadataFactory;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceFactoryProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexCompactOperatorDescriptor;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.file.ILocalResourceFactoryProvider;

public class ExternalIndexingOperations {
    private static final Logger LOGGER = Logger.getLogger(ExternalIndexingOperations.class.getName());
    public static final List<List<String>> FILE_INDEX_FIELD_NAMES = Collections.unmodifiableList(Collections.singletonList(Collections.singletonList("")));
    public static final List<IAType> FILE_INDEX_FIELD_TYPES = Collections.unmodifiableList(Collections.singletonList(BuiltinType.ASTRING));

    private ExternalIndexingOperations() {
    }

    public static boolean isIndexible(ExternalDatasetDetails ds) {
        String adapter = ds.getAdapter();
        return adapter.equalsIgnoreCase("hdfs");
    }

    public static boolean isRefereshActive(ExternalDatasetDetails ds) {
        return ds.getState() != DatasetConfig.TransactionState.COMMIT;
    }

    public static boolean isValidIndexName(String datasetName, String indexName) {
        return !datasetName.concat("FilesIndex").equals(indexName);
    }

    public static int getRIDSize(Dataset dataset) {
        ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
        return IndexingConstants.getRIDSize((String)dsd.getProperties().get("input-format"));
    }

    public static IBinaryComparatorFactory[] getComparatorFactories(Dataset dataset) {
        ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
        return IndexingConstants.getComparatorFactories((String)dsd.getProperties().get("input-format"));
    }

    public static IBinaryComparatorFactory[] getBuddyBtreeComparatorFactories() {
        return IndexingConstants.getBuddyBtreeComparatorFactories();
    }

    public static List<ExternalFile> getSnapshotFromExternalFileSystem(Dataset dataset) throws AlgebricksException {
        ArrayList<ExternalFile> files = new ArrayList<ExternalFile>();
        ExternalDatasetDetails datasetDetails = (ExternalDatasetDetails)dataset.getDatasetDetails();
        try {
            String[] paths;
            FileSystem fs = ExternalIndexingOperations.getFileSystemObject(datasetDetails.getProperties());
            String path = datasetDetails.getProperties().get("path");
            for (String aPath : paths = path.split(",")) {
                FileStatus[] fileStatuses = fs.listStatus(new Path(aPath));
                for (int i = 0; i < fileStatuses.length; ++i) {
                    int nextFileNumber = files.size();
                    ExternalIndexingOperations.handleFile(dataset, files, fs, fileStatuses[i], nextFileNumber);
                }
            }
            fs.close();
            if (files.isEmpty()) {
                throw new AlgebricksException("File Snapshot retrieved from external file system is empty");
            }
            return files;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while trying to get snapshot from external system", e);
            throw new AlgebricksException("Unable to get list of HDFS files " + e);
        }
    }

    private static void handleFile(Dataset dataset, List<ExternalFile> files, FileSystem fs, FileStatus fileStatus, int nextFileNumber) throws IOException {
        if (fileStatus.isDirectory()) {
            ExternalIndexingOperations.listSubFiles(dataset, fs, fileStatus, files);
        } else {
            files.add(new ExternalFile(dataset.getDataverseName(), dataset.getDatasetName(), nextFileNumber, fileStatus.getPath().toUri().getPath(), new Date(fileStatus.getModificationTime()), fileStatus.getLen(), DatasetConfig.ExternalFilePendingOp.NO_OP));
        }
    }

    private static void listSubFiles(Dataset dataset, FileSystem srcFs, FileStatus src, List<ExternalFile> files) throws IOException {
        Path path = src.getPath();
        FileStatus[] fileStatuses = srcFs.listStatus(path);
        for (int i = 0; i < fileStatuses.length; ++i) {
            int nextFileNumber = files.size();
            if (fileStatuses[i].isDirectory()) {
                ExternalIndexingOperations.listSubFiles(dataset, srcFs, fileStatuses[i], files);
                continue;
            }
            files.add(new ExternalFile(dataset.getDataverseName(), dataset.getDatasetName(), nextFileNumber, fileStatuses[i].getPath().toUri().getPath(), new Date(fileStatuses[i].getModificationTime()), fileStatuses[i].getLen(), DatasetConfig.ExternalFilePendingOp.NO_OP));
        }
    }

    public static FileSystem getFileSystemObject(Map<String, String> map) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", map.get("hdfs").trim());
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        return FileSystem.get((Configuration)conf);
    }

    public static JobSpecification buildFilesIndexReplicationJobSpec(Dataset dataset, List<ExternalFile> externalFilesSnapshot, MetadataProvider metadataProvider, boolean createIndex) throws AlgebricksException {
        IStorageComponentProvider storageComponentProvider = metadataProvider.getStorageComponentProvider();
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        Map mergePolicyFactoryProperties = (Map)compactionInfo.second;
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> secondarySplitsAndConstraint = metadataProvider.splitProviderAndPartitionConstraintsForFilesIndex(dataset.getDataverseName(), dataset.getDatasetName(), IndexingConstants.getFilesIndexName((String)dataset.getDatasetName()), true);
        IFileSplitProvider secondaryFileSplitProvider = (IFileSplitProvider)secondarySplitsAndConstraint.first;
        FilesIndexDescription filesIndexDescription = new FilesIndexDescription();
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(dataset);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getDatasetName(), fileIndexName);
        ExternalBTreeLocalResourceMetadataFactory localResourceMetadata = new ExternalBTreeLocalResourceMetadataFactory(filesIndexDescription.EXTERNAL_FILE_INDEX_TYPE_TRAITS, FilesIndexDescription.FILES_INDEX_COMP_FACTORIES, new int[]{0}, false, dataset.getDatasetId(), mergePolicyFactory, mergePolicyFactoryProperties, dataset.getIndexOperationTrackerFactory(fileIndex), dataset.getIoOperationCallbackFactory(fileIndex), storageComponentProvider.getMetadataPageManagerFactory());
        PersistentLocalResourceFactoryProvider localResourceFactoryProvider = new PersistentLocalResourceFactoryProvider((IResourceFactory)localResourceMetadata, 4);
        IIndexDataflowHelperFactory dataflowHelperFactory = dataset.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
        ExternalFilesIndexOperatorDescriptor externalFilesOp = new ExternalFilesIndexOperatorDescriptor((IOperatorDescriptorRegistry)spec, storageComponentProvider.getStorageManager(), storageComponentProvider.getIndexLifecycleManagerProvider(), secondaryFileSplitProvider, dataflowHelperFactory, (ILocalResourceFactoryProvider)localResourceFactoryProvider, externalFilesSnapshot, createIndex, storageComponentProvider.getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)externalFilesOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)secondarySplitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)externalFilesOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    private static Pair<ExternalScanOperatorDescriptor, AlgebricksPartitionConstraint> getIndexingOperator(MetadataProvider metadataProvider, JobSpecification jobSpec, IAType itemType, Dataset dataset, List<ExternalFile> files, RecordDescriptor indexerDesc) throws HyracksDataException, AlgebricksException {
        ExternalDatasetDetails externalDatasetDetails = (ExternalDatasetDetails)dataset.getDatasetDetails();
        Map<String, String> configuration = externalDatasetDetails.getProperties();
        IIndexingAdapterFactory adapterFactory = AdapterFactoryProvider.getIndexingAdapterFactory((ILibraryManager)metadataProvider.getLibraryManager(), (String)externalDatasetDetails.getAdapter(), configuration, (ARecordType)((ARecordType)itemType), files, (boolean)true, null);
        return new Pair((Object)new ExternalScanOperatorDescriptor(jobSpec, indexerDesc, (IAdapterFactory)adapterFactory), (Object)adapterFactory.getPartitionConstraint());
    }

    public static Pair<ExternalScanOperatorDescriptor, AlgebricksPartitionConstraint> createExternalIndexingOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, ARecordType itemType, RecordDescriptor indexerDesc, List<ExternalFile> files) throws HyracksDataException, AlgebricksException {
        return ExternalIndexingOperations.getIndexingOperator(metadataProvider, spec, (IAType)itemType, dataset, files == null ? MetadataManager.INSTANCE.getDatasetExternalFiles(metadataProvider.getMetadataTxnContext(), dataset) : files, indexerDesc);
    }

    public static boolean isDatasetUptodate(Dataset dataset, List<ExternalFile> metadataFiles, List<ExternalFile> addedFiles, List<ExternalFile> deletedFiles, List<ExternalFile> appendedFiles) throws AlgebricksException {
        boolean uptodate = true;
        int newFileNumber = metadataFiles.get(metadataFiles.size() - 1).getFileNumber() + 1;
        List<ExternalFile> fileSystemFiles = ExternalIndexingOperations.getSnapshotFromExternalFileSystem(dataset);
        for (ExternalFile fileSystemFile : fileSystemFiles) {
            boolean fileFound = false;
            Iterator<ExternalFile> mdFilesIterator = metadataFiles.iterator();
            while (mdFilesIterator.hasNext()) {
                ExternalFile metadataFile = mdFilesIterator.next();
                if (!fileSystemFile.getFileName().equals(metadataFile.getFileName())) continue;
                if (fileSystemFile.getLastModefiedTime().equals(metadataFile.getLastModefiedTime())) {
                    if (fileSystemFile.getSize() == metadataFile.getSize()) {
                        mdFilesIterator.remove();
                        fileFound = true;
                    } else {
                        metadataFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.APPEND_OP);
                        fileSystemFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.APPEND_OP);
                        appendedFiles.add(fileSystemFile);
                        fileFound = true;
                        uptodate = false;
                    }
                } else {
                    metadataFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.DROP_OP);
                    deletedFiles.add(new ExternalFile(metadataFile.getDataverseName(), metadataFile.getDatasetName(), 0, metadataFile.getFileName(), metadataFile.getLastModefiedTime(), metadataFile.getSize(), DatasetConfig.ExternalFilePendingOp.DROP_OP));
                    fileSystemFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.ADD_OP);
                    fileSystemFile.setFileNumber(newFileNumber);
                    addedFiles.add(fileSystemFile);
                    ++newFileNumber;
                    fileFound = true;
                    uptodate = false;
                }
                if (!fileFound) continue;
                break;
            }
            if (fileFound) continue;
            fileSystemFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.ADD_OP);
            fileSystemFile.setFileNumber(newFileNumber);
            addedFiles.add(fileSystemFile);
            ++newFileNumber;
            uptodate = false;
        }
        for (ExternalFile deletedFile : deletedFiles) {
            deletedFile.setFileNumber(newFileNumber);
            ++newFileNumber;
        }
        for (ExternalFile appendedFile : appendedFiles) {
            appendedFile.setFileNumber(newFileNumber);
            ++newFileNumber;
        }
        for (ExternalFile metadataFile : metadataFiles) {
            if (metadataFile.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
            metadataFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.DROP_OP);
            deletedFiles.add(new ExternalFile(metadataFile.getDataverseName(), metadataFile.getDatasetName(), newFileNumber, metadataFile.getFileName(), metadataFile.getLastModefiedTime(), metadataFile.getSize(), metadataFile.getPendingOp()));
            ++newFileNumber;
            uptodate = false;
        }
        return uptodate;
    }

    public static Dataset createTransactionDataset(Dataset dataset) {
        ExternalDatasetDetails originalDsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
        ExternalDatasetDetails dsd = new ExternalDatasetDetails(originalDsd.getAdapter(), originalDsd.getProperties(), originalDsd.getTimestamp(), DatasetConfig.TransactionState.BEGIN);
        return new Dataset(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName(), dataset.getNodeGroupName(), dataset.getCompactionPolicy(), dataset.getCompactionPolicyProperties(), dsd, dataset.getHints(), DatasetConfig.DatasetType.EXTERNAL, dataset.getDatasetId(), dataset.getPendingOp());
    }

    public static JobSpecification buildDropFilesIndexJobSpec(MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        String indexName = IndexingConstants.getFilesIndexName((String)dataset.getDatasetName());
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = metadataProvider.splitProviderAndPartitionConstraintsForFilesIndex(dataset.getDataverseName(), dataset.getDatasetName(), indexName, true);
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(dataset);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getDatasetName(), fileIndexName);
        IIndexDataflowHelperFactory dataflowHelperFactory = dataset.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
        IndexDropOperatorDescriptor btreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)spec, metadataProvider.getStorageComponentProvider().getStorageManager(), metadataProvider.getStorageComponentProvider().getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, dataflowHelperFactory, (IPageManagerFactory)metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)btreeDrop, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        spec.addRoot((IOperatorDescriptor)btreeDrop);
        return spec;
    }

    public static JobSpecification buildFilesIndexUpdateOp(Dataset ds, List<ExternalFile> metadataFiles, List<ExternalFile> addedFiles, List<ExternalFile> appendedFiles, MetadataProvider metadataProvider) throws AlgebricksException {
        ArrayList<ExternalFile> files = new ArrayList<ExternalFile>();
        for (ExternalFile file : metadataFiles) {
            if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                files.add(file);
                continue;
            }
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.APPEND_OP) continue;
            for (ExternalFile appendedFile : appendedFiles) {
                if (!appendedFile.getFileName().equals(file.getFileName())) continue;
                files.add(new ExternalFile(file.getDataverseName(), file.getDatasetName(), file.getFileNumber(), file.getFileName(), file.getLastModefiedTime(), appendedFile.getSize(), DatasetConfig.ExternalFilePendingOp.NO_OP));
            }
        }
        for (ExternalFile file : addedFiles) {
            files.add(file);
        }
        Collections.sort(files);
        return ExternalIndexingOperations.buildFilesIndexReplicationJobSpec(ds, files, metadataProvider, false);
    }

    public static JobSpecification buildIndexUpdateOp(Dataset ds, Index index, List<ExternalFile> metadataFiles, List<ExternalFile> addedFiles, List<ExternalFile> appendedFiles, MetadataProvider metadataProvider) throws AlgebricksException {
        ArrayList<ExternalFile> files = new ArrayList<ExternalFile>();
        for (ExternalFile metadataFile : metadataFiles) {
            if (metadataFile.getPendingOp() != DatasetConfig.ExternalFilePendingOp.APPEND_OP) {
                files.add(metadataFile);
                continue;
            }
            metadataFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
            files.add(metadataFile);
        }
        for (ExternalFile file : addedFiles) {
            files.add(file);
        }
        for (ExternalFile file : appendedFiles) {
            files.add(file);
        }
        return IndexUtil.buildSecondaryIndexLoadingJobSpec(ds, index, null, null, null, null, metadataProvider, files);
    }

    public static JobSpecification buildCommitJob(Dataset ds, List<Index> indexes, MetadataProvider metadataProvider) throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(ds, metadataProvider.getMetadataTxnContext());
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        Map mergePolicyFactoryProperties = (Map)compactionInfo.second;
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> filesIndexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, IndexingConstants.getFilesIndexName((String)ds.getDatasetName()));
        IFileSplitProvider filesIndexSplitProvider = (IFileSplitProvider)filesIndexSplitsAndConstraint.first;
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(ds);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), ds.getDataverseName(), ds.getDatasetName(), fileIndexName);
        IIndexDataflowHelperFactory filesIndexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
        IndexInfoOperatorDescriptor filesIndexInfo = new IndexInfoOperatorDescriptor(filesIndexSplitProvider, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER);
        ArrayList<IIndexDataflowHelperFactory> treeDataflowHelperFactories = new ArrayList<IIndexDataflowHelperFactory>();
        ArrayList<IndexInfoOperatorDescriptor> treeInfos = new ArrayList<IndexInfoOperatorDescriptor>();
        for (Index index : indexes) {
            if (!ExternalIndexingOperations.isValidIndexName(index.getDatasetName(), index.getIndexName())) continue;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> indexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, index.getIndexName());
            IIndexDataflowHelperFactory indexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, index, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
            treeDataflowHelperFactories.add(indexDataflowHelperFactory);
            treeInfos.add(new IndexInfoOperatorDescriptor((IFileSplitProvider)indexSplitsAndConstraint.first, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER));
        }
        ExternalDatasetIndexesCommitOperatorDescriptor op = new ExternalDatasetIndexesCommitOperatorDescriptor((IOperatorDescriptorRegistry)spec, filesIndexDataflowHelperFactory, filesIndexInfo, treeDataflowHelperFactories, treeInfos);
        spec.addRoot((IOperatorDescriptor)op);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)op, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)filesIndexSplitsAndConstraint.second));
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    public static JobSpecification buildAbortOp(Dataset ds, List<Index> indexes, MetadataProvider metadataProvider) throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(ds, metadataProvider.getMetadataTxnContext());
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        Map mergePolicyFactoryProperties = (Map)compactionInfo.second;
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> filesIndexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, IndexingConstants.getFilesIndexName((String)ds.getDatasetName()));
        IFileSplitProvider filesIndexSplitProvider = (IFileSplitProvider)filesIndexSplitsAndConstraint.first;
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(ds);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), ds.getDataverseName(), ds.getDatasetName(), fileIndexName);
        IIndexDataflowHelperFactory filesIndexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
        IndexInfoOperatorDescriptor filesIndexInfo = new IndexInfoOperatorDescriptor(filesIndexSplitProvider, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER);
        ArrayList<IIndexDataflowHelperFactory> treeDataflowHelperFactories = new ArrayList<IIndexDataflowHelperFactory>();
        ArrayList<IndexInfoOperatorDescriptor> treeInfos = new ArrayList<IndexInfoOperatorDescriptor>();
        for (Index index : indexes) {
            if (!ExternalIndexingOperations.isValidIndexName(index.getDatasetName(), index.getIndexName())) continue;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> indexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, index.getIndexName());
            IIndexDataflowHelperFactory indexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, index, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
            treeDataflowHelperFactories.add(indexDataflowHelperFactory);
            treeInfos.add(new IndexInfoOperatorDescriptor((IFileSplitProvider)indexSplitsAndConstraint.first, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER));
        }
        ExternalDatasetIndexesAbortOperatorDescriptor op = new ExternalDatasetIndexesAbortOperatorDescriptor((IOperatorDescriptorRegistry)spec, filesIndexDataflowHelperFactory, filesIndexInfo, treeDataflowHelperFactories, treeInfos);
        spec.addRoot((IOperatorDescriptor)op);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)op, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)filesIndexSplitsAndConstraint.second));
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    public static JobSpecification buildRecoverOp(Dataset ds, List<Index> indexes, MetadataProvider metadataProvider) throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(ds, metadataProvider.getMetadataTxnContext());
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        Map mergePolicyFactoryProperties = (Map)compactionInfo.second;
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> filesIndexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, IndexingConstants.getFilesIndexName((String)ds.getDatasetName()));
        IFileSplitProvider filesIndexSplitProvider = (IFileSplitProvider)filesIndexSplitsAndConstraint.first;
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(ds);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), ds.getDataverseName(), ds.getDatasetName(), fileIndexName);
        IIndexDataflowHelperFactory filesIndexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
        IndexInfoOperatorDescriptor filesIndexInfo = new IndexInfoOperatorDescriptor(filesIndexSplitProvider, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER);
        ArrayList<IIndexDataflowHelperFactory> treeDataflowHelperFactories = new ArrayList<IIndexDataflowHelperFactory>();
        ArrayList<IndexInfoOperatorDescriptor> treeInfos = new ArrayList<IndexInfoOperatorDescriptor>();
        for (Index index : indexes) {
            if (!ExternalIndexingOperations.isValidIndexName(index.getDatasetName(), index.getIndexName())) continue;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> indexSplitsAndConstraint = metadataProvider.getSplitProviderAndConstraints(ds, index.getIndexName());
            IIndexDataflowHelperFactory indexDataflowHelperFactory = ds.getIndexDataflowHelperFactory(metadataProvider, index, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
            treeDataflowHelperFactories.add(indexDataflowHelperFactory);
            treeInfos.add(new IndexInfoOperatorDescriptor((IFileSplitProvider)indexSplitsAndConstraint.first, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER));
        }
        ExternalDatasetIndexesRecoverOperatorDescriptor op = new ExternalDatasetIndexesRecoverOperatorDescriptor((IOperatorDescriptorRegistry)spec, filesIndexDataflowHelperFactory, filesIndexInfo, treeDataflowHelperFactories, treeInfos);
        spec.addRoot((IOperatorDescriptor)op);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)op, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)filesIndexSplitsAndConstraint.second));
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    public static JobSpecification compactFilesIndexJobSpec(Dataset dataset, MetadataProvider metadataProvider, IStorageComponentProvider storageComponentProvider) throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification();
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        Map mergePolicyFactoryProperties = (Map)compactionInfo.second;
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> secondarySplitsAndConstraint = metadataProvider.splitProviderAndPartitionConstraintsForFilesIndex(dataset.getDataverseName(), dataset.getDatasetName(), IndexingConstants.getFilesIndexName((String)dataset.getDatasetName()), true);
        IFileSplitProvider secondaryFileSplitProvider = (IFileSplitProvider)secondarySplitsAndConstraint.first;
        String fileIndexName = BTreeDataflowHelperFactoryProvider.externalFileIndexName(dataset);
        Index fileIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getDatasetName(), fileIndexName);
        IIndexDataflowHelperFactory dataflowHelperFactory = dataset.getIndexDataflowHelperFactory(metadataProvider, fileIndex, null, null, mergePolicyFactory, mergePolicyFactoryProperties);
        FilesIndexDescription filesIndexDescription = new FilesIndexDescription();
        LSMTreeIndexCompactOperatorDescriptor compactOp = new LSMTreeIndexCompactOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, secondaryFileSplitProvider, filesIndexDescription.EXTERNAL_FILE_INDEX_TYPE_TRAITS, FilesIndexDescription.FILES_INDEX_COMP_FACTORIES, new int[]{0}, dataflowHelperFactory, (IModificationOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, (IPageManagerFactory)storageComponentProvider.getMetadataPageManagerFactory());
        spec.addRoot((IOperatorDescriptor)compactOp);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)secondarySplitsAndConstraint.second));
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    public static boolean isFileIndex(Index index) {
        return index.getIndexName().equals(IndexingConstants.getFilesIndexName((String)index.getDatasetName()));
    }
}

