/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.http.server.HttpServer;

public class WebManager {
    private final List<HttpServer> servers = new ArrayList<HttpServer>();
    private final EventLoopGroup bosses = new NioEventLoopGroup(1);
    private final EventLoopGroup workers = new NioEventLoopGroup();

    public List<HttpServer> getServers() {
        return this.servers;
    }

    public EventLoopGroup getBosses() {
        return this.bosses;
    }

    public EventLoopGroup getWorkers() {
        return this.workers;
    }

    public void start() throws Exception {
        for (HttpServer server : this.servers) {
            server.start();
        }
    }

    public void stop() throws Exception {
        for (HttpServer server : this.servers) {
            server.stop();
        }
        this.workers.shutdownGracefully().sync();
        this.bosses.shutdownGracefully().sync();
    }

    public void add(HttpServer server) {
        this.servers.add(server);
    }
}

