/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.HttpRequestHandler;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class HttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(HttpServerHandler.class.getName());
    protected final HttpServer server;
    protected final int chunkSize;
    protected HttpRequestHandler handler;

    public HttpServerHandler(HttpServer server, int chunkSize) {
        this.server = server;
        this.chunkSize = chunkSize;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.handler.notifyChannelWritable();
        }
        super.channelWritabilityChanged(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        FullHttpRequest request = (FullHttpRequest)msg;
        try {
            IServlet servlet = this.server.getServlet(request);
            if (servlet == null) {
                this.respond(ctx, request, HttpResponseStatus.NOT_FOUND);
            } else {
                this.submit(ctx, servlet, request);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failure Submitting HTTP Request", e);
            this.respond(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void respond(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), status);
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void submit(ChannelHandlerContext ctx, IServlet servlet, FullHttpRequest request) throws IOException {
        IServletRequest servletRequest;
        try {
            servletRequest = HttpUtil.toServletRequest(request);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Failure Decoding Request", e);
            this.respond(ctx, request, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.handler = new HttpRequestHandler(ctx, servlet, servletRequest, this.chunkSize);
        this.submit();
    }

    private void submit() throws IOException {
        try {
            this.server.getExecutor().submit(this.handler);
        }
        catch (RejectedExecutionException e) {
            LOGGER.log(Level.WARNING, "Request rejected by server executor service. " + e.getMessage());
            this.handler.reject();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.log(Level.SEVERE, "Failure handling HTTP Request", cause);
        ctx.close();
    }
}

