/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.server.ChunkedResponse;

public class ChunkedNettyOutputStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(ChunkedNettyOutputStream.class.getName());
    private final ChannelHandlerContext ctx;
    private final ChunkedResponse response;
    private ByteBuf buffer;
    private boolean closed;

    public ChunkedNettyOutputStream(ChannelHandlerContext ctx, int chunkSize, ChunkedResponse response) {
        this.response = response;
        this.ctx = ctx;
        this.buffer = ctx.alloc().buffer(chunkSize);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len > this.buffer.capacity()) {
            this.flush();
            this.flush(b, off, len);
        } else {
            int space = this.buffer.writableBytes();
            if (space >= len) {
                this.buffer.writeBytes(b, off, len);
            } else {
                this.buffer.writeBytes(b, off, space);
                this.flush();
                this.buffer.writeBytes(b, off + space, len - space);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.isWritable()) {
            this.flush();
        }
        this.buffer.writeByte(b);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.response.isHeaderSent() || this.response.status() != HttpResponseStatus.OK) {
                this.flush();
                this.buffer.release();
            } else {
                this.response.fullReponse(this.buffer);
            }
            super.close();
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.ensureWritable();
        if (this.buffer.readableBytes() > 0) {
            if (this.response.status() == HttpResponseStatus.OK) {
                int size = this.buffer.capacity();
                this.response.beforeFlush();
                DefaultHttpContent content = new DefaultHttpContent(this.buffer);
                this.ctx.write((Object)content, this.ctx.channel().voidPromise());
                this.buffer = this.ctx.alloc().buffer(size);
            } else {
                ByteBuf aBuffer = this.ctx.alloc().buffer(this.buffer.readableBytes());
                aBuffer.writeBytes(this.buffer);
                this.response.error(aBuffer);
                this.buffer.clear();
            }
        }
    }

    private void flush(byte[] buf, int offset, int len) throws IOException {
        this.ensureWritable();
        ByteBuf aBuffer = this.ctx.alloc().buffer(len);
        aBuffer.writeBytes(buf, offset, len);
        if (this.response.status() == HttpResponseStatus.OK) {
            this.response.beforeFlush();
            this.ctx.write((Object)new DefaultHttpContent(aBuffer), this.ctx.channel().voidPromise());
        } else {
            this.response.error(aBuffer);
        }
    }

    private synchronized void ensureWritable() throws IOException {
        while (!this.ctx.channel().isWritable()) {
            try {
                this.ctx.flush();
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.WARNING, "Interupted while waiting for channel to be writable", e);
                throw new IOException(e);
            }
        }
    }

    public synchronized void resume() {
        this.notifyAll();
    }
}

