/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.dataset;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.dataset.IDatasetInputChannelMonitor;
import org.apache.hyracks.api.dataset.IHyracksDatasetDirectoryServiceConnection;
import org.apache.hyracks.api.dataset.IHyracksDatasetReader;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.client.net.ClientNetworkManager;
import org.apache.hyracks.comm.channels.DatasetNetworkInputChannel;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;

public class HyracksDatasetReader
implements IHyracksDatasetReader {
    private static final Logger LOGGER = Logger.getLogger(HyracksDatasetReader.class.getName());
    private final IHyracksDatasetDirectoryServiceConnection datasetDirectoryServiceConnection;
    private final ClientNetworkManager netManager;
    private final IHyracksCommonContext datasetClientCtx;
    private JobId jobId;
    private ResultSetId resultSetId;
    private DatasetDirectoryRecord[] knownRecords;
    private IDatasetInputChannelMonitor[] monitors;
    private int lastReadPartition;
    private IDatasetInputChannelMonitor lastMonitor;
    private DatasetNetworkInputChannel resultChannel;
    private static int NUM_READ_BUFFERS = 1;

    public HyracksDatasetReader(IHyracksDatasetDirectoryServiceConnection datasetDirectoryServiceConnection, ClientNetworkManager netManager, IHyracksCommonContext datasetClientCtx, JobId jobId, ResultSetId resultSetId) throws Exception {
        this.datasetDirectoryServiceConnection = datasetDirectoryServiceConnection;
        this.netManager = netManager;
        this.datasetClientCtx = datasetClientCtx;
        this.jobId = jobId;
        this.resultSetId = resultSetId;
        this.knownRecords = null;
        this.monitors = null;
        this.lastReadPartition = -1;
        this.lastMonitor = null;
        this.resultChannel = null;
    }

    public DatasetJobRecord.Status getResultStatus() {
        try {
            return this.datasetDirectoryServiceConnection.getDatasetResultStatus(this.jobId, this.resultSetId);
        }
        catch (HyracksDataException e) {
            if (e.getErrorCode() != 24) {
                LOGGER.log(Level.WARNING, "Exception retrieving result set for job " + this.jobId, e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception retrieving result set for job " + this.jobId, e);
        }
        return null;
    }

    private DatasetDirectoryRecord getRecord(int partition) throws Exception {
        while (this.knownRecords == null || this.knownRecords[partition] == null) {
            this.knownRecords = this.datasetDirectoryServiceConnection.getDatasetResultLocations(this.jobId, this.resultSetId, this.knownRecords);
        }
        return this.knownRecords[partition];
    }

    private boolean nextPartition() throws HyracksDataException {
        ++this.lastReadPartition;
        try {
            DatasetDirectoryRecord record = this.getRecord(this.lastReadPartition);
            while (record.getEmpty() && ++this.lastReadPartition < this.knownRecords.length) {
                record = this.getRecord(this.lastReadPartition);
            }
            if (this.lastReadPartition == this.knownRecords.length) {
                return false;
            }
            this.resultChannel = new DatasetNetworkInputChannel((IChannelConnectionFactory)this.netManager, this.getSocketAddress(record), this.jobId, this.resultSetId, this.lastReadPartition, NUM_READ_BUFFERS);
            this.lastMonitor = this.getMonitor(this.lastReadPartition);
            this.resultChannel.registerMonitor((IInputChannelMonitor)this.lastMonitor);
            this.resultChannel.open(this.datasetClientCtx);
            return true;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public int read(IFrame frame) throws HyracksDataException {
        frame.reset();
        int readSize = 0;
        if (this.lastReadPartition == -1 && !this.nextPartition()) {
            return readSize;
        }
        while (!(readSize >= frame.getFrameSize() || this.lastReadPartition == this.knownRecords.length - 1 && this.isPartitionReadComplete(this.lastMonitor))) {
            HyracksDatasetReader.waitForNextFrame(this.lastMonitor);
            if (this.isPartitionReadComplete(this.lastMonitor)) {
                this.knownRecords[this.lastReadPartition].readEOS();
                this.resultChannel.close();
                if (this.lastReadPartition != this.knownRecords.length - 1 && this.nextPartition()) continue;
                break;
            }
            ByteBuffer readBuffer = this.resultChannel.getNextBuffer();
            this.lastMonitor.notifyFrameRead();
            if (readBuffer == null) continue;
            if (readSize <= 0) {
                int nBlocks = FrameHelper.deserializeNumOfMinFrame((ByteBuffer)readBuffer);
                frame.ensureFrameSize(frame.getMinSize() * nBlocks);
                frame.getBuffer().clear();
                frame.getBuffer().put(readBuffer);
                this.resultChannel.recycleBuffer(readBuffer);
                readSize = frame.getBuffer().position();
                continue;
            }
            frame.getBuffer().put(readBuffer);
            this.resultChannel.recycleBuffer(readBuffer);
            readSize = frame.getBuffer().position();
        }
        frame.getBuffer().flip();
        return readSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForNextFrame(IDatasetInputChannelMonitor monitor) throws HyracksDataException {
        IDatasetInputChannelMonitor iDatasetInputChannelMonitor = monitor;
        synchronized (iDatasetInputChannelMonitor) {
            while (monitor.getNFramesAvailable() <= 0 && !monitor.eosReached() && !monitor.failed()) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
        if (monitor.failed()) {
            throw new HyracksDataException("Job Failed.");
        }
    }

    private boolean isPartitionReadComplete(IDatasetInputChannelMonitor monitor) {
        return monitor.getNFramesAvailable() <= 0 && monitor.eosReached();
    }

    private SocketAddress getSocketAddress(DatasetDirectoryRecord addr) throws UnknownHostException {
        NetworkAddress netAddr = addr.getNetworkAddress();
        return new InetSocketAddress(InetAddress.getByAddress(netAddr.lookupIpAddress()), netAddr.getPort());
    }

    private IDatasetInputChannelMonitor getMonitor(int partition) throws HyracksException {
        if (this.knownRecords == null || this.knownRecords[partition] == null) {
            throw new HyracksException("Accessing monitors before the obtaining the corresponding addresses.");
        }
        if (this.monitors == null) {
            this.monitors = new DatasetInputChannelMonitor[this.knownRecords.length];
        }
        if (this.monitors[partition] == null) {
            this.monitors[partition] = new DatasetInputChannelMonitor();
        }
        return this.monitors[partition];
    }

    private class DatasetInputChannelMonitor
    implements IDatasetInputChannelMonitor {
        private final AtomicInteger nAvailableFrames = new AtomicInteger(0);
        private final AtomicBoolean eos = new AtomicBoolean(false);
        private final AtomicBoolean failed = new AtomicBoolean(false);

        public synchronized void notifyFailure(IInputChannel channel) {
            this.failed.set(true);
            this.notifyAll();
        }

        public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
            this.nAvailableFrames.addAndGet(nFrames);
            this.notifyAll();
        }

        public synchronized void notifyEndOfStream(IInputChannel channel) {
            this.eos.set(true);
            this.notifyAll();
        }

        public synchronized boolean eosReached() {
            return this.eos.get();
        }

        public synchronized boolean failed() {
            return this.failed.get();
        }

        public synchronized int getNFramesAvailable() {
            return this.nAvailableFrames.get();
        }

        public synchronized void notifyFrameRead() {
            this.nAvailableFrames.decrementAndGet();
        }
    }
}

