/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class StreamProjectRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final boolean flushFramesRapidly;

    public StreamProjectRuntimeFactory(int[] projectionList, boolean flushFramesRapidly) {
        super(projectionList);
        this.flushFramesRapidly = flushFramesRapidly;
    }

    public StreamProjectRuntimeFactory(int[] projectionList) {
        this(projectionList, false);
    }

    public String toString() {
        return "stream-project " + Arrays.toString(this.projectionList);
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private boolean first = true;

            public void open() throws HyracksDataException {
                this.writer.open();
                if (this.first) {
                    this.first = false;
                    this.initAccessAppend(ctx);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                if (nTuple == 0) {
                    this.appender.flush(this.writer);
                } else {
                    int t;
                    if (nTuple > 1) {
                        for (t = 0; t < nTuple - 1; ++t) {
                            this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList);
                        }
                    }
                    if (StreamProjectRuntimeFactory.this.flushFramesRapidly) {
                        this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList, true);
                    } else {
                        this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList);
                    }
                }
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }
}

