/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import java.io.DataOutput;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluatorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;

public class SerializableAggregatorDescriptorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private ISerializedAggregateEvaluatorFactory[] aggFactories;

    public SerializableAggregatorDescriptorFactory(ISerializedAggregateEvaluatorFactory[] aggFactories) {
        this.aggFactories = aggFactories;
    }

    public IAggregatorDescriptor createAggregator(final IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int[] keyFields, int[] keyFieldsInPartialResults) throws HyracksDataException {
        final int[] keys = keyFields;
        return new IAggregatorDescriptor(){
            private FrameTupleReference ftr = new FrameTupleReference();
            private ISerializedAggregateEvaluator[] aggs = new ISerializedAggregateEvaluator[SerializableAggregatorDescriptorFactory.access$000(SerializableAggregatorDescriptorFactory.this).length];
            private int offsetFieldIndex = keys.length;
            private int[] stateFieldLength = new int[SerializableAggregatorDescriptorFactory.access$000(SerializableAggregatorDescriptorFactory.this).length];

            public AggregateState createAggregateStates() {
                return new AggregateState();
            }

            public void init(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                DataOutput output = tb.getDataOutput();
                this.ftr.reset(accessor, tIndex);
                for (i = 0; i < this.aggs.length; ++i) {
                    int begin = tb.getSize();
                    if (this.aggs[i] == null) {
                        this.aggs[i] = SerializableAggregatorDescriptorFactory.this.aggFactories[i].createAggregateEvaluator(ctx);
                    }
                    this.aggs[i].init(output);
                    tb.addFieldEndOffset();
                    this.stateFieldLength[i] = tb.getSize() - begin;
                }
                this.ftr.reset(accessor, tIndex);
                for (i = 0; i < this.aggs.length; ++i) {
                    byte[] data = tb.getByteArray();
                    int prevFieldPos = i + keys.length - 1;
                    int start = prevFieldPos >= 0 ? tb.getFieldEndOffsets()[prevFieldPos] : 0;
                    this.aggs[i].step((IFrameTupleReference)this.ftr, data, start, this.stateFieldLength[i]);
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                this.ftr.reset(accessor, tIndex);
                int stateTupleStart = stateAccessor.getTupleStartOffset(stateTupleIndex);
                int fieldSlotLength = stateAccessor.getFieldSlotsLength();
                for (int i = 0; i < this.aggs.length; ++i) {
                    byte[] data = stateAccessor.getBuffer().array();
                    int start = stateAccessor.getFieldStartOffset(stateTupleIndex, i + keys.length) + stateTupleStart + fieldSlotLength;
                    this.aggs[i].step((IFrameTupleReference)this.ftr, data, start, this.stateFieldLength[i]);
                }
            }

            public boolean outputPartialResult(ArrayTupleBuilder tb, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                int refOffset;
                byte[] data = stateAccessor.getBuffer().array();
                int startOffset = stateAccessor.getTupleStartOffset(tIndex);
                int aggFieldOffset = stateAccessor.getFieldStartOffset(tIndex, this.offsetFieldIndex);
                int start = refOffset = startOffset + stateAccessor.getFieldSlotsLength() + aggFieldOffset;
                for (int i = 0; i < this.aggs.length; ++i) {
                    this.aggs[i].finishPartial(data, start, this.stateFieldLength[i], tb.getDataOutput());
                    start += this.stateFieldLength[i];
                    tb.addFieldEndOffset();
                }
                return true;
            }

            public boolean outputFinalResult(ArrayTupleBuilder tb, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                int refOffset;
                byte[] data = stateAccessor.getBuffer().array();
                int startOffset = stateAccessor.getTupleStartOffset(tIndex);
                int aggFieldOffset = stateAccessor.getFieldStartOffset(tIndex, this.offsetFieldIndex);
                int start = refOffset = startOffset + stateAccessor.getFieldSlotsLength() + aggFieldOffset;
                for (int i = 0; i < this.aggs.length; ++i) {
                    this.aggs[i].finish(data, start, this.stateFieldLength[i], tb.getDataOutput());
                    start += this.stateFieldLength[i];
                    tb.addFieldEndOffset();
                }
                return true;
            }

            public void reset() {
            }

            public void close() {
                this.reset();
            }
        };
    }
}

