/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushSubplanIntoGroupByRule
implements IAlgebraicRewriteRule {
    private final Set<LogicalVariable> usedVarsSoFar = new HashSet<LogicalVariable>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator parentOperator = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, parentOperator)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, parentOperator);
        VariableUtilities.getUsedVariables((ILogicalOperator)parentOperator, this.usedVarsSoFar);
        if (parentOperator.getInputs().size() <= 0) {
            return false;
        }
        boolean changed = false;
        GroupByOperator gby = null;
        for (Mutable ref : parentOperator.getInputs()) {
            AbstractLogicalOperator op = (AbstractLogicalOperator)ref.getValue();
            ArrayList<SubplanOperator> subplans = new ArrayList<SubplanOperator>();
            if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) continue;
            while (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                SubplanOperator currentSubplan = (SubplanOperator)op;
                subplans.add(currentSubplan);
                op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            }
            if (op.getOperatorTag() != LogicalOperatorTag.GROUP) continue;
            gby = (GroupByOperator)op;
            ArrayList<ILogicalPlan> newGbyNestedPlans = new ArrayList<ILogicalPlan>();
            for (SubplanOperator subplan : subplans) {
                List subplanNestedPlans = subplan.getNestedPlans();
                List gbyNestedPlans = gby.getNestedPlans();
                ArrayList<ILogicalPlan> subplanNestedPlansToRemove = new ArrayList<ILogicalPlan>();
                for (ILogicalPlan subplanNestedPlan : subplanNestedPlans) {
                    List rootOpRefs = subplanNestedPlan.getRoots();
                    ArrayList<Mutable> rootOpRefsToRemove = new ArrayList<Mutable>();
                    for (Mutable rootOpRef : rootOpRefs) {
                        ListSet freeVars = new ListSet();
                        VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)((ILogicalOperator)rootOpRef.getValue()), (Collection)freeVars);
                        ListSet producedVars = new ListSet();
                        VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)((ILogicalOperator)rootOpRef.getValue()), (Collection)producedVars);
                        freeVars.removeAll((Collection<?>)producedVars);
                        for (ILogicalPlan gbyNestedPlanOriginal : gbyNestedPlans) {
                            if (!newGbyNestedPlans.contains(gbyNestedPlanOriginal)) {
                                newGbyNestedPlans.add(gbyNestedPlanOriginal);
                            }
                            ILogicalPlan gbyNestedPlan = OperatorManipulationUtil.deepCopy((ILogicalPlan)gbyNestedPlanOriginal, (IOptimizationContext)context);
                            List gbyRootOpRefs = gbyNestedPlan.getRoots();
                            for (int rootIndex = 0; rootIndex < gbyRootOpRefs.size(); ++rootIndex) {
                                Mutable originalGbyRootOpRef = (Mutable)gbyNestedPlanOriginal.getRoots().get(rootIndex);
                                Mutable<ILogicalOperator> originalGbyNtsRef = this.downToNts((Mutable<ILogicalOperator>)originalGbyRootOpRef);
                                NestedTupleSourceOperator originalNts = (NestedTupleSourceOperator)originalGbyNtsRef.getValue();
                                originalNts.setDataSourceReference((Mutable)new MutableObject((Object)gby));
                                Mutable gbyRootOpRef = (Mutable)gbyRootOpRefs.get(rootIndex);
                                ListSet liveVars = new ListSet();
                                VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)gbyRootOpRef.getValue()), (Collection)liveVars);
                                if (!liveVars.containsAll((Collection<?>)freeVars)) continue;
                                Mutable<ILogicalOperator> ntsRef = this.downToNts((Mutable<ILogicalOperator>)rootOpRef);
                                ntsRef.setValue(gbyRootOpRef.getValue());
                                AggregateOperator aggOp = (AggregateOperator)gbyRootOpRef.getValue();
                                for (int varIndex = aggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                                    if (freeVars.contains(aggOp.getVariables().get(varIndex))) continue;
                                    aggOp.getVariables().remove(varIndex);
                                    aggOp.getExpressions().remove(varIndex);
                                }
                                gbyRootOpRef.setValue(rootOpRef.getValue());
                                rootOpRefsToRemove.add(rootOpRef);
                                Mutable<ILogicalOperator> oldGbyNtsRef = this.downToNts((Mutable<ILogicalOperator>)gbyRootOpRef);
                                NestedTupleSourceOperator nts = (NestedTupleSourceOperator)oldGbyNtsRef.getValue();
                                nts.setDataSourceReference((Mutable)new MutableObject((Object)gby));
                                newGbyNestedPlans.add(gbyNestedPlan);
                                changed = true;
                            }
                        }
                    }
                    rootOpRefs.removeAll(rootOpRefsToRemove);
                    if (rootOpRefs.size() != 0) continue;
                    subplanNestedPlansToRemove.add(subplanNestedPlan);
                }
                subplanNestedPlans.removeAll(subplanNestedPlansToRemove);
            }
            if (!changed) continue;
            ref.setValue((Object)gby);
            gby.getNestedPlans().clear();
            gby.getNestedPlans().addAll(newGbyNestedPlans);
        }
        if (changed) {
            this.cleanup(gby);
            context.computeAndSetTypeEnvironmentForOperator(gby);
            context.computeAndSetTypeEnvironmentForOperator(parentOperator);
        }
        return changed;
    }

    private void cleanup(GroupByOperator gby) throws AlgebricksException {
        for (ILogicalPlan nestedPlan : gby.getNestedPlans()) {
            for (Mutable rootRef : nestedPlan.getRoots()) {
                AggregateOperator aggOp = (AggregateOperator)rootRef.getValue();
                for (int varIndex = aggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                    if (this.usedVarsSoFar.contains(aggOp.getVariables().get(varIndex))) continue;
                    aggOp.getVariables().remove(varIndex);
                    aggOp.getExpressions().remove(varIndex);
                }
            }
        }
    }

    private Mutable<ILogicalOperator> downToNts(Mutable<ILogicalOperator> opRef) {
        Mutable currentOpRef = opRef;
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs().size() > 0) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        return currentOpRef;
    }
}

