/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractDecorrelationRule;

public class MoveFreeVariableOperatorOutOfSubplanRule
extends AbstractDecorrelationRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op0;
        Mutable leftRef = (Mutable)subplan.getInputs().get(0);
        if (((AbstractLogicalOperator)leftRef.getValue()).getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return false;
        }
        ListIterator plansIter = subplan.getNestedPlans().listIterator();
        ILogicalPlan p = null;
        while (plansIter.hasNext()) {
            p = (ILogicalPlan)plansIter.next();
        }
        if (p == null) {
            return false;
        }
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable opRef1 = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef1.getValue();
        if (op1.getInputs().size() != 1) {
            return false;
        }
        Mutable op2Ref = (Mutable)op1.getInputs().get(0);
        HashSet free = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)op1, free);
        while (op2Ref != null) {
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)op2Ref.getValue();
            if (op2.getInputs().size() != 1 || !this.descOrSelfIsScanOrJoin(op2)) {
                return false;
            }
            boolean notApplicable = false;
            HashSet used = new HashSet();
            if (this.movableOperator(op2.getOperatorTag())) {
                if (op2.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    VariableUtilities.getUsedVariables((ILogicalOperator)op2, used);
                } else if (op2.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                    Iterator subplansIter = ((SubplanOperator)op2).getNestedPlans().listIterator();
                    ILogicalPlan plan = null;
                    while (subplansIter.hasNext()) {
                        plan = (ILogicalPlan)subplansIter.next();
                    }
                    if (plan == null) {
                        return false;
                    }
                    if (plan.getRoots().size() != 1) {
                        return false;
                    }
                    ILogicalOperator op3 = (ILogicalOperator)((Mutable)plan.getRoots().get(0)).getValue();
                    if (op3.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
                        return false;
                    }
                    VariableUtilities.getUsedVariables((ILogicalOperator)op2, used);
                    HashSet subplanProducedAndDown = new HashSet();
                    VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)op3, subplanProducedAndDown);
                    used.removeAll(subplanProducedAndDown);
                } else {
                    notApplicable = true;
                }
            } else {
                notApplicable = true;
            }
            for (LogicalVariable var : used) {
                if (free.contains(var)) continue;
                notApplicable = true;
            }
            if (notApplicable) {
                op2Ref = (Mutable)op2.getInputs().get(0);
                continue;
            }
            op2Ref.setValue(((Mutable)op2.getInputs().get(0)).getValue());
            Mutable outsideRef = (Mutable)op2.getInputs().get(0);
            outsideRef.setValue(((Mutable)op0.getInputs().get(0)).getValue());
            Mutable op2OutsideRef = (Mutable)op0.getInputs().get(0);
            op2OutsideRef.setValue((Object)op2);
            return true;
        }
        return false;
    }

    protected boolean movableOperator(LogicalOperatorTag operatorTag) {
        return operatorTag == LogicalOperatorTag.ASSIGN || operatorTag == LogicalOperatorTag.SUBPLAN;
    }
}

