/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class BreakSelectIntoConjunctsRule
implements IAlgebraicRewriteRule {
    private List<Mutable<ILogicalExpression>> conjs = new ArrayList<Mutable<ILogicalExpression>>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator select = (SelectOperator)op;
        ILogicalExpression cond = (ILogicalExpression)select.getCondition().getValue();
        this.conjs.clear();
        if (!cond.splitIntoConjuncts(this.conjs)) {
            return false;
        }
        Mutable childOfSelect = (Mutable)select.getInputs().get(0);
        boolean fst = true;
        SelectOperator botOp = select;
        ILogicalExpression firstExpr = null;
        for (Mutable<ILogicalExpression> eRef : this.conjs) {
            ILogicalExpression e = (ILogicalExpression)eRef.getValue();
            if (fst) {
                fst = false;
                firstExpr = e;
                continue;
            }
            SelectOperator newSelect = new SelectOperator((Mutable)new MutableObject((Object)e), select.getRetainMissing(), select.getMissingPlaceholderVariable());
            List botInpList = botOp.getInputs();
            botInpList.clear();
            botInpList.add(new MutableObject((Object)newSelect));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)botOp);
            botOp = newSelect;
        }
        botOp.getInputs().add(childOfSelect);
        select.getCondition().setValue(firstExpr);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)botOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)select);
        return true;
    }
}

