/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.util;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.runtime.message.ReplicaEventMessage;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.control.common.controllers.NCConfig;

public class FaultToleranceUtil {
    private static final Logger LOGGER = Logger.getLogger(FaultToleranceUtil.class.getName());

    private FaultToleranceUtil() {
        throw new AssertionError();
    }

    public static void notifyImpactedReplicas(String nodeId, IClusterLifecycleListener.ClusterEventType event, IClusterStateManager clusterManager, ICCMessageBroker messageBroker, IReplicationStrategy replicationStrategy) {
        List primaryRemoteReplicas = replicationStrategy.getRemotePrimaryReplicas(nodeId).stream().map(Replica::getId).collect(Collectors.toList());
        String nodeIdAddress = "";
        Map activeNcConfiguration = clusterManager.getActiveNcConfiguration();
        if (event == IClusterLifecycleListener.ClusterEventType.NODE_JOIN) {
            nodeIdAddress = (String)((Map)activeNcConfiguration.get(nodeId)).get(NCConfig.Option.CLUSTER_PUBLIC_ADDRESS);
        }
        ReplicaEventMessage msg = new ReplicaEventMessage(nodeId, nodeIdAddress, event);
        for (String replica : primaryRemoteReplicas) {
            if (!activeNcConfiguration.containsKey(replica)) continue;
            try {
                messageBroker.sendApplicationMessageToNC((IApplicationMessage)msg, replica);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Failed sending an application message to an NC", e);
            }
        }
    }
}

