/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IConnectionWriterState;
import org.apache.hyracks.api.comm.MuxDemuxCommand;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelWriteInterface;

public class MessagingChannelWriteInterface
extends AbstractChannelWriteInterface {
    MessagingChannelWriteInterface(IChannelControlBlock ccb) {
        super(ccb);
    }

    public void write(IConnectionWriterState writerState) throws NetException {
        if (this.currentWriteBuffer == null) {
            this.currentWriteBuffer = (ByteBuffer)this.wiFullQueue.poll();
        }
        if (this.currentWriteBuffer != null) {
            int size = this.currentWriteBuffer.remaining();
            if (size > 0) {
                writerState.getCommand().setChannelId(this.channelId);
                writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.DATA);
                writerState.getCommand().setData(size);
                writerState.reset(this.currentWriteBuffer, size, this.ccb);
            } else {
                this.adjustChannelWritability();
            }
        } else if (this.ecode >= 0 && !this.ecodeSent) {
            writerState.getCommand().setChannelId(this.channelId);
            writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.ERROR);
            writerState.getCommand().setData(this.ecode);
            writerState.reset(null, 0, null);
            this.ecodeSent = true;
            this.ccb.reportLocalEOS();
            this.adjustChannelWritability();
        } else if (this.eos && !this.eosSent) {
            writerState.getCommand().setChannelId(this.channelId);
            writerState.getCommand().setCommandType(MuxDemuxCommand.CommandType.CLOSE_CHANNEL);
            writerState.getCommand().setData(0);
            writerState.reset(null, 0, null);
            this.eosSent = true;
            this.ccb.reportLocalEOS();
            this.adjustChannelWritability();
        }
    }

    public void setBufferFactory(IBufferFactory bufferFactory, int limit, int frameSize) {
        this.credits = limit * frameSize;
    }
}

