/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;

public class CCMessageBroker
implements ICCMessageBroker {
    private static final Logger LOGGER = Logger.getLogger(CCMessageBroker.class.getName());
    private final ClusterControllerService ccs;

    public CCMessageBroker(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    public void receivedMessage(IMessage message, String nodeId) throws Exception {
        IApplicationMessage absMessage = (IApplicationMessage)message;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Received message: " + absMessage);
        }
        absMessage.handle((IControllerService)this.ccs);
    }

    public void sendApplicationMessageToNC(IApplicationMessage msg, String nodeId) throws Exception {
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState state = nodeManager.getNodeControllerState(nodeId);
        state.getNodeController().sendApplicationMessageToNC(JavaSerializationUtils.serialize((Serializable)msg), null, nodeId);
    }
}

