/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IClusterManagementWorkResponse;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class GlobalRecoveryManager
implements IGlobalRecoveryManager {
    private static final Logger LOGGER = Logger.getLogger(GlobalRecoveryManager.class.getName());
    private static GlobalRecoveryManager instance;
    private static IClusterManagementWork.ClusterState state;
    private final IStorageComponentProvider componentProvider;
    private HyracksConnection hcc;

    private GlobalRecoveryManager(HyracksConnection hcc, IStorageComponentProvider componentProvider) {
        GlobalRecoveryManager.setState(IClusterManagementWork.ClusterState.UNUSABLE);
        this.hcc = hcc;
        this.componentProvider = componentProvider;
    }

    public Set<IClusterManagementWork> notifyNodeFailure(Collection<String> deadNodeIds) {
        GlobalRecoveryManager.setState(ClusterStateManager.INSTANCE.getState());
        ClusterStateManager.INSTANCE.setGlobalRecoveryCompleted(false);
        return Collections.emptySet();
    }

    public Set<IClusterManagementWork> notifyNodeJoin(String joinedNodeId) {
        this.startGlobalRecovery();
        return Collections.emptySet();
    }

    private void executeHyracksJob(JobSpecification spec) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = this.hcc.startJob(spec);
        this.hcc.waitForCompletion(jobId);
    }

    public void notifyRequestCompletion(IClusterManagementWorkResponse response) {
    }

    public void notifyStateChange(IClusterManagementWork.ClusterState previousState, IClusterManagementWork.ClusterState newState) {
    }

    public void startGlobalRecovery() {
        boolean needToRecover;
        IClusterManagementWork.ClusterState newState = ClusterStateManager.INSTANCE.getState();
        boolean bl = needToRecover = !newState.equals((Object)state) && newState == IClusterManagementWork.ClusterState.ACTIVE;
        if (needToRecover) {
            Thread recoveryThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LOGGER.info("Starting AsterixDB's Global Recovery");
                    MetadataTransactionContext mdTxnCtx = null;
                    try {
                        Thread.sleep(4000L);
                        MetadataManager.INSTANCE.init();
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                        List dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
                        for (Dataverse dataverse : dataverses) {
                            if (dataverse.getDataverseName().equals("Metadata")) continue;
                            MetadataProvider metadataProvider = new MetadataProvider(dataverse, GlobalRecoveryManager.this.componentProvider);
                            try {
                                List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
                                for (Dataset dataset : datasets) {
                                    JobSpecification jobSpec;
                                    List files;
                                    List indexes;
                                    if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL || (indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName())).isEmpty()) continue;
                                    ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
                                    DatasetConfig.TransactionState datasetState = dsd.getState();
                                    if (datasetState == DatasetConfig.TransactionState.BEGIN) {
                                        files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                                        for (ExternalFile file : files) {
                                            if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                        }
                                        metadataProvider.setMetadataTxnContext(mdTxnCtx);
                                        jobSpec = ExternalIndexingOperations.buildAbortOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                                        GlobalRecoveryManager.this.executeHyracksJob(jobSpec);
                                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                                        continue;
                                    }
                                    if (datasetState != DatasetConfig.TransactionState.READY_TO_COMMIT) continue;
                                    files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                                    jobSpec = ExternalIndexingOperations.buildRecoverOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                                    GlobalRecoveryManager.this.executeHyracksJob(jobSpec);
                                    block10: for (ExternalFile file : files) {
                                        if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP) {
                                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                            file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                                            MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                                            continue;
                                        }
                                        if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                                            for (ExternalFile originalFile : files) {
                                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                                continue block10;
                                            }
                                            continue;
                                        }
                                        if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.APPEND_OP) continue;
                                        for (ExternalFile originalFile : files) {
                                            if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                            originalFile.setSize(file.getSize());
                                            MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, originalFile);
                                        }
                                    }
                                    ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                                }
                            }
                            finally {
                                metadataProvider.getLocks().unlock();
                            }
                        }
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Global recovery was not completed successfully: ", e);
                        try {
                            MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
                        }
                        catch (Exception e1) {
                            LOGGER.log(Level.SEVERE, "Exception in aborting", e1);
                            throw new IllegalStateException(e1);
                        }
                    }
                    ClusterStateManager.INSTANCE.setGlobalRecoveryCompleted(true);
                    LOGGER.info("Global Recovery Completed");
                }
            }, "RecoveryThread");
            GlobalRecoveryManager.setState(newState);
            recoveryThread.start();
        }
    }

    public static GlobalRecoveryManager instance() {
        return instance;
    }

    public static synchronized void instantiate(HyracksConnection hcc, IStorageComponentProvider componentProvider) {
        instance = new GlobalRecoveryManager(hcc, componentProvider);
    }

    public static synchronized void setState(IClusterManagementWork.ClusterState state) {
        GlobalRecoveryManager.state = state;
    }
}

