/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveLifecycleListener;
import org.apache.asterix.api.http.server.ApiServlet;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.asterix.api.http.server.ClusterControllerDetailsApiServlet;
import org.apache.asterix.api.http.server.ConnectorApiServlet;
import org.apache.asterix.api.http.server.DdlApiServlet;
import org.apache.asterix.api.http.server.DiagnosticsApiServlet;
import org.apache.asterix.api.http.server.FullApiServlet;
import org.apache.asterix.api.http.server.NodeControllerDetailsApiServlet;
import org.apache.asterix.api.http.server.QueryApiServlet;
import org.apache.asterix.api.http.server.QueryCancellationServlet;
import org.apache.asterix.api.http.server.QueryResultApiServlet;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.api.http.server.QueryStatusApiServlet;
import org.apache.asterix.api.http.server.QueryWebInterfaceServlet;
import org.apache.asterix.api.http.server.ShutdownApiServlet;
import org.apache.asterix.api.http.server.UpdateApiServlet;
import org.apache.asterix.api.http.server.VersionApiServlet;
import org.apache.asterix.app.cc.CCExtensionManager;
import org.apache.asterix.app.cc.ResourceIdManager;
import org.apache.asterix.app.external.ExternalLibraryUtils;
import org.apache.asterix.app.replication.FaultToleranceStrategyFactory;
import org.apache.asterix.common.api.AsterixThreadFactory;
import org.apache.asterix.common.api.IClusterEventsSubscriber;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.external.library.ExternalLibraryManager;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.hyracks.bootstrap.ApplicationConfigurator;
import org.apache.asterix.hyracks.bootstrap.ClusterLifecycleListener;
import org.apache.asterix.hyracks.bootstrap.GlobalRecoveryManager;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.bootstrap.AsterixStateProxy;
import org.apache.asterix.metadata.cluster.ClusterManagerProvider;
import org.apache.asterix.runtime.job.resource.JobCapacityController;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.lifecycle.LifeCycleComponentManager;
import org.apache.hyracks.api.messages.IMessageBroker;
import org.apache.hyracks.control.cc.BaseCCApplication;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.WebManager;

public class CCApplication
extends BaseCCApplication {
    private static final Logger LOGGER = Logger.getLogger(CCApplication.class.getName());
    private static IAsterixStateProxy proxy;
    protected ICCServiceContext ccServiceCtx;
    protected CCExtensionManager ccExtensionManager;
    protected IStorageComponentProvider componentProvider;
    private IJobCapacityController jobCapacityController;
    protected WebManager webManager;

    public void start(IServiceContext serviceCtx, String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
        ClusterControllerService controllerService = (ClusterControllerService)serviceCtx.getControllerService();
        CCMessageBroker messageBroker = new CCMessageBroker(controllerService);
        this.ccServiceCtx = (ICCServiceContext)serviceCtx;
        this.configureLoggingLevel(this.ccServiceCtx.getAppConfig().getLoggingLevel((IOption)ExternalProperties.Option.LOG_LEVEL));
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting Asterix cluster controller");
        }
        this.ccServiceCtx.setThreadFactory((ThreadFactory)new AsterixThreadFactory(this.ccServiceCtx.getThreadFactory(), (ILifeCycleComponentManager)new LifeCycleComponentManager()));
        ExternalLibraryManager libraryManager = new ExternalLibraryManager();
        ResourceIdManager resourceIdManager = new ResourceIdManager();
        IReplicationStrategy repStrategy = ClusterProperties.INSTANCE.getReplicationStrategy();
        IFaultToleranceStrategy ftStrategy = FaultToleranceStrategyFactory.create(ClusterProperties.INSTANCE.getCluster(), repStrategy, messageBroker);
        ExternalLibraryUtils.setUpExternaLibraries((ILibraryManager)libraryManager, false);
        this.componentProvider = new StorageComponentProvider();
        GlobalRecoveryManager.instantiate((HyracksConnection)this.getHcc(), this.componentProvider);
        AppContextInfo.initialize((ICCServiceContext)this.ccServiceCtx, (IHyracksClientConnection)this.getHcc(), (ILibraryManager)libraryManager, (IResourceIdManager)resourceIdManager, () -> MetadataManager.INSTANCE, (IGlobalRecoveryManager)GlobalRecoveryManager.instance(), (IFaultToleranceStrategy)ftStrategy);
        this.ccExtensionManager = new CCExtensionManager(this.getExtensions());
        AppContextInfo.INSTANCE.setExtensionManager((Object)this.ccExtensionManager);
        CCConfig ccConfig = controllerService.getCCConfig();
        if (System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", ccConfig.getClusterListenAddress());
        }
        MetadataProperties metadataProperties = AppContextInfo.INSTANCE.getMetadataProperties();
        CCApplication.setAsterixStateProxy(AsterixStateProxy.registerRemoteObject((int)metadataProperties.getMetadataCallbackPort()));
        this.ccServiceCtx.setDistributedState((Serializable)proxy);
        MetadataManager.initialize((IAsterixStateProxy)proxy, (MetadataProperties)metadataProperties);
        AppContextInfo.INSTANCE.getCCServiceContext().addJobLifecycleListener((IJobLifecycleListener)ActiveLifecycleListener.INSTANCE);
        this.webManager = new WebManager();
        this.configureServers();
        this.webManager.start();
        ClusterManagerProvider.getClusterManager().registerSubscriber((IClusterEventsSubscriber)GlobalRecoveryManager.instance());
        this.ccServiceCtx.addClusterLifecycleListener((IClusterLifecycleListener)ClusterLifecycleListener.INSTANCE);
        this.ccServiceCtx.setMessageBroker((IMessageBroker)messageBroker);
        this.jobCapacityController = new JobCapacityController(controllerService.getResourceManager());
    }

    protected void configureLoggingLevel(Level level) {
        super.configureLoggingLevel(level);
        LOGGER.info("Setting Asterix log level to " + level);
        Logger.getLogger("org.apache.asterix").setLevel(level);
    }

    protected List<AsterixExtension> getExtensions() {
        return AppContextInfo.INSTANCE.getExtensionProperties().getExtensions();
    }

    protected void configureServers() throws Exception {
        this.webManager.add(this.setupWebServer(AppContextInfo.INSTANCE.getExternalProperties()));
        this.webManager.add(this.setupJSONAPIServer(AppContextInfo.INSTANCE.getExternalProperties()));
        this.webManager.add(this.setupQueryWebServer(AppContextInfo.INSTANCE.getExternalProperties()));
    }

    public void stop() throws Exception {
        ActiveLifecycleListener.INSTANCE.stop();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Stopping Asterix cluster controller");
        }
        AsterixStateProxy.unregisterRemoteObject();
        this.webManager.stop();
    }

    protected HttpServer setupWebServer(ExternalProperties externalProperties) throws Exception {
        HttpServer webServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getWebInterfacePort());
        IHyracksClientConnection hcc = this.getHcc();
        webServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)hcc);
        webServer.addServlet((IServlet)new ApiServlet(webServer.ctx(), new String[]{"/*"}, this.ccExtensionManager.getAqlCompilationProvider(), this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider));
        return webServer;
    }

    protected HttpServer setupJSONAPIServer(ExternalProperties externalProperties) throws Exception {
        HttpServer jsonAPIServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getAPIServerPort());
        IHyracksClientConnection hcc = this.getHcc();
        jsonAPIServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)hcc);
        jsonAPIServer.setAttribute("org.apache.asterix.APP_CONTEXT_INFO", (Object)AppContextInfo.INSTANCE);
        jsonAPIServer.setAttribute("org.apache.asterix.EXECUTOR_SERVICE_ATTR", (Object)this.ccServiceCtx.getControllerService().getExecutor());
        this.addServlet(jsonAPIServer, "/query");
        this.addServlet(jsonAPIServer, "/update");
        this.addServlet(jsonAPIServer, "/ddl");
        this.addServlet(jsonAPIServer, "/aql");
        this.addServlet(jsonAPIServer, "/query/sqlpp");
        this.addServlet(jsonAPIServer, "/update/sqlpp");
        this.addServlet(jsonAPIServer, "/ddl/sqlpp");
        this.addServlet(jsonAPIServer, "/sqlpp");
        this.addServlet(jsonAPIServer, "/query/service/status/*");
        this.addServlet(jsonAPIServer, "/query/service/result/*");
        this.addServlet(jsonAPIServer, "/query/service");
        this.addServlet(jsonAPIServer, "/admin/requests/running/*");
        this.addServlet(jsonAPIServer, "/connector");
        this.addServlet(jsonAPIServer, "/admin/shutdown");
        this.addServlet(jsonAPIServer, "/admin/version");
        this.addServlet(jsonAPIServer, "/admin/cluster/*");
        this.addServlet(jsonAPIServer, "/admin/cluster/node/*");
        this.addServlet(jsonAPIServer, "/admin/cluster/cc/*");
        this.addServlet(jsonAPIServer, "/admin/diagnostics");
        return jsonAPIServer;
    }

    protected void addServlet(HttpServer server, String path) {
        server.addServlet(this.createServlet(server.ctx(), path, path));
    }

    protected HttpServer setupQueryWebServer(ExternalProperties externalProperties) throws Exception {
        HttpServer queryWebServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getQueryWebInterfacePort());
        IHyracksClientConnection hcc = this.getHcc();
        queryWebServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)hcc);
        queryWebServer.addServlet((IServlet)new QueryWebInterfaceServlet(queryWebServer.ctx(), new String[]{"/*"}));
        return queryWebServer;
    }

    protected IServlet createServlet(ConcurrentMap<String, Object> ctx, String key, String ... paths) {
        switch (key) {
            case "/aql": {
                return new FullApiServlet(ctx, paths, this.ccExtensionManager.getAqlCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/query": {
                return new QueryApiServlet(ctx, paths, this.ccExtensionManager.getAqlCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/update": {
                return new UpdateApiServlet(ctx, paths, this.ccExtensionManager.getAqlCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/ddl": {
                return new DdlApiServlet(ctx, paths, this.ccExtensionManager.getAqlCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/sqlpp": {
                return new FullApiServlet(ctx, paths, this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/query/sqlpp": {
                return new QueryApiServlet(ctx, paths, this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/update/sqlpp": {
                return new UpdateApiServlet(ctx, paths, this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/ddl/sqlpp": {
                return new DdlApiServlet(ctx, paths, this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/admin/requests/running/*": {
                return new QueryCancellationServlet(ctx, paths);
            }
            case "/query/service/status/*": {
                return new QueryStatusApiServlet(ctx, paths);
            }
            case "/query/service/result/*": {
                return new QueryResultApiServlet(ctx, paths);
            }
            case "/query/service": {
                return new QueryServiceServlet(ctx, paths, this.ccExtensionManager.getSqlppCompilationProvider(), this.getStatementExecutorFactory(), this.componentProvider);
            }
            case "/connector": {
                return new ConnectorApiServlet(ctx, paths);
            }
            case "/admin/shutdown": {
                return new ShutdownApiServlet(ctx, paths);
            }
            case "/admin/version": {
                return new VersionApiServlet(ctx, paths);
            }
            case "/admin/cluster/*": {
                return new ClusterApiServlet(ctx, paths);
            }
            case "/admin/cluster/node/*": {
                return new NodeControllerDetailsApiServlet(ctx, paths);
            }
            case "/admin/cluster/cc/*": {
                return new ClusterControllerDetailsApiServlet(ctx, paths);
            }
            case "/admin/diagnostics": {
                return new DiagnosticsApiServlet(ctx, paths);
            }
        }
        throw new IllegalStateException(String.valueOf(key));
    }

    private IStatementExecutorFactory getStatementExecutorFactory() {
        return this.ccExtensionManager.getStatementExecutorFactory(this.ccServiceCtx.getControllerService().getExecutor());
    }

    public void startupCompleted() throws Exception {
        this.ccServiceCtx.getControllerService().getExecutor().submit(() -> {
            ClusterStateManager.INSTANCE.waitForState(IClusterManagementWork.ClusterState.ACTIVE);
            ClusterManagerProvider.getClusterManager().notifyStartupCompleted();
            return null;
        });
    }

    public IJobCapacityController getJobCapacityController() {
        return this.jobCapacityController;
    }

    public void registerConfig(IConfigManager configManager) {
        super.registerConfig(configManager);
        ApplicationConfigurator.registerConfigOptions(configManager);
    }

    public static synchronized void setAsterixStateProxy(IAsterixStateProxy proxy) {
        CCApplication.proxy = proxy;
    }

    public AppContextInfo getApplicationContext() {
        return AppContextInfo.INSTANCE;
    }

    protected IHyracksClientConnection getHcc() throws Exception {
        String strIP = this.ccServiceCtx.getCCContext().getClusterControllerInfo().getClientNetAddress();
        int port = this.ccServiceCtx.getCCContext().getClusterControllerInfo().getClientNetPort();
        return new HyracksConnection(strIP, port);
    }
}

