/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.translator;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveJobNotificationHandler;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IActiveEventSubscriber;
import org.apache.asterix.algebra.extension.IExtensionStatement;
import org.apache.asterix.api.common.APIFramework;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.compiler.provider.AqlCompilationProvider;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.management.FeedEventsListener;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.IStatementRewriter;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.RunStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.lock.MetadataLockManager;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.asterix.translator.AbstractLangTranslator;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.TypeTranslator;
import org.apache.asterix.translator.util.ValidateUtil;
import org.apache.asterix.utils.DataverseUtil;
import org.apache.asterix.utils.FeedOperations;
import org.apache.asterix.utils.FlushDatasetUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.serializer.ResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.UnmanagedFileSplit;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;

public class QueryTranslator
extends AbstractLangTranslator
implements IStatementExecutor {
    private static final Logger LOGGER = Logger.getLogger(QueryTranslator.class.getName());
    public static final boolean IS_DEBUG_MODE = false;
    protected final List<Statement> statements;
    protected final SessionConfig sessionConfig;
    protected Dataverse activeDataverse;
    protected final List<FunctionDecl> declaredFunctions;
    protected final APIFramework apiFramework;
    protected final IRewriterFactory rewriterFactory;
    protected final IStorageComponentProvider componentProvider;
    protected final ExecutorService executorService;

    public QueryTranslator(List<Statement> statements, SessionConfig conf, ILangCompilationProvider compliationProvider, IStorageComponentProvider componentProvider, ExecutorService executorService) {
        this.statements = statements;
        this.sessionConfig = conf;
        this.componentProvider = componentProvider;
        this.declaredFunctions = this.getDeclaredFunctions(statements);
        this.apiFramework = new APIFramework(compliationProvider);
        this.rewriterFactory = compliationProvider.getRewriterFactory();
        this.activeDataverse = MetadataBuiltinEntities.DEFAULT_DATAVERSE;
        this.executorService = executorService;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    protected List<FunctionDecl> getDeclaredFunctions(List<Statement> statements) {
        ArrayList<FunctionDecl> functionDecls = new ArrayList<FunctionDecl>();
        for (Statement st : statements) {
            if (st.getKind() != 9) continue;
            functionDecls.add((FunctionDecl)st);
        }
        return functionDecls;
    }

    public void compileAndExecute(IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.Stats stats) throws Exception {
        this.compileAndExecute(hcc, hdc, resultDelivery, stats, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndExecute(IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.Stats stats, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        int resultSetIdCounter = 0;
        FileSplit outputFile = null;
        PrinterBasedWriterFactory writerFactory = PrinterBasedWriterFactory.INSTANCE;
        ResultSerializerFactoryProvider resultSerializerFactoryProvider = ResultSerializerFactoryProvider.INSTANCE;
        HashMap<String, String> config = new HashMap<String, String>();
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryTranslator.class.getSimpleName());
        try {
            block37: for (Statement stmt : this.statements) {
                if (this.sessionConfig.is("format-html")) {
                    this.sessionConfig.out().println("<!-- BEGIN -->");
                }
                this.validateOperation(this.activeDataverse, stmt);
                this.rewriteStatement(stmt);
                MetadataProvider metadataProvider = new MetadataProvider(this.activeDataverse, this.componentProvider);
                metadataProvider.setWriterFactory((IAWriterFactory)writerFactory);
                metadataProvider.setResultSerializerFactoryProvider((IResultSerializerFactoryProvider)resultSerializerFactoryProvider);
                metadataProvider.setOutputFile(outputFile);
                metadataProvider.setConfig(config);
                switch (stmt.getKind()) {
                    case 14: {
                        this.handleSetStatement(stmt, config);
                        continue block37;
                    }
                    case 1: {
                        this.activeDataverse = this.handleUseDataverseStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 20: {
                        this.handleCreateDataverseStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 0: {
                        this.handleCreateDatasetStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 18: {
                        this.handleCreateIndexStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 15: {
                        this.handleCreateTypeStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 11: {
                        this.handleCreateNodeGroupStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 2: {
                        this.handleDataverseDropStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 3: {
                        this.handleDatasetDropStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 21: {
                        this.handleIndexDropStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 16: {
                        this.handleTypeDropStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 12: {
                        this.handleNodegroupDropStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 30: {
                        this.handleCreateFunctionStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 31: {
                        this.handleFunctionDropStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 10: {
                        this.handleLoadStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 5: 
                    case 6: {
                        if (((InsertStatement)stmt).getReturnExpression() != null) {
                            metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                            metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                        }
                        this.handleInsertUpsertStatement(metadataProvider, stmt, hcc, hdc, resultDelivery, stats, false, clientContextId, ctx);
                        continue block37;
                    }
                    case 4: {
                        this.handleDeleteStatement(metadataProvider, stmt, hcc, false);
                        continue block37;
                    }
                    case 22: {
                        this.handleCreateFeedStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 23: {
                        this.handleDropFeedStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 29: {
                        this.handleDropFeedPolicyStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 26: {
                        this.handleConnectFeedStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 27: {
                        this.handleDisconnectFeedStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 24: {
                        this.handleStartFeedStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 25: {
                        this.handleStopFeedStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 28: {
                        this.handleCreateFeedPolicyStatement(metadataProvider, stmt);
                        continue block37;
                    }
                    case 13: {
                        metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                        metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                        this.handleQuery(metadataProvider, (Query)stmt, hcc, hdc, resultDelivery, stats, clientContextId, ctx);
                        continue block37;
                    }
                    case 32: {
                        this.handleCompactStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 33: {
                        this.handleExternalDatasetRefreshStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 17: {
                        org.apache.hyracks.algebricks.common.utils.Pair<IAWriterFactory, FileSplit> result = this.handleWriteStatement(stmt);
                        writerFactory = result.first != null ? (IAWriterFactory)result.first : writerFactory;
                        outputFile = (FileSplit)result.second;
                        continue block37;
                    }
                    case 34: {
                        this.handleRunStatement(metadataProvider, stmt, hcc);
                        continue block37;
                    }
                    case 9: {
                        continue block37;
                    }
                    case 35: {
                        ((IExtensionStatement)stmt).handle((IStatementExecutor)this, metadataProvider, hcc, hdc, resultDelivery, stats, resultSetIdCounter);
                        continue block37;
                    }
                }
                throw new CompilationException("Unknown function");
            }
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    protected void handleSetStatement(Statement stmt, Map<String, String> config) {
        SetStatement ss = (SetStatement)stmt;
        String pname = ss.getPropName();
        String pvalue = ss.getPropValue();
        config.put(pname, pvalue);
    }

    protected org.apache.hyracks.algebricks.common.utils.Pair<IAWriterFactory, FileSplit> handleWriteStatement(Statement stmt) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        WriteStatement ws = (WriteStatement)stmt;
        File f = new File(ws.getFileName());
        UnmanagedFileSplit outputFile = new UnmanagedFileSplit(ws.getNcName().getValue(), f.getPath());
        IAWriterFactory writerFactory = null;
        if (ws.getWriterClassName() != null) {
            writerFactory = (IAWriterFactory)Class.forName(ws.getWriterClassName()).newInstance();
        }
        return new org.apache.hyracks.algebricks.common.utils.Pair(writerFactory, (Object)outputFile);
    }

    protected Dataverse handleUseDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DataverseDecl dvd = (DataverseDecl)stmt;
        String dvName = dvd.getDataverseName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.acquireDataverseReadLock(metadataProvider.getLocks(), dvName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv == null) {
                throw new MetadataException("Unknown dataverse " + dvName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            Dataverse dataverse = dv;
            return dataverse;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw new MetadataException((Throwable)e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateDataverseStatement stmtCreateDataverse = (CreateDataverseStatement)stmt;
        String dvName = stmtCreateDataverse.getDataverseName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.acquireDataverseReadLock(metadataProvider.getLocks(), dvName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv != null) {
                if (stmtCreateDataverse.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A dataverse with this name " + dvName + " already exists.");
            }
            MetadataManager.INSTANCE.addDataverse(metadataProvider.getMetadataTxnContext(), new Dataverse(dvName, stmtCreateDataverse.getFormat(), 0));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected static void validateCompactionPolicy(String compactionPolicy, Map<String, String> compactionPolicyProperties, MetadataTransactionContext mdTxnCtx, boolean isExternalDataset) throws CompilationException, Exception {
        CompactionPolicy compactionPolicyEntity = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, "Metadata", compactionPolicy);
        if (compactionPolicyEntity == null) {
            throw new CompilationException("Unknown compaction policy: " + compactionPolicy);
        }
        String compactionPolicyFactoryClassName = compactionPolicyEntity.getClassName();
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
        if (isExternalDataset && mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
            throw new CompilationException("The correlated-prefix merge policy cannot be used with external dataset.");
        }
        if (compactionPolicyProperties == null) {
            if (mergePolicyFactory.getName().compareTo("no-merge") != 0) {
                throw new CompilationException("Compaction policy properties are missing.");
            }
        } else {
            for (Map.Entry<String, String> entry : compactionPolicyProperties.entrySet()) {
                if (mergePolicyFactory.getPropertiesNames().contains(entry.getKey())) continue;
                throw new CompilationException("Invalid compaction policy property: " + entry.getKey());
            }
            for (String p : mergePolicyFactory.getPropertiesNames()) {
                if (compactionPolicyProperties.containsKey(p)) continue;
                throw new CompilationException("Missing compaction policy property: " + p);
            }
        }
    }

    public void handleCreateDatasetStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws CompilationException, Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        DatasetDecl dd = (DatasetDecl)stmt;
        String dataverseName = this.getActiveDataverse(dd.getDataverse());
        String datasetName = dd.getName().getValue();
        DatasetConfig.DatasetType dsType = dd.getDatasetType();
        String itemTypeDataverseName = this.getActiveDataverse(dd.getItemTypeDataverse());
        String itemTypeName = dd.getItemTypeName().getValue();
        String metaItemTypeDataverseName = this.getActiveDataverse(dd.getMetaItemTypeDataverse());
        String metaItemTypeName = dd.getMetaItemTypeName().getValue();
        Identifier ngNameId = dd.getNodegroupName();
        String nodegroupName = this.getNodeGroupName(ngNameId, dd, dataverseName);
        String compactionPolicy = dd.getCompactionPolicy();
        Map compactionPolicyProperties = dd.getCompactionPolicyProperties();
        boolean defaultCompactionPolicy = compactionPolicy == null;
        boolean temp = dd.getDatasetDetailsDecl().isTemp();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.createDatasetBegin(metadataProvider.getLocks(), dataverseName, itemTypeDataverseName, itemTypeDataverseName + "." + itemTypeName, metaItemTypeDataverseName, metaItemTypeDataverseName + "." + metaItemTypeName, nodegroupName, compactionPolicy, dataverseName + "." + datasetName, defaultCompactionPolicy);
        Dataset dataset = null;
        Index primaryIndex = null;
        try {
            String ngName;
            ExternalDatasetDetails datasetDetails = null;
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds != null) {
                if (dd.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A dataset with this name " + datasetName + " already exists.");
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), itemTypeDataverseName, itemTypeName);
            if (dt == null) {
                throw new AlgebricksException(": type " + itemTypeName + " could not be found.");
            }
            String string = ngName = ngNameId != null ? ngNameId.getValue() : QueryTranslator.configureNodegroupForDataset(dataverseName, datasetName, dd.getHints(), mdTxnCtx);
            if (compactionPolicy == null) {
                compactionPolicy = "prefix";
                compactionPolicyProperties = GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES;
            } else {
                QueryTranslator.validateCompactionPolicy(compactionPolicy, compactionPolicyProperties, mdTxnCtx, false);
            }
            switch (dd.getDatasetType()) {
                case INTERNAL: {
                    IAType itemType = dt.getDatatype();
                    if (itemType.getTypeTag() != ATypeTag.RECORD) {
                        throw new AlgebricksException("Dataset type has to be a record type.");
                    }
                    IAType metaItemType = null;
                    if (metaItemTypeDataverseName != null && metaItemTypeName != null) {
                        metaItemType = metadataProvider.findType(metaItemTypeDataverseName, metaItemTypeName);
                    }
                    if (metaItemType != null && metaItemType.getTypeTag() != ATypeTag.RECORD) {
                        throw new AlgebricksException("Dataset meta type has to be a record type.");
                    }
                    ARecordType metaRecType = (ARecordType)metaItemType;
                    List partitioningExprs = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs();
                    List keySourceIndicators = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getKeySourceIndicators();
                    boolean autogenerated = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated();
                    ARecordType aRecordType = (ARecordType)itemType;
                    List partitioningTypes = ValidateUtil.validatePartitioningExpressions((ARecordType)aRecordType, (ARecordType)metaRecType, (List)partitioningExprs, (List)keySourceIndicators, (boolean)autogenerated);
                    List filterField = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterField();
                    if (filterField != null) {
                        ValidateUtil.validateFilterField((ARecordType)aRecordType, (List)filterField);
                    }
                    if (compactionPolicy == null && filterField != null) {
                        compactionPolicy = "correlated-prefix";
                        compactionPolicyProperties = GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES;
                    }
                    datasetDetails = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, partitioningExprs, partitioningExprs, keySourceIndicators, partitioningTypes, autogenerated, filterField, temp);
                    break;
                }
                case EXTERNAL: {
                    String adapter = ((ExternalDetailsDecl)dd.getDatasetDetailsDecl()).getAdapter();
                    Map properties = ((ExternalDetailsDecl)dd.getDatasetDetailsDecl()).getProperties();
                    datasetDetails = new ExternalDatasetDetails(adapter, properties, new Date(), DatasetConfig.TransactionState.COMMIT);
                    break;
                }
                default: {
                    throw new CompilationException("Unknown datatype " + dd.getDatasetType());
                }
            }
            if (!DatasetIdFactory.isInitialized()) {
                DatasetIdFactory.initialize((int)MetadataManager.INSTANCE.getMostRecentDatasetId());
            }
            dataset = new Dataset(dataverseName, datasetName, itemTypeDataverseName, itemTypeName, metaItemTypeDataverseName, metaItemTypeName, ngName, compactionPolicy, compactionPolicyProperties, (IDatasetDetails)datasetDetails, dd.getHints(), dsType, DatasetIdFactory.generateDatasetId(), 1);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            primaryIndex = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, datasetName);
            if (dd.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dataverseName);
                JobSpecification jobSpec = DatasetUtil.createDatasetJobSpec((Dataverse)dataverse, (String)datasetName, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
            }
            MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
            dataset.setPendingOp(0);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block29: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = DatasetUtil.dropDatasetJobSpec(dataset, primaryIndex, (MetadataProvider)metadataProvider);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block29;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void validateIfResourceIsActiveInFeed(Dataset dataset) throws CompilationException {
        IActiveEntityEventsListener[] listeners;
        StringBuilder builder = null;
        for (IActiveEntityEventsListener listener : listeners = ActiveJobNotificationHandler.INSTANCE.getEventListeners()) {
            if (!listener.isEntityUsingDataset((IDataset)dataset)) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(listener.getEntityId() + "\n");
        }
        if (builder != null) {
            throw new CompilationException("Dataset " + dataset.getDataverseName() + "." + dataset.getDatasetName() + " is currently being fed into by the following active entities.\n" + builder.toString());
        }
    }

    protected String getNodeGroupName(Identifier ngNameId, DatasetDecl dd, String dataverse) {
        if (ngNameId != null) {
            return ngNameId.getValue();
        }
        String hintValue = (String)dd.getHints().get("NODEGROUP_CARDINALITY");
        if (hintValue == null) {
            return "DEFAULT_NG_ALL_NODES";
        }
        return dataverse + ":" + dd.getName().getValue();
    }

    protected static String configureNodegroupForDataset(String dataverseName, String datasetName, Map<String, String> hints, MetadataTransactionContext mdTxnCtx) throws CompilationException {
        String hintValue = hints.get("NODEGROUP_CARDINALITY");
        if (hintValue == null) {
            String nodegroupName = "DEFAULT_NG_ALL_NODES";
            return nodegroupName;
        }
        int numChosen = 0;
        boolean valid = (Boolean)DatasetHints.validate((String)"NODEGROUP_CARDINALITY", (String)hints.get((Object)"NODEGROUP_CARDINALITY")).first;
        if (!valid) {
            throw new CompilationException("Incorrect use of hint:NODEGROUP_CARDINALITY");
        }
        int nodegroupCardinality = Integer.parseInt(hints.get("NODEGROUP_CARDINALITY"));
        List nodeNames = AppContextInfo.INSTANCE.getMetadataProperties().getNodeNames();
        ArrayList nodeNamesClone = new ArrayList(nodeNames);
        String metadataNodeName = AppContextInfo.INSTANCE.getMetadataProperties().getMetadataNodeName();
        ArrayList<String> selectedNodes = new ArrayList<String>();
        selectedNodes.add(metadataNodeName);
        nodeNamesClone.remove(metadataNodeName);
        if (++numChosen < nodegroupCardinality) {
            int i;
            Random random = new Random();
            String[] nodes = nodeNamesClone.toArray(new String[0]);
            int[] b = new int[nodeNamesClone.size()];
            for (i = 0; i < b.length; ++i) {
                b[i] = i;
            }
            for (i = 0; i < nodegroupCardinality - numChosen; ++i) {
                int selected = i + random.nextInt(nodeNamesClone.size() - i);
                int selNodeIndex = b[selected];
                selectedNodes.add(nodes[selNodeIndex]);
                int temp = b[0];
                b[0] = b[selected];
                b[selected] = temp;
            }
        }
        String nodegroupName = dataverseName + ":" + datasetName;
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(nodegroupName, selectedNodes));
        return nodegroupName;
    }

    protected void handleCreateIndexStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        CreateIndexStatement stmtCreateIndex = (CreateIndexStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtCreateIndex.getDataverseName());
        String datasetName = stmtCreateIndex.getDatasetName().getValue();
        List keySourceIndicators = stmtCreateIndex.getFieldSourceIndicators();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.createIndexBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
        String indexName = null;
        JobSpecification spec = null;
        Dataset ds = null;
        List externalFilesSnapshot = null;
        boolean firstExternalDatasetIndex = false;
        boolean filesIndexReplicated = false;
        Index filesIndex = null;
        boolean datasetLocked = false;
        Index index = null;
        try {
            ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
            }
            indexName = stmtCreateIndex.getIndexName().getValue();
            index = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getItemTypeDataverseName(), ds.getItemTypeName());
            ARecordType aRecordType = (ARecordType)dt.getDatatype();
            ARecordType metaRecordType = null;
            if (ds.hasMetaPart()) {
                Datatype metaDt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getMetaItemTypeDataverseName(), ds.getMetaItemTypeName());
                metaRecordType = (ARecordType)metaDt.getDatatype();
            }
            ArrayList<Object> indexFields = new ArrayList<Object>();
            ArrayList<IAType> indexFieldTypes = new ArrayList<IAType>();
            int keyIndex = 0;
            for (Object fieldExpr : stmtCreateIndex.getFieldExprs()) {
                int i;
                IAType fieldType = null;
                ARecordType subType = KeyFieldTypeUtil.chooseSource((List)keySourceIndicators, (int)keyIndex, (ARecordType)aRecordType, (ARecordType)metaRecordType);
                boolean isOpen = subType.isOpen();
                if (((List)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first).size() > 1 && !isOpen) {
                    for (i = 0; i < ((List)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first).size() - 1 && !isOpen; ++i) {
                        subType = (ARecordType)subType.getFieldType((String)((List)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first).get(i));
                        isOpen = subType.isOpen();
                    }
                }
                if (((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).second == null) {
                    fieldType = subType.getSubFieldType(((List)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first).subList(i, ((List)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first).size()));
                } else {
                    if (!stmtCreateIndex.isEnforced()) {
                        throw new AlgebricksException("Cannot create typed index on \"" + ((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first + "\" field without enforcing it's type");
                    }
                    if (!isOpen) {
                        throw new AlgebricksException("Typed index on \"" + ((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first + "\" field could be created only for open datatype");
                    }
                    if (stmtCreateIndex.hasMetaField()) {
                        throw new AlgebricksException("Typed open index can only be created on the record part");
                    }
                    Map typeMap = TypeTranslator.computeTypes((MetadataTransactionContext)mdTxnCtx, (TypeExpression)((TypeExpression)((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).second), (String)indexName, (String)dataverseName);
                    TypeSignature typeSignature = new TypeSignature(dataverseName, indexName);
                    fieldType = (IAType)typeMap.get(typeSignature);
                }
                if (fieldType == null) {
                    throw new AlgebricksException("Unknown type " + (((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).second == null ? ((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first : ((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).second));
                }
                indexFields.add(((org.apache.hyracks.algebricks.common.utils.Pair)fieldExpr).first);
                indexFieldTypes.add(fieldType);
                ++keyIndex;
            }
            ValidateUtil.validateKeyFields((ARecordType)aRecordType, (ARecordType)metaRecordType, indexFields, (List)keySourceIndicators, indexFieldTypes, (DatasetConfig.IndexType)stmtCreateIndex.getIndexType());
            if (index != null) {
                if (stmtCreateIndex.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("An index with this name " + indexName + " already exists.");
            }
            if (stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX) {
                Object fieldExpr;
                List partitioningKeys = DatasetUtil.getPartitioningKeys((Dataset)ds);
                fieldExpr = partitioningKeys.iterator();
                while (fieldExpr.hasNext()) {
                    List partitioningKey = (List)fieldExpr.next();
                    IAType keyType = aRecordType.getSubFieldType(partitioningKey);
                    ITypeTraits typeTrait = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                    if (typeTrait.getFixedLength() >= 0) continue;
                    throw new AlgebricksException("The keyword or ngram index -" + indexName + " cannot be created on the dataset -" + datasetName + " due to its variable-length primary key field - " + partitioningKey);
                }
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                this.validateIfResourceIsActiveInFeed(ds);
            } else {
                if (!ExternalIndexingOperations.isIndexible((ExternalDatasetDetails)((ExternalDatasetDetails)ds.getDatasetDetails()))) {
                    throw new AlgebricksException("dataset using " + ((ExternalDatasetDetails)ds.getDatasetDetails()).getAdapter() + " Adapter can't be indexed");
                }
                if (!ExternalIndexingOperations.isValidIndexName((String)datasetName, (String)indexName)) {
                    throw new AlgebricksException("external dataset index name is invalid");
                }
                filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                firstExternalDatasetIndex = filesIndex == null;
                ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                datasetLocked = true;
                if (firstExternalDatasetIndex && (filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName))) != null) {
                    ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
                    firstExternalDatasetIndex = false;
                    ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                }
                if (firstExternalDatasetIndex) {
                    externalFilesSnapshot = ExternalIndexingOperations.getSnapshotFromExternalFileSystem((Dataset)ds);
                    filesIndex = new Index(dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName), DatasetConfig.IndexType.BTREE, ExternalIndexingOperations.FILE_INDEX_FIELD_NAMES, null, ExternalIndexingOperations.FILE_INDEX_FIELD_TYPES, false, false, 1);
                    MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                    for (ExternalFile file : externalFilesSnapshot) {
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                    }
                    spec = ExternalIndexingOperations.buildFilesIndexReplicationJobSpec((Dataset)ds, (List)externalFilesSnapshot, (MetadataProvider)metadataProvider, (boolean)true);
                    if (spec == null) {
                        throw new CompilationException("Failed to create job spec for replicating Files Index For external dataset");
                    }
                    filesIndexReplicated = true;
                    JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
                }
            }
            if (stmtCreateIndex.isEnforced()) {
                List indexes = MetadataManager.INSTANCE.getDatasetIndexes(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                for (Index existingIndex : indexes) {
                    if (!existingIndex.getKeyFieldNames().equals(indexFields) || existingIndex.getKeyFieldTypes().equals(indexFieldTypes) || !existingIndex.isEnforcingKeyFileds()) continue;
                    throw new CompilationException("Cannot create index " + indexName + " , enforced index " + existingIndex.getIndexName() + " on field \"" + StringUtils.join(indexFields, (char)',') + "\" is already defined with type \"" + existingIndex.getKeyFieldTypes() + "\"");
                }
            }
            index = new Index(dataverseName, datasetName, indexName, stmtCreateIndex.getIndexType(), indexFields, keySourceIndicators, indexFieldTypes, stmtCreateIndex.getGramLength(), stmtCreateIndex.isEnforced(), false, 1);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            ARecordType enforcedType = null;
            ARecordType enforcedMetaType = null;
            if (stmtCreateIndex.isEnforced()) {
                org.apache.hyracks.algebricks.common.utils.Pair enforcedTypes = TypeUtil.createEnforcedType((ARecordType)aRecordType, (ARecordType)metaRecordType, (List)Lists.newArrayList((Object[])new Index[]{index}));
                enforcedType = (ARecordType)enforcedTypes.first;
                enforcedMetaType = (ARecordType)enforcedTypes.second;
            }
            if ((spec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)ds, (Index)index, (ARecordType)aRecordType, (ARecordType)metaRecordType, enforcedType, enforcedMetaType, (MetadataProvider)metadataProvider)) == null) {
                throw new CompilationException("Failed to create job spec for creating index '" + stmtCreateIndex.getDatasetName() + "." + stmtCreateIndex.getIndexName() + "'");
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            spec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)ds, (Index)index, (ARecordType)aRecordType, (ARecordType)metaRecordType, (ARecordType)enforcedType, (ARecordType)enforcedMetaType, (MetadataProvider)metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
            index.setPendingOp(0);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            if (firstExternalDatasetIndex) {
                MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, filesIndex.getIndexName());
                filesIndex.setPendingOp(0);
                MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(new Date());
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            JobSpecification jobSpec;
            block50: {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (filesIndexReplicated) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    try {
                        jobSpec = ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block50;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block51: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        jobSpec = IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block51;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                if (firstExternalDatasetIndex) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending files for(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                    }
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + IndexingConstants.getFilesIndexName((String)datasetName) + ") couldn't be removed from the metadata", e);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is in inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + indexName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            if (datasetLocked) {
                ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
            }
        }
    }

    protected void handleCreateTypeStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDecl stmtCreateType = (TypeDecl)stmt;
        String dataverseName = this.getActiveDataverse(stmtCreateType.getDataverseName());
        String typeName = stmtCreateType.getIdent().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.createTypeBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + typeName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new AlgebricksException("Unknown dataverse " + dataverseName);
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt != null) {
                if (!stmtCreateType.getIfNotExists()) {
                    throw new AlgebricksException("A datatype with this name " + typeName + " already exists.");
                }
            } else {
                if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
                    throw new AlgebricksException("Cannot redefine builtin type " + typeName + ".");
                }
                Map typeMap = TypeTranslator.computeTypes((MetadataTransactionContext)mdTxnCtx, (TypeExpression)stmtCreateType.getTypeDef(), (String)stmtCreateType.getIdent().getValue(), (String)dataverseName);
                TypeSignature typeSignature = new TypeSignature(dataverseName, typeName);
                IAType type = (IAType)typeMap.get(typeSignature);
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(dataverseName, typeName, type, false));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDataverseDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        DataverseDropStatement stmtDelete = (DataverseDropStatement)stmt;
        String dataverseName = stmtDelete.getDataverseName().getValue();
        if (dataverseName.equals("Default")) {
            throw new HyracksDataException("Default dataverse can't be dropped");
        }
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataLockManager.INSTANCE.acquireDataverseWriteLock(metadataProvider.getLocks(), dataverseName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                if (stmtDelete.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("There is no dataverse with this name " + dataverseName + ".");
            }
            IActiveEntityEventsListener[] activeListeners = ActiveJobNotificationHandler.INSTANCE.getEventListeners();
            Identifier dvId = new Identifier(dataverseName);
            MetadataProvider tempMdProvider = new MetadataProvider(metadataProvider.getDefaultDataverse(), metadataProvider.getStorageComponentProvider());
            tempMdProvider.setConfig(metadataProvider.getConfig());
            for (IActiveEntityEventsListener listener : activeListeners) {
                EntityId activeEntityId = listener.getEntityId();
                if (!activeEntityId.getExtensionName().equals("Feed") || !activeEntityId.getDataverse().equals(dataverseName)) continue;
                tempMdProvider.getLocks().reset();
                this.stopFeedBeforeDelete((org.apache.hyracks.algebricks.common.utils.Pair<Identifier, Identifier>)new org.apache.hyracks.algebricks.common.utils.Pair((Object)dvId, (Object)new Identifier(activeEntityId.getEntityName())), tempMdProvider);
                jobsToExecute.add(FeedOperations.buildRemoveFeedStorageJob(MetadataManager.INSTANCE.getFeed(mdTxnCtx, dataverseName, activeEntityId.getEntityName())));
            }
            List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverseName);
            for (int j = 0; j < datasets.size(); ++j) {
                List indexes;
                String datasetName = ((Dataset)datasets.get(j)).getDatasetName();
                DatasetConfig.DatasetType dsType = ((Dataset)datasets.get(j)).getDatasetType();
                if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                    indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                    for (int k = 0; k < indexes.size(); ++k) {
                        if (!((Index)indexes.get(k)).isSecondaryIndex()) continue;
                        jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)((Index)indexes.get(k)), (MetadataProvider)metadataProvider, (Dataset)((Dataset)datasets.get(j))));
                    }
                    Index primaryIndex = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, datasetName);
                    jobsToExecute.add(DatasetUtil.dropDatasetJobSpec((Dataset)((Dataset)datasets.get(j)), (Index)primaryIndex, (MetadataProvider)metadataProvider));
                    continue;
                }
                indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                for (int k = 0; k < indexes.size(); ++k) {
                    if (ExternalIndexingOperations.isFileIndex((Index)((Index)indexes.get(k)))) {
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)((Dataset)datasets.get(j))));
                        continue;
                    }
                    jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)((Index)indexes.get(k)), (MetadataProvider)metadataProvider, (Dataset)((Dataset)datasets.get(j))));
                }
                ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo((Dataset)datasets.get(j));
            }
            jobsToExecute.add(DataverseUtil.dropDataverseJobSpec(dv, metadataProvider));
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(dataverseName, dv.getDataFormat(), 2));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            if (this.activeDataverse != null && this.activeDataverse.getDataverseName() == dataverseName) {
                this.activeDataverse = null;
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                if (this.activeDataverse != null && this.activeDataverse.getDataverseName() == dataverseName) {
                    this.activeDataverse = null;
                }
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataverse(" + dataverseName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void stopFeedBeforeDelete(org.apache.hyracks.algebricks.common.utils.Pair<Identifier, Identifier> feedNameComp, MetadataProvider metadataProvider) {
        block3: {
            StopFeedStatement disStmt = new StopFeedStatement(feedNameComp);
            try {
                this.handleStopFeedStatement(metadataProvider, (Statement)disStmt);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Stopped feed " + ((Identifier)feedNameComp.second).getValue());
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.warning("Unable to stop feed " + ((Identifier)feedNameComp.second).getValue() + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDatasetDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        DropDatasetStatement stmtDelete = (DropDatasetStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtDelete.getDataverseName());
        String datasetName = stmtDelete.getDatasetName().getValue();
        MetadataLockManager.INSTANCE.dropDatasetBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
        try {
            QueryTranslator.doDropDataset(dataverseName, datasetName, metadataProvider, stmtDelete.getIfExists(), hcc);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public static void doDropDataset(String dataverseName, String datasetName, MetadataProvider metadataProvider, boolean ifExists, IHyracksClientConnection hcc) throws Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        MutableObject mdTxnCtx = new MutableObject((Object)MetadataManager.INSTANCE.beginTransaction());
        MutableBoolean bActiveTxn = new MutableBoolean(true);
        metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        ArrayList jobsToExecute = new ArrayList();
        try {
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                if (ifExists) {
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return;
                }
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName + ".");
            }
            ds.drop(metadataProvider, mdTxnCtx, jobsToExecute, bActiveTxn, progress, hcc);
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
        }
        catch (Exception e) {
            if (bActiveTxn.booleanValue()) {
                QueryTranslator.abort(e, e, (MetadataTransactionContext)mdTxnCtx.getValue());
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
                metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, (MetadataTransactionContext)mdTxnCtx.getValue());
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void handleIndexDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        IndexDropStatement stmtIndexDrop = (IndexDropStatement)stmt;
        String datasetName = stmtIndexDrop.getDatasetName().getValue();
        String dataverseName = this.getActiveDataverse(stmtIndexDrop.getDataverseName());
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataLockManager.INSTANCE.dropIndexBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
        String indexName = null;
        boolean dropFilesIndex = false;
        try {
            Index index;
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
            }
            IActiveEntityEventsListener[] listeners = ActiveJobNotificationHandler.INSTANCE.getEventListeners();
            StringBuilder builder = null;
            for (Object object : listeners) {
                if (!object.isEntityUsingDataset((IDataset)ds)) continue;
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(new FeedConnectionId(object.getEntityId(), datasetName) + "\n");
            }
            if (builder != null) {
                throw new CompilationException("Dataset" + datasetName + " is currently being fed into by the following active entities: " + builder.toString());
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                indexName = stmtIndexDrop.getIndexName().getValue();
                index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return;
                    }
                    throw new AlgebricksException("There is no index with this name " + indexName + ".");
                }
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds));
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isEnforcingKeyFileds(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
            } else {
                indexName = stmtIndexDrop.getIndexName().getValue();
                index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return;
                    }
                    throw new AlgebricksException("There is no index with this name " + indexName + ".");
                }
                if (ExternalIndexingOperations.isFileIndex((Index)index)) {
                    throw new AlgebricksException("Dropping a dataset's files index is not allowed.");
                }
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds));
                List datasetIndexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (datasetIndexes.size() == 2) {
                    dropFilesIndex = true;
                    for (Index index2 : datasetIndexes) {
                        if (!ExternalIndexingOperations.isFileIndex((Index)index2)) continue;
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds));
                        MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, index2.getIndexName());
                        MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, index2.getIndexName(), index2.getIndexType(), index2.getKeyFieldNames(), index2.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isEnforcingKeyFileds(), index2.isPrimaryIndex(), 2));
                    }
                }
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isEnforcingKeyFileds(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpecification : jobsToExecute) {
                    JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpecification, (boolean)true);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (dropFilesIndex) {
                    MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                    ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(ds);
                }
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
                    if (dropFilesIndex) {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + indexName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void handleTypeDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDropStatement stmtTypeDrop = (TypeDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtTypeDrop.getDataverseName());
        String typeName = stmtTypeDrop.getTypeName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.dropTypeBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + typeName);
        try {
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt == null) {
                if (!stmtTypeDrop.getIfExists()) {
                    throw new AlgebricksException("There is no datatype with this name " + typeName + ".");
                }
            } else {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, dataverseName, typeName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleNodegroupDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodeGroupDropStatement stmtDelete = (NodeGroupDropStatement)stmt;
        String nodegroupName = stmtDelete.getNodeGroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodegroupName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodegroupName);
            if (ng == null) {
                if (!stmtDelete.getIfExists()) {
                    throw new AlgebricksException("There is no nodegroup with this name " + nodegroupName + ".");
                }
            } else {
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodegroupName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFunctionStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFunctionStatement cfs = (CreateFunctionStatement)stmt;
        String dataverse = this.getActiveDataverseName(cfs.getSignature().getNamespace());
        cfs.getSignature().setNamespace(dataverse);
        String functionName = cfs.getaAterixFunction().getName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.functionStatementBegin(metadataProvider.getLocks(), dataverse, dataverse + "." + functionName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse);
            if (dv == null) {
                throw new AlgebricksException("There is no dataverse with this name " + dataverse + ".");
            }
            Function function = new Function(dataverse, functionName, cfs.getaAterixFunction().getArity(), cfs.getParamList(), "VOID", cfs.getFunctionBody(), "AQL", AbstractFunctionCallExpression.FunctionKind.SCALAR.toString());
            MetadataManager.INSTANCE.addFunction(mdTxnCtx, function);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleFunctionDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        FunctionDropStatement stmtDropFunction = (FunctionDropStatement)stmt;
        FunctionSignature signature = stmtDropFunction.getFunctionSignature();
        signature.setNamespace(this.getActiveDataverseName(signature.getNamespace()));
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.functionStatementBegin(metadataProvider.getLocks(), signature.getNamespace(), signature.getNamespace() + "." + signature.getName());
        try {
            Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
            if (function == null) {
                if (!stmtDropFunction.getIfExists()) {
                    throw new AlgebricksException("Unknonw function " + signature);
                }
            } else {
                MetadataManager.INSTANCE.dropFunction(mdTxnCtx, signature);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleLoadStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        LoadStatement loadStmt = (LoadStatement)stmt;
        String dataverseName = this.getActiveDataverse(loadStmt.getDataverseName());
        String datasetName = loadStmt.getDatasetName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.modifyDatasetBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
        try {
            CompiledStatements.CompiledLoadFromFileStatement cls = new CompiledStatements.CompiledLoadFromFileStatement(dataverseName, loadStmt.getDatasetName().getValue(), loadStmt.getAdapter(), loadStmt.getProperties(), loadStmt.dataIsAlreadySorted());
            JobSpecification spec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, null, 0, null, this.sessionConfig, (CompiledStatements.ICompiledDmlStatement)cls);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (spec != null) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSpecification handleInsertUpsertStatement(final MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.Stats stats, boolean compileOnly, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        final InsertStatement stmtInsertUpsert = (InsertStatement)stmt;
        final String dataverseName = this.getActiveDataverse(stmtInsertUpsert.getDataverseName());
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() {
                MetadataLockManager.INSTANCE.insertDeleteUpsertBegin(metadataProvider.getLocks(), dataverseName + "." + stmtInsertUpsert.getDatasetName());
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                metadataProvider.setWriteTransaction(true);
                JobSpecification jobSpec = this.rewriteCompileInsertUpsert((IClusterInfoCollector)hcc, metadataProvider, stmtInsertUpsert);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return jobSpec;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        if (compileOnly) {
            locker.lock();
            try {
                JobSpecification jobSpecification = compiler.compile();
                return jobSpecification;
            }
            finally {
                locker.unlock();
            }
        }
        if (stmtInsertUpsert.getReturnExpression() != null) {
            this.deliverResult(hcc, hdc, compiler, metadataProvider, locker, resultDelivery, stats, clientContextId, ctx);
        } else {
            locker.lock();
            try {
                JobSpecification jobSpec = compiler.compile();
                if (jobSpec == null) {
                    JobSpecification jobSpecification = jobSpec;
                    return jobSpecification;
                }
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            finally {
                locker.unlock();
            }
        }
        return null;
    }

    public JobSpecification handleDeleteStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, boolean compileOnly) throws Exception {
        DeleteStatement stmtDelete = (DeleteStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtDelete.getDataverseName());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.insertDeleteUpsertBegin(metadataProvider.getLocks(), dataverseName + "." + stmtDelete.getDatasetName());
        try {
            metadataProvider.setWriteTransaction(true);
            CompiledStatements.CompiledDeleteStatement clfrqs = new CompiledStatements.CompiledDeleteStatement(stmtDelete.getVariableExpr(), dataverseName, stmtDelete.getDatasetName().getValue(), stmtDelete.getCondition(), stmtDelete.getVarCounter(), stmtDelete.getQuery());
            JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, clfrqs.getQuery(), (CompiledStatements.ICompiledDmlStatement)clfrqs);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (jobSpec != null && !compileOnly) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            JobSpecification jobSpecification = jobSpec;
            return jobSpecification;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public JobSpecification rewriteCompileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, CompiledStatements.ICompiledDmlStatement stmt) throws RemoteException, AlgebricksException, ACIDException {
        org.apache.hyracks.algebricks.common.utils.Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)query, this.sessionConfig);
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, (Query)rewrittenResult.first, (Integer)rewrittenResult.second, stmt == null ? null : stmt.getDatasetName(), this.sessionConfig, stmt);
    }

    private JobSpecification rewriteCompileInsertUpsert(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, InsertStatement insertUpsert) throws RemoteException, AlgebricksException, ACIDException {
        CompiledStatements.CompiledInsertStatement clfrqs;
        org.apache.hyracks.algebricks.common.utils.Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)insertUpsert, this.sessionConfig);
        InsertStatement rewrittenInsertUpsert = (InsertStatement)rewrittenResult.first;
        String dataverseName = this.getActiveDataverse(rewrittenInsertUpsert.getDataverseName());
        String datasetName = rewrittenInsertUpsert.getDatasetName().getValue();
        switch (insertUpsert.getKind()) {
            case 5: {
                clfrqs = new CompiledStatements.CompiledInsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                break;
            }
            case 6: {
                clfrqs = new CompiledStatements.CompiledUpsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                break;
            }
            default: {
                throw new AlgebricksException("Unsupported statement type " + rewrittenInsertUpsert.getKind());
            }
        }
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, rewrittenInsertUpsert.getQuery(), (Integer)rewrittenResult.second, datasetName, this.sessionConfig, (CompiledStatements.ICompiledDmlStatement)clfrqs);
    }

    protected void handleCreateFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFeedStatement cfs = (CreateFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.createFeedBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + feedName);
        Feed feed = null;
        try {
            feed = MetadataManager.INSTANCE.getFeed(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
            if (feed != null) {
                if (cfs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A feed with this name " + feedName + " already exists.");
            }
            String adaptorName = cfs.getAdaptorName();
            feed = new Feed(dataverseName, feedName, adaptorName, cfs.getAdaptorConfiguration());
            FeedMetadataUtil.validateFeed((Feed)feed, (MetadataTransactionContext)mdTxnCtx, (ILibraryManager)metadataProvider.getLibraryManager());
            MetadataManager.INSTANCE.addFeed(metadataProvider.getMetadataTxnContext(), feed);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws AlgebricksException, HyracksDataException {
        FeedPolicyEntity newPolicy = null;
        MetadataTransactionContext mdTxnCtx = null;
        CreateFeedPolicyStatement cfps = (CreateFeedPolicyStatement)stmt;
        String dataverse = this.getActiveDataverse(null);
        String policy = cfps.getPolicyName();
        MetadataLockManager.INSTANCE.createFeedPolicyBegin(metadataProvider.getLocks(), dataverse, dataverse + "." + policy);
        try {
            String description;
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverse, policy);
            if (feedPolicy != null) {
                if (cfps.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A policy with this name " + policy + " already exists.");
            }
            boolean extendingExisting = cfps.getSourcePolicyName() != null;
            String string = description = cfps.getDescription() == null ? "" : cfps.getDescription();
            if (extendingExisting) {
                FeedPolicyEntity sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverse, cfps.getSourcePolicyName());
                if (sourceFeedPolicy == null && (sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), "Metadata", cfps.getSourcePolicyName())) == null) {
                    throw new AlgebricksException("Unknown policy " + cfps.getSourcePolicyName());
                }
                Map policyProperties = sourceFeedPolicy.getProperties();
                policyProperties.putAll(cfps.getProperties());
                newPolicy = new FeedPolicyEntity(dataverse, policy, description, policyProperties);
            } else {
                Properties prop = new Properties();
                try {
                    FileInputStream stream = new FileInputStream(cfps.getSourcePolicyFile());
                    prop.load(stream);
                }
                catch (Exception e) {
                    throw new AlgebricksException("Unable to read policy file" + cfps.getSourcePolicyFile(), (Throwable)e);
                }
                HashMap<String, String> policyProperties = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    policyProperties.put((String)entry.getKey(), (String)entry.getValue());
                }
                newPolicy = new FeedPolicyEntity(dataverse, policy, description, policyProperties);
            }
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, newPolicy);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (RemoteException | ACIDException e) {
            QueryTranslator.abort((Exception)e, (Exception)e, mdTxnCtx);
            throw new HyracksDataException(e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDropFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        FeedDropStatement stmtFeedDrop = (FeedDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtFeedDrop.getDataverseName());
        String feedName = stmtFeedDrop.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.dropFeedBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + feedName);
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, dataverseName, feedName);
            if (feed == null) {
                if (!stmtFeedDrop.getIfExists()) {
                    throw new AlgebricksException("There is no feed with this name " + feedName + ".");
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            EntityId feedId = new EntityId("Feed", dataverseName, feedName);
            FeedEventsListener listener = (FeedEventsListener)ActiveJobNotificationHandler.INSTANCE.getActiveEntityListener(feedId);
            if (listener != null) {
                throw new AlgebricksException("Feed " + feedId + " is currently active and connected to the following dataset(s) \n" + listener.toString());
            }
            JobSpecification spec = FeedOperations.buildRemoveFeedStorageJob(MetadataManager.INSTANCE.getFeed(mdTxnCtx, feedId.getDataverse(), feedId.getEntityName()));
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
            MetadataManager.INSTANCE.dropFeed(mdTxnCtx, dataverseName, feedName);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Removed feed " + feedId);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDropFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        FeedPolicyDropStatement stmtFeedPolicyDrop = (FeedPolicyDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtFeedPolicyDrop.getDataverseName());
        String policyName = stmtFeedPolicyDrop.getPolicyName().getValue();
        MetadataLockManager.INSTANCE.dropFeedPolicyBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + policyName);
        try {
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(mdTxnCtx, dataverseName, policyName);
            if (feedPolicy == null) {
                if (!stmtFeedPolicyDrop.getIfExists()) {
                    throw new AlgebricksException("Unknown policy " + policyName + " in dataverse " + dataverseName);
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            MetadataManager.INSTANCE.dropFeedPolicy(mdTxnCtx, dataverseName, policyName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleStartFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        StartFeedStatement sfs = (StartFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(sfs.getDataverseName());
        String feedName = sfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        EntityId entityId = new EntityId("Feed", dataverseName, feedName);
        Feed feed = FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
        List feedConnections = MetadataManager.INSTANCE.getFeedConections(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
        AqlCompilationProvider compilationProvider = new AqlCompilationProvider();
        StorageComponentProvider storageComponentProvider = new StorageComponentProvider();
        DefaultStatementExecutorFactory qtFactory = new DefaultStatementExecutorFactory();
        FeedEventsListener listener = (FeedEventsListener)ActiveJobNotificationHandler.INSTANCE.getActiveEntityListener(entityId);
        if (listener != null) {
            throw new AlgebricksException("Feed " + feedName + " is started already.");
        }
        MetadataLockManager.INSTANCE.startFeedBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + feedName, feedConnections);
        try {
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            for (FeedConnection connection : feedConnections) {
                Dataset ds = metadataProvider.findDataset(connection.getDataverseName(), connection.getDatasetName());
                datasets.add(ds);
            }
            Pair<JobSpecification, AlgebricksAbsolutePartitionConstraint> jobInfo = FeedOperations.buildStartFeedJob(this.sessionConfig, metadataProvider, feed, feedConnections, (ILangCompilationProvider)compilationProvider, storageComponentProvider, qtFactory, hcc);
            JobSpecification feedJob = (JobSpecification)jobInfo.getLeft();
            listener = new FeedEventsListener(entityId, datasets, ((AlgebricksAbsolutePartitionConstraint)jobInfo.getRight()).getLocations());
            ActiveJobNotificationHandler.INSTANCE.registerListener((IActiveEntityEventsListener)listener);
            IActiveEventSubscriber eventSubscriber = listener.subscribe(ActivityState.STARTED);
            feedJob.setProperty("ActiveJob", (Serializable)entityId);
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)feedJob, (boolean)Boolean.valueOf((String)metadataProvider.getConfig().get("wait-for-completion-feed")));
            eventSubscriber.sync();
            LOGGER.log(Level.INFO, "Submitted");
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            if (listener != null) {
                ActiveJobNotificationHandler.INSTANCE.unregisterListener((IActiveEntityEventsListener)listener);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleStopFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        String feedName;
        StopFeedStatement sfst = (StopFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(sfst.getDataverseName());
        EntityId feedId = new EntityId("Feed", dataverseName, feedName = sfst.getFeedName().getValue());
        FeedEventsListener listener = (FeedEventsListener)ActiveJobNotificationHandler.INSTANCE.getActiveEntityListener(feedId);
        if (listener == null) {
            throw new AlgebricksException("Feed " + feedName + " is not started.");
        }
        IActiveEventSubscriber eventSubscriber = listener.subscribe(ActivityState.STOPPED);
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.stopFeedBegin(metadataProvider.getLocks(), dataverseName, feedName);
        try {
            FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)feedName, (MetadataTransactionContext)mdTxnCtx);
            for (int i = 0; i < listener.getSources().length; ++i) {
                String intakeLocation = listener.getSources()[i];
                FeedOperations.SendStopMessageToNode(feedId, intakeLocation, i);
            }
            eventSubscriber.sync();
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleConnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        ConnectFeedStatement cfs = (ConnectFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String feedName = cfs.getFeedName();
        String datasetName = cfs.getDatasetName().getValue();
        String policyName = cfs.getPolicy();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        if (ActiveJobNotificationHandler.INSTANCE.getActiveEntityListener(new EntityId("Feed", dataverseName, feedName)) != null) {
            throw new CompilationException(3020, new Serializable[]{feedName});
        }
        MetadataLockManager.INSTANCE.connectFeedBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName, dataverseName + "." + feedName);
        try {
            FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)dataverseName, (String)datasetName, (MetadataTransactionContext)mdTxnCtx);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            ARecordType outputType = FeedMetadataUtil.getOutputType((IFeed)feed, (Map)feed.getAdapterConfiguration(), (String)"type-name");
            List appliedFunctions = cfs.getAppliedFunctions();
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            if (fc != null) {
                throw new AlgebricksException("Feed" + feedName + " is already connected dataset " + datasetName);
            }
            fc = new FeedConnection(dataverseName, feedName, datasetName, appliedFunctions, policyName, outputType.toString());
            MetadataManager.INSTANCE.addFeedConnection(metadataProvider.getMetadataTxnContext(), fc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDisconnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DisconnectFeedStatement cfs = (DisconnectFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String datasetName = cfs.getDatasetName().getValue();
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        if (ActiveJobNotificationHandler.INSTANCE.getActiveEntityListener(new EntityId("Feed", dataverseName, feedName)) != null) {
            throw new CompilationException(3020, new Serializable[]{feedName});
        }
        MetadataLockManager.INSTANCE.disconnectFeedBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName, dataverseName + "." + cfs.getFeedName());
        try {
            FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)dataverseName, (String)cfs.getDatasetName().getValue(), (MetadataTransactionContext)mdTxnCtx);
            FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)cfs.getFeedName().getValue(), (MetadataTransactionContext)mdTxnCtx);
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            if (fc == null) {
                throw new CompilationException("Feed " + feedName + " is currently not connected to " + cfs.getDatasetName().getValue() + ". Invalid operation!");
            }
            MetadataManager.INSTANCE.dropFeedConnection(mdTxnCtx, dataverseName, feedName, datasetName);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCompactStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        CompactStatement compactStatement = (CompactStatement)stmt;
        String dataverseName = this.getActiveDataverse(compactStatement.getDataverseName());
        String datasetName = compactStatement.getDatasetName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataLockManager.INSTANCE.compactBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
        try {
            List indexes;
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName + ".");
            }
            String itemTypeName = ds.getItemTypeName();
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getItemTypeDataverseName(), itemTypeName);
            ARecordType metaRecordType = null;
            if (ds.hasMetaPart()) {
                metaRecordType = (ARecordType)MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getMetaItemTypeDataverseName(), ds.getMetaItemTypeName()).getDatatype();
            }
            if ((indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName)).isEmpty()) {
                throw new AlgebricksException("Cannot compact the extrenal dataset " + datasetName + " because it has no indexes");
            }
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dataverseName);
            jobsToExecute.add(DatasetUtil.compactDatasetJobSpec((Dataverse)dataverse, (String)datasetName, (MetadataProvider)metadataProvider));
            ARecordType aRecordType = (ARecordType)dt.getDatatype();
            org.apache.hyracks.algebricks.common.utils.Pair enforcedTypes = TypeUtil.createEnforcedType((ARecordType)aRecordType, (ARecordType)metaRecordType, (List)indexes);
            ARecordType enforcedType = (ARecordType)enforcedTypes.first;
            ARecordType enforcedMeta = (ARecordType)enforcedTypes.second;
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                for (int j = 0; j < indexes.size(); ++j) {
                    if (!((Index)indexes.get(j)).isSecondaryIndex()) continue;
                    jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)((Index)indexes.get(j)), (ARecordType)aRecordType, (ARecordType)metaRecordType, (ARecordType)enforcedType, (ARecordType)enforcedMeta, (MetadataProvider)metadataProvider));
                }
            } else {
                this.prepareCompactJobsForExternalDataset(indexes, ds, jobsToExecute, aRecordType, metaRecordType, metadataProvider, enforcedType, enforcedMeta);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void prepareCompactJobsForExternalDataset(List<Index> indexes, Dataset ds, List<JobSpecification> jobsToExecute, ARecordType aRecordType, ARecordType metaRecordType, MetadataProvider metadataProvider, ARecordType enforcedType, ARecordType enforcedMeta) throws AlgebricksException {
        for (int j = 0; j < indexes.size(); ++j) {
            if (ExternalIndexingOperations.isFileIndex((Index)indexes.get(j))) continue;
            jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)indexes.get(j), (ARecordType)aRecordType, (ARecordType)metaRecordType, (ARecordType)enforcedType, (ARecordType)enforcedMeta, (MetadataProvider)metadataProvider));
        }
        jobsToExecute.add(ExternalIndexingOperations.compactFilesIndexJobSpec((Dataset)ds, (MetadataProvider)metadataProvider, (IStorageComponentProvider)new StorageComponentProvider()));
    }

    protected void handleQuery(final MetadataProvider metadataProvider, Query query, IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.Stats stats, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, query, null);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return query.isExplain() || !this.sessionConfig.isExecuteQuery() ? null : jobSpec;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), e);
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        this.deliverResult(hcc, hdc, compiler, metadataProvider, locker, resultDelivery, stats, clientContextId, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResult(IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementCompiler compiler, MetadataProvider metadataProvider, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.Stats stats, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        ResultSetId resultSetId = metadataProvider.getResultSetId();
        switch (resultDelivery) {
            case ASYNC: {
                MutableBoolean printed = new MutableBoolean(false);
                this.executorService.submit(() -> this.asyncCreateAndRunJob(hcc, compiler, locker, resultDelivery, clientContextId, ctx, resultSetId, printed));
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    while (!printed.booleanValue()) {
                        printed.wait();
                    }
                    break;
                }
            }
            case IMMEDIATE: {
                QueryTranslator.createAndRunJob(hcc, null, compiler, locker, resultDelivery, id -> {
                    ResultReader resultReader = new ResultReader(hdc, id, resultSetId);
                    ResultUtil.printResults(resultReader, this.sessionConfig, stats, metadataProvider.findOutputRecordType());
                }, clientContextId, ctx);
                break;
            }
            case DEFERRED: {
                QueryTranslator.createAndRunJob(hcc, null, compiler, locker, resultDelivery, id -> ResultUtil.printResultHandle(this.sessionConfig, new ResultHandle(id, resultSetId)), clientContextId, ctx);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncCreateAndRunJob(IHyracksClientConnection hcc, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, String clientContextId, IStatementExecutorContext ctx, ResultSetId resultSetId, MutableBoolean printed) {
        MutableObject jobId = new MutableObject((Object)JobId.INVALID);
        try {
            QueryTranslator.createAndRunJob(hcc, (Mutable<JobId>)jobId, compiler, locker, resultDelivery, id -> {
                ResultHandle handle = new ResultHandle(id, resultSetId);
                ResultUtil.printStatus(this.sessionConfig, AbstractQueryApiServlet.ResultStatus.RUNNING);
                ResultUtil.printResultHandle(this.sessionConfig, handle);
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    printed.setTrue();
                    printed.notify();
                }
            }, clientContextId, ctx);
        }
        catch (Exception e) {
            if (JobId.INVALID.equals(jobId.getValue())) {
                ResultUtil.printStatus(this.sessionConfig, AbstractQueryApiServlet.ResultStatus.FAILED);
                ResultUtil.printError(this.sessionConfig.out(), e);
            } else {
                GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, resultDelivery.name() + " job with id " + jobId.getValue() + " failed", e);
            }
        }
        finally {
            MutableBoolean mutableBoolean = printed;
            synchronized (mutableBoolean) {
                if (printed.isFalse()) {
                    printed.setTrue();
                    printed.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAndRunJob(IHyracksClientConnection hcc, Mutable<JobId> jId, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IResultPrinter printer, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        locker.lock();
        try {
            JobSpecification jobSpec = compiler.compile();
            if (jobSpec == null) {
                return;
            }
            JobId jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)false);
            if (ctx != null && clientContextId != null) {
                ctx.put(clientContextId, jobId);
            }
            if (jId != null) {
                jId.setValue((Object)jobId);
            }
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                printer.print(jobId);
                hcc.waitForCompletion(jobId);
            } else {
                hcc.waitForCompletion(jobId);
                printer.print(jobId);
            }
        }
        finally {
            locker.unlock();
            if (ctx != null && clientContextId != null) {
                ctx.removeJobIdFromClientContextId(clientContextId);
            }
        }
    }

    protected void handleCreateNodeGroupStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodegroupDecl stmtCreateNodegroup = (NodegroupDecl)stmt;
        String ngName = stmtCreateNodegroup.getNodegroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.acquireNodeGroupWriteLock(metadataProvider.getLocks(), ngName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, ngName);
            if (ng != null) {
                if (!stmtCreateNodegroup.getIfNotExists()) {
                    throw new AlgebricksException("A nodegroup with this name " + ngName + " already exists.");
                }
            } else {
                List ncIdentifiers = stmtCreateNodegroup.getNodeControllerNames();
                ArrayList<String> ncNames = new ArrayList<String>(ncIdentifiers.size());
                for (Identifier id : ncIdentifiers) {
                    ncNames.add(id.getValue());
                }
                MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(ngName, ncNames));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExternalDatasetRefreshStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        block30: {
            RefreshExternalDatasetStatement stmtRefresh = (RefreshExternalDatasetStatement)stmt;
            String dataverseName = this.getActiveDataverse(stmtRefresh.getDataverseName());
            String datasetName = stmtRefresh.getDatasetName().getValue();
            DatasetConfig.TransactionState transactionState = DatasetConfig.TransactionState.COMMIT;
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            JobSpecification spec = null;
            Dataset ds = null;
            List metadataFiles = null;
            ArrayList deletedFiles = null;
            ArrayList addedFiles = null;
            ArrayList appendedFiles = null;
            List indexes = null;
            Dataset transactionDataset = null;
            boolean lockAquired = false;
            boolean success = false;
            MetadataLockManager.INSTANCE.refreshDatasetBegin(metadataProvider.getLocks(), dataverseName, dataverseName + "." + datasetName);
            try {
                ds = metadataProvider.findDataset(dataverseName, datasetName);
                if (ds == null) {
                    throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
                }
                if (ds.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                    throw new AlgebricksException("dataset " + datasetName + " in dataverse " + dataverseName + " is not an external dataset");
                }
                indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (indexes.isEmpty()) {
                    throw new AlgebricksException("External dataset " + datasetName + " in dataverse " + dataverseName + " doesn't have any index");
                }
                Date txnTime = new Date();
                ExternalDatasetsRegistry.INSTANCE.refreshBegin(ds);
                lockAquired = true;
                metadataFiles = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, ds);
                deletedFiles = new ArrayList();
                addedFiles = new ArrayList();
                appendedFiles = new ArrayList();
                if (ExternalIndexingOperations.isDatasetUptodate((Dataset)ds, (List)metadataFiles, addedFiles, deletedFiles, appendedFiles)) {
                    ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(txnTime);
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                transactionDataset = ExternalIndexingOperations.createTransactionDataset((Dataset)ds);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : appendedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                spec = ExternalIndexingOperations.buildFilesIndexUpdateOp((Dataset)ds, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.BEGIN;
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
                for (Index index : indexes) {
                    if (ExternalIndexingOperations.isFileIndex((Index)index)) continue;
                    spec = ExternalIndexingOperations.buildIndexUpdateOp((Dataset)ds, (Index)index, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider);
                    JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
                }
                spec = ExternalIndexingOperations.buildCommitJob((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.READY_TO_COMMIT);
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setRefreshTimestamp(txnTime);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.READY_TO_COMMIT;
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                for (ExternalFile file : metadataFiles) {
                    if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        continue;
                    }
                    if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                    Iterator iterator = appendedFiles.iterator();
                    while (iterator.hasNext()) {
                        ExternalFile appendedFile = (ExternalFile)iterator.next();
                        if (!file.getFileName().equals(appendedFile.getFileName())) continue;
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, appendedFile);
                        appendedFile.setFileNumber(file.getFileNumber());
                        appendedFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, appendedFile);
                        iterator.remove();
                    }
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                success = true;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (transactionState == DatasetConfig.TransactionState.READY_TO_COMMIT) {
                    throw new IllegalStateException("System is inconsistent state: commit of (" + dataverseName + "." + datasetName + ") refresh couldn't carry out the commit phase", e);
                }
                if (transactionState == DatasetConfig.TransactionState.COMMIT) {
                    throw e;
                }
                if (transactionState != DatasetConfig.TransactionState.BEGIN) break block30;
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                spec = ExternalIndexingOperations.buildAbortOp((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                try {
                    JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to abort refresh", e);
                }
                try {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    for (ExternalFile file : deletedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : addedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : appendedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to drop delta files", e);
                }
            }
            finally {
                if (lockAquired) {
                    ExternalDatasetsRegistry.INSTANCE.refreshEnd(ds, success);
                }
                metadataProvider.getLocks().unlock();
            }
        }
    }

    protected void handleRunStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws CompilationException, Exception {
        RunStatement runStmt = (RunStatement)stmt;
        switch (runStmt.getSystem()) {
            case "pregel": 
            case "pregelix": {
                this.handlePregelixStatement(metadataProvider, (Statement)runStmt, hcc);
                break;
            }
            default: {
                throw new AlgebricksException("The system \"" + runStmt.getSystem() + "\" specified in your run statement is not supported.");
            }
        }
    }

    protected void handlePregelixStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        RunStatement pregelixStmt = (RunStatement)stmt;
        boolean bActiveTxn = true;
        String dataverseNameFrom = this.getActiveDataverse(pregelixStmt.getDataverseNameFrom());
        String dataverseNameTo = this.getActiveDataverse(pregelixStmt.getDataverseNameTo());
        String datasetNameFrom = pregelixStmt.getDatasetNameFrom().getValue();
        String datasetNameTo = pregelixStmt.getDatasetNameTo().getValue();
        String fullyQualifiedDatasetNameTo = DatasetUtil.isFullyQualifiedName((String)datasetNameTo) ? datasetNameTo : dataverseNameTo + '.' + datasetNameTo;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockManager.INSTANCE.insertDeleteUpsertBegin(metadataProvider.getLocks(), fullyQualifiedDatasetNameTo);
        try {
            this.prepareRunExternalRuntime(metadataProvider, hcc, pregelixStmt, dataverseNameFrom, dataverseNameTo, datasetNameFrom, datasetNameTo, mdTxnCtx);
            String pregelixHomeKey = "PREGELIX_HOME";
            String pregelixHome = System.getenv(pregelixHomeKey);
            if (pregelixHome == null) {
                pregelixHome = System.getProperty(pregelixHomeKey);
            }
            if (pregelixHome == null) {
                pregelixHome = AppContextInfo.INSTANCE.getCompilerProperties().getPregelixHome();
            }
            List<String> cmd = this.constructPregelixCommand(pregelixStmt, dataverseNameFrom, datasetNameFrom, dataverseNameTo, datasetNameTo);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(new File(pregelixHome));
            pb.redirectErrorStream(true);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            int resultState = this.executeExternalShellProgram(pb);
            if (resultState != 0) {
                throw new AlgebricksException("Something went wrong executing your Pregelix Job. Perhaps the Pregelix cluster needs to be restarted. Check the following things: Are the datatypes of Asterix and Pregelix matching? Is the server configuration correct (node names, buffer sizes, framesize)? Check the logfiles for more details.");
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void prepareRunExternalRuntime(MetadataProvider metadataProvider, IHyracksClientConnection hcc, RunStatement pregelixStmt, String dataverseNameFrom, String dataverseNameTo, String datasetNameFrom, String datasetNameTo, MetadataTransactionContext mdTxnCtx) throws Exception {
        Dataset fromDataset = metadataProvider.findDataset(dataverseNameFrom, datasetNameFrom);
        if (fromDataset == null) {
            throw new CompilationException("The source dataset " + datasetNameFrom + " in dataverse " + dataverseNameFrom + " could not be found for the Run command");
        }
        Dataset toDataset = metadataProvider.findDataset(dataverseNameTo, datasetNameTo);
        if (toDataset == null) {
            throw new CompilationException("The sink dataset " + datasetNameTo + " in dataverse " + dataverseNameTo + " could not be found for the Run command");
        }
        try {
            Index toIndex = null;
            List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseNameTo, pregelixStmt.getDatasetNameTo().getValue());
            for (Index index : indexes) {
                if (!index.isPrimaryIndex()) continue;
                toIndex = index;
                break;
            }
            if (toIndex == null) {
                throw new AlgebricksException("Tried to access non-existing dataset: " + datasetNameTo);
            }
            DropDatasetStatement dropStmt = new DropDatasetStatement(new Identifier(dataverseNameTo), pregelixStmt.getDatasetNameTo(), true);
            this.handleDatasetDropStatement(metadataProvider, (Statement)dropStmt, hcc);
            InternalDetailsDecl idd = new InternalDetailsDecl(toIndex.getKeyFieldNames(), toIndex.getKeyFieldSourceIndicators(), false, null, toDataset.getDatasetDetails().isTemp());
            DatasetDecl createToDataset = new DatasetDecl(new Identifier(dataverseNameTo), pregelixStmt.getDatasetNameTo(), new Identifier(toDataset.getItemTypeDataverseName()), new Identifier(toDataset.getItemTypeName()), new Identifier(toDataset.getMetaItemTypeDataverseName()), new Identifier(toDataset.getMetaItemTypeName()), new Identifier(toDataset.getNodeGroupName()), toDataset.getCompactionPolicy(), toDataset.getCompactionPolicyProperties(), toDataset.getHints(), toDataset.getDatasetType(), (IDatasetDetailsDecl)idd, false);
            this.handleCreateDatasetStatement(metadataProvider, (Statement)createToDataset, hcc);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new AlgebricksException("Error cleaning the result dataset. This should not happen.");
        }
        FlushDatasetUtil.flushDataset(hcc, metadataProvider, dataverseNameFrom, datasetNameFrom, datasetNameFrom);
    }

    protected int executeExternalShellProgram(ProcessBuilder pb) throws IOException, AlgebricksException, InterruptedException {
        Process process = pb.start();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                LOGGER.info(line);
                if (!line.contains("Exception") && !line.contains("Error")) continue;
                LOGGER.severe(line);
                if (line.contains("Connection refused")) {
                    throw new AlgebricksException("The connection to your Pregelix cluster was refused. Is it running? Is the port in the query correct?");
                }
                if (line.contains("Could not find or load main class")) {
                    throw new AlgebricksException("The main class of your Pregelix query was not found. Is the path to your .jar file correct?");
                }
                if (!line.contains("ClassNotFoundException")) continue;
                throw new AlgebricksException("The vertex class of your Pregelix query was not found. Does it exist? Is the spelling correct?");
            }
            process.waitFor();
        }
        return process.exitValue();
    }

    protected List<String> constructPregelixCommand(RunStatement pregelixStmt, String fromDataverseName, String fromDatasetName, String toDataverseName, String toDatasetName) {
        ExternalProperties externalProperties = AppContextInfo.INSTANCE.getExternalProperties();
        String clientIP = ClusterProperties.INSTANCE.getCluster().getMasterNode().getClientIp();
        StringBuilder asterixdbParameterBuilder = new StringBuilder();
        asterixdbParameterBuilder.append("pregelix.asterixdb.url=http://" + clientIP + ":" + externalProperties.getAPIServerPort() + ",");
        asterixdbParameterBuilder.append("pregelix.asterixdb.source=true,");
        asterixdbParameterBuilder.append("pregelix.asterixdb.sink=true,");
        asterixdbParameterBuilder.append("pregelix.asterixdb.input.dataverse=" + fromDataverseName + ",");
        asterixdbParameterBuilder.append("pregelix.asterixdb.input.dataset=" + fromDatasetName + ",");
        asterixdbParameterBuilder.append("pregelix.asterixdb.output.dataverse=" + toDataverseName + ",");
        asterixdbParameterBuilder.append("pregelix.asterixdb.output.dataset=" + toDatasetName + ",");
        asterixdbParameterBuilder.append("pregelix.asterixdb.output.cleanup=false,");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("bin/pregelix");
        cmds.add((String)pregelixStmt.getParameters().get(0));
        cmds.add((String)pregelixStmt.getParameters().get(1));
        String customizedPregelixProperty = "-cust-prop";
        String inputConverterClassKey = "pregelix.asterixdb.input.converterclass";
        String inputConverterClassValue = "=org.apache.pregelix.example.converter.VLongIdInputVertexConverter,";
        String outputConverterClassKey = "pregelix.asterixdb.output.converterclass";
        String outputConverterClassValue = "=org.apache.pregelix.example.converter.VLongIdOutputVertexConverter,";
        boolean custPropAdded = false;
        boolean meetCustProp = false;
        for (String s : ((String)pregelixStmt.getParameters().get(2)).split(" ")) {
            if (meetCustProp) {
                if (!s.contains(inputConverterClassKey)) {
                    asterixdbParameterBuilder.append(inputConverterClassKey + inputConverterClassValue);
                }
                if (!s.contains(outputConverterClassKey)) {
                    asterixdbParameterBuilder.append(outputConverterClassKey + outputConverterClassValue);
                }
                cmds.add(asterixdbParameterBuilder.toString() + s);
                meetCustProp = false;
                custPropAdded = true;
                continue;
            }
            cmds.add(s);
            if (!s.equals(customizedPregelixProperty)) continue;
            meetCustProp = true;
        }
        if (!custPropAdded) {
            cmds.add(customizedPregelixProperty);
            asterixdbParameterBuilder.append(inputConverterClassKey + inputConverterClassValue);
            asterixdbParameterBuilder.append(outputConverterClassKey + outputConverterClassValue);
            asterixdbParameterBuilder.delete(asterixdbParameterBuilder.length() - 1, asterixdbParameterBuilder.length());
            cmds.add(asterixdbParameterBuilder.toString());
        }
        return cmds;
    }

    public String getActiveDataverseName(String dataverse) {
        return dataverse != null ? dataverse : this.activeDataverse.getDataverseName();
    }

    public String getActiveDataverse(Identifier dataverse) {
        return this.getActiveDataverseName(dataverse != null ? dataverse.getValue() : null);
    }

    public static void abort(Exception rootE, Exception parentE, MetadataTransactionContext mdTxnCtx) {
        try {
            if (mdTxnCtx != null) {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
        }
        catch (Exception e2) {
            parentE.addSuppressed(e2);
            throw new IllegalStateException(rootE);
        }
    }

    protected void rewriteStatement(Statement stmt) throws CompilationException {
        IStatementRewriter rewriter = this.rewriterFactory.createStatementRewriter();
        rewriter.rewrite(stmt);
    }

    private static interface IStatementCompiler {
        public JobSpecification compile() throws AlgebricksException, RemoteException, ACIDException;
    }

    private static interface IResultPrinter {
        public void print(JobId var1) throws HyracksDataException, AlgebricksException;
    }

    private static interface IMetadataLocker {
        public void lock();

        public void unlock();
    }
}

