/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;

public class StartupTaskResponseMessage
implements INCLifecycleMessage {
    private static final Logger LOGGER = Logger.getLogger(StartupTaskResponseMessage.class.getName());
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final List<INCLifecycleTask> tasks;

    public StartupTaskResponseMessage(String nodeId, List<INCLifecycleTask> tasks) {
        this.nodeId = nodeId;
        this.tasks = tasks;
    }

    public void handle(IControllerService cs) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)cs.getContext().getMessageBroker();
        boolean success = true;
        HyracksDataException exception = null;
        try {
            for (INCLifecycleTask task : this.tasks) {
                task.perform(cs);
            }
        }
        catch (HyracksDataException e) {
            success = false;
            exception = e;
        }
        NCLifecycleTaskReportMessage result = new NCLifecycleTaskReportMessage(this.nodeId, success);
        result.setException((Exception)((Object)exception));
        try {
            broker.sendMessageToCC((IApplicationMessage)result);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed sending message to cc", e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.STARTUP_TASK_RESPONSE;
    }
}

