/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.app.replication.message.CompleteFailbackRequestMessage;
import org.apache.asterix.app.replication.message.PreparePartitionsFailbackRequestMessage;

public class NodeFailbackPlan {
    private static long planIdGenerator = 0L;
    private long planId;
    private final String nodeId;
    private final Set<String> participants;
    private final Map<Integer, String> partition2nodeMap;
    private String nodeToReleaseMetadataManager;
    private int requestId;
    private Map<Integer, PreparePartitionsFailbackRequestMessage> pendingRequests;
    private FailbackPlanState state;

    public static NodeFailbackPlan createPlan(String nodeId) {
        return new NodeFailbackPlan(planIdGenerator++, nodeId);
    }

    private NodeFailbackPlan(long planId, String nodeId) {
        this.planId = planId;
        this.nodeId = nodeId;
        this.participants = new HashSet<String>();
        this.partition2nodeMap = new HashMap<Integer, String>();
        this.pendingRequests = new HashMap<Integer, PreparePartitionsFailbackRequestMessage>();
        this.state = FailbackPlanState.PREPARING;
    }

    public synchronized void addPartitionToFailback(int partitionId, String currentActiveNode) {
        this.partition2nodeMap.put(partitionId, currentActiveNode);
    }

    public synchronized void addParticipant(String nodeId) {
        this.participants.add(nodeId);
    }

    public synchronized void notifyNodeFailure(String failedNode) {
        if (this.participants.contains(failedNode)) {
            if (this.state == FailbackPlanState.PREPARING) {
                this.state = FailbackPlanState.FAILED;
            } else if (this.state == FailbackPlanState.PENDING_PARTICIPANT_REPONSE) {
                HashSet<Integer> failedRequests = new HashSet<Integer>();
                for (PreparePartitionsFailbackRequestMessage request : this.pendingRequests.values()) {
                    if (!request.getNodeID().equals(failedNode)) continue;
                    failedRequests.add(request.getRequestId());
                }
                if (!failedRequests.isEmpty()) {
                    this.state = FailbackPlanState.FAILED;
                    for (Integer failedRequestId : failedRequests) {
                        this.markRequestCompleted(failedRequestId);
                    }
                }
            }
        } else if (this.nodeId.equals(failedNode)) {
            this.state = FailbackPlanState.FAILED;
            this.updateState();
        }
    }

    public synchronized Set<Integer> getPartitionsToFailback() {
        return new HashSet<Integer>(this.partition2nodeMap.keySet());
    }

    public synchronized void addPendingRequest(PreparePartitionsFailbackRequestMessage msg) {
        if (this.pendingRequests.size() == 0) {
            this.state = FailbackPlanState.PENDING_PARTICIPANT_REPONSE;
        }
        this.pendingRequests.put(msg.getRequestId(), msg);
    }

    public synchronized void markRequestCompleted(int requestId) {
        this.pendingRequests.remove(requestId);
        this.updateState();
    }

    private void updateState() {
        if (this.pendingRequests.size() == 0) {
            switch (this.state) {
                case PREPARING: 
                case FAILED: {
                    this.state = FailbackPlanState.PENDING_ROLLBACK;
                    break;
                }
                case PENDING_PARTICIPANT_REPONSE: {
                    this.state = FailbackPlanState.PENDING_COMPLETION;
                    break;
                }
            }
        }
    }

    public synchronized Set<PreparePartitionsFailbackRequestMessage> getPlanFailbackRequests() {
        HashSet<PreparePartitionsFailbackRequestMessage> node2Partitions = new HashSet<PreparePartitionsFailbackRequestMessage>();
        for (String participant : this.participants) {
            HashSet<Integer> partitionToPrepareForFailback = new HashSet<Integer>();
            for (Map.Entry<Integer, String> entry : this.partition2nodeMap.entrySet()) {
                if (!entry.getValue().equals(participant)) continue;
                partitionToPrepareForFailback.add(entry.getKey());
            }
            PreparePartitionsFailbackRequestMessage msg = new PreparePartitionsFailbackRequestMessage(this.planId, this.requestId++, participant, partitionToPrepareForFailback);
            if (participant.equals(this.nodeToReleaseMetadataManager)) {
                msg.setReleaseMetadataNode(true);
            }
            node2Partitions.add(msg);
        }
        return node2Partitions;
    }

    public synchronized CompleteFailbackRequestMessage getCompleteFailbackRequestMessage() {
        return new CompleteFailbackRequestMessage(this.planId, this.requestId++, this.nodeId, this.getPartitionsToFailback());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getPlanId() {
        return this.planId;
    }

    public void setNodeToReleaseMetadataManager(String nodeToReleaseMetadataManager) {
        this.nodeToReleaseMetadataManager = nodeToReleaseMetadataManager;
    }

    public synchronized FailbackPlanState getState() {
        return this.state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Plan ID: " + this.planId);
        sb.append(" Failing back node: " + this.nodeId);
        sb.append(" Participants: " + this.participants);
        sb.append(" Partitions to Failback: " + this.partition2nodeMap.keySet());
        return sb.toString();
    }

    public static enum FailbackPlanState {
        PREPARING,
        PENDING_PARTICIPANT_REPONSE,
        PENDING_COMPLETION,
        FAILED,
        PENDING_ROLLBACK;

    }
}

