/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.asterix.app.nc.task.BindMetadataNodeTask;
import org.apache.asterix.app.nc.task.CheckpointTask;
import org.apache.asterix.app.nc.task.ExternalLibrarySetupTask;
import org.apache.asterix.app.nc.task.LocalRecoveryTask;
import org.apache.asterix.app.nc.task.MetadataBootstrapTask;
import org.apache.asterix.app.nc.task.RemoteRecoveryTask;
import org.apache.asterix.app.nc.task.ReportMaxResourceIdTask;
import org.apache.asterix.app.nc.task.StartLifecycleComponentsTask;
import org.apache.asterix.app.nc.task.StartReplicationServiceTask;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.app.replication.message.ReplayPartitionLogsRequestMessage;
import org.apache.asterix.app.replication.message.ReplayPartitionLogsResponseMessage;
import org.apache.asterix.app.replication.message.StartupTaskRequestMessage;
import org.apache.asterix.app.replication.message.StartupTaskResponseMessage;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.util.FaultToleranceUtil;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MetadataNodeFaultToleranceStrategy
implements IFaultToleranceStrategy {
    private static final Logger LOGGER = Logger.getLogger(MetadataNodeFaultToleranceStrategy.class.getName());
    private IClusterStateManager clusterManager;
    private String metadataNodeId;
    private IReplicationStrategy replicationStrategy;
    private ICCMessageBroker messageBroker;
    private final Set<String> hotStandbyMetadataReplica = new HashSet<String>();
    private final Set<String> failedNodes = new HashSet<String>();
    private Set<String> pendingStartupCompletionNodes = new HashSet<String>();

    public synchronized void notifyNodeJoin(String nodeId) throws HyracksDataException {
        this.pendingStartupCompletionNodes.add(nodeId);
    }

    public synchronized void notifyNodeFailure(String nodeId) throws HyracksDataException {
        this.failedNodes.add(nodeId);
        this.hotStandbyMetadataReplica.remove(nodeId);
        this.clusterManager.updateNodePartitions(nodeId, false);
        if (nodeId.equals(this.metadataNodeId)) {
            this.clusterManager.updateMetadataNode(this.metadataNodeId, false);
        }
        this.clusterManager.refreshState();
        if (this.replicationStrategy.isParticipant(nodeId)) {
            FaultToleranceUtil.notifyImpactedReplicas(nodeId, IClusterLifecycleListener.ClusterEventType.NODE_FAILURE, this.clusterManager, this.messageBroker, this.replicationStrategy);
        }
        if (nodeId.equals(this.metadataNodeId)) {
            int metadataPartitionId = AppContextInfo.INSTANCE.getMetadataProperties().getMetadataPartition().getPartitionId();
            HashSet<Integer> metadataPartition = new HashSet<Integer>(Arrays.asList(metadataPartitionId));
            Set activeRemoteReplicas = this.replicationStrategy.getRemoteReplicas(this.metadataNodeId).stream().filter(replica -> !this.failedNodes.contains(replica.getId())).collect(Collectors.toSet());
            for (Replica replica2 : activeRemoteReplicas) {
                ReplayPartitionLogsRequestMessage msg = new ReplayPartitionLogsRequestMessage(metadataPartition);
                try {
                    this.messageBroker.sendApplicationMessageToNC((IApplicationMessage)msg, replica2.getId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed sending an application message to an NC", e);
                }
            }
        }
    }

    public IFaultToleranceStrategy from(IReplicationStrategy replicationStrategy, ICCMessageBroker messageBroker) {
        MetadataNodeFaultToleranceStrategy ft = new MetadataNodeFaultToleranceStrategy();
        ft.replicationStrategy = replicationStrategy;
        ft.messageBroker = messageBroker;
        return ft;
    }

    public synchronized void process(INCLifecycleMessage message) throws HyracksDataException {
        switch (message.getType()) {
            case STARTUP_TASK_REQUEST: {
                this.process((StartupTaskRequestMessage)message);
                break;
            }
            case STARTUP_TASK_RESULT: {
                this.process((NCLifecycleTaskReportMessage)message);
                break;
            }
            case REPLAY_LOGS_RESPONSE: {
                this.process((ReplayPartitionLogsResponseMessage)message);
                break;
            }
            default: {
                throw new RuntimeDataException(4003, new Serializable[]{message.getType().name()});
            }
        }
    }

    public synchronized void bindTo(IClusterStateManager clusterManager) {
        this.clusterManager = clusterManager;
        this.metadataNodeId = clusterManager.getCurrentMetadataNodeId();
    }

    private synchronized void process(ReplayPartitionLogsResponseMessage msg) {
        this.hotStandbyMetadataReplica.add(msg.getNodeId());
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Hot Standby Metadata Replicas: " + this.hotStandbyMetadataReplica);
        }
    }

    private synchronized void process(StartupTaskRequestMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        IRecoveryManager.SystemState state = msg.getState();
        boolean isParticipant = this.replicationStrategy.isParticipant(nodeId);
        List<INCLifecycleTask> tasks = !isParticipant ? this.buildNonParticipantStartupSequence(nodeId, state) : this.buildParticipantStartupSequence(nodeId, state);
        StartupTaskResponseMessage response = new StartupTaskResponseMessage(nodeId, tasks);
        try {
            this.messageBroker.sendApplicationMessageToNC((IApplicationMessage)response, msg.getNodeId());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private synchronized void process(NCLifecycleTaskReportMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        this.pendingStartupCompletionNodes.remove(nodeId);
        if (msg.isSuccess()) {
            if (this.replicationStrategy.isParticipant(nodeId) && this.failedNodes.remove(nodeId)) {
                FaultToleranceUtil.notifyImpactedReplicas(nodeId, IClusterLifecycleListener.ClusterEventType.NODE_JOIN, this.clusterManager, this.messageBroker, this.replicationStrategy);
            }
            this.clusterManager.updateNodePartitions(msg.getNodeId(), true);
            if (msg.getNodeId().equals(this.metadataNodeId)) {
                this.clusterManager.updateMetadataNode(this.metadataNodeId, true);
                this.hotStandbyMetadataReplica.clear();
                this.hotStandbyMetadataReplica.add(this.metadataNodeId);
            }
            this.clusterManager.refreshState();
        } else {
            LOGGER.log(Level.SEVERE, msg.getNodeId() + " failed to complete startup. ", msg.getException());
        }
    }

    private List<INCLifecycleTask> buildNonParticipantStartupSequence(String nodeId, IRecoveryManager.SystemState state) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        if (state == IRecoveryManager.SystemState.CORRUPTED) {
            LocalRecoveryTask rt = new LocalRecoveryTask(Arrays.asList(this.clusterManager.getNodePartitions(nodeId)).stream().map(ClusterPartition::getPartitionId).collect(Collectors.toSet()));
            tasks.add(rt);
        }
        tasks.add(new ExternalLibrarySetupTask(false));
        tasks.add(new ReportMaxResourceIdTask());
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        return tasks;
    }

    private List<INCLifecycleTask> buildParticipantStartupSequence(String nodeId, IRecoveryManager.SystemState state) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        switch (state) {
            case PERMANENT_DATA_LOSS: {
                tasks.add(this.getMetadataPartitionRecoveryPlan());
                tasks.add(new CheckpointTask());
                break;
            }
            case CORRUPTED: {
                LocalRecoveryTask rt = new LocalRecoveryTask(Arrays.asList(this.clusterManager.getNodePartitions(nodeId)).stream().map(ClusterPartition::getPartitionId).collect(Collectors.toSet()));
                tasks.add(rt);
                break;
            }
            case BOOTSTRAPPING: 
            case HEALTHY: 
            case RECOVERING: {
                break;
            }
        }
        tasks.add(new StartReplicationServiceTask());
        boolean isMetadataNode = nodeId.equals(this.metadataNodeId);
        if (isMetadataNode) {
            tasks.add(new MetadataBootstrapTask());
        }
        tasks.add(new ExternalLibrarySetupTask(isMetadataNode));
        tasks.add(new ReportMaxResourceIdTask());
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        if (isMetadataNode) {
            tasks.add(new BindMetadataNodeTask(true));
        }
        return tasks;
    }

    private RemoteRecoveryTask getMetadataPartitionRecoveryPlan() {
        if (this.hotStandbyMetadataReplica.isEmpty()) {
            throw new IllegalStateException("No metadata replicas to recover from");
        }
        HashMap<String, Set<Integer>> recoveryPlan = new HashMap<String, Set<Integer>>();
        int metadataPartitionId = AppContextInfo.INSTANCE.getMetadataProperties().getMetadataPartition().getPartitionId();
        HashSet<Integer> metadataPartition = new HashSet<Integer>(Arrays.asList(metadataPartitionId));
        recoveryPlan.put(this.hotStandbyMetadataReplica.iterator().next(), metadataPartition);
        return new RemoteRecoveryTask(recoveryPlan);
    }
}

