/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.api.common.AppRuntimeContextProviderForRecovery;
import org.apache.asterix.app.nc.NCExtensionManager;
import org.apache.asterix.app.nc.TransactionSubsystem;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.ThreadExecutor;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.BuildProperties;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.ExtensionProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.context.DatasetLifecycleManager;
import org.apache.asterix.common.context.FileMapManager;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.replication.IRemoteRecoveryManager;
import org.apache.asterix.common.replication.IReplicaResourcesManager;
import org.apache.asterix.common.replication.IReplicationChannel;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.IAppRuntimeContextProvider;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.external.library.ExternalLibraryManager;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataBootstrap;
import org.apache.asterix.replication.management.ReplicationChannel;
import org.apache.asterix.replication.management.ReplicationManager;
import org.apache.asterix.replication.recovery.RemoteRecoveryManager;
import org.apache.asterix.replication.storage.ReplicaResourcesManager;
import org.apache.asterix.runtime.transaction.GlobalResourceIdFactoryProvider;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepositoryFactory;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.AsynchronousScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicyFactory;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.ClockPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.DelayPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.HeapBufferAllocator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;

public class NCAppRuntimeContext
implements IAppRuntimeContext {
    private static final Logger LOGGER = Logger.getLogger(NCAppRuntimeContext.class.getName());
    private ILSMMergePolicyFactory metadataMergePolicyFactory;
    private final INCServiceContext ncServiceContext;
    private final IResourceIdFactory resourceIdFactory;
    private CompilerProperties compilerProperties;
    private ExternalProperties externalProperties;
    private MetadataProperties metadataProperties;
    private StorageProperties storageProperties;
    private TransactionProperties txnProperties;
    private ActiveProperties activeProperties;
    private BuildProperties buildProperties;
    private ReplicationProperties replicationProperties;
    private MessagingProperties messagingProperties;
    private final NodeProperties nodeProperties;
    private ThreadExecutor threadExecutor;
    private IDatasetLifecycleManager datasetLifecycleManager;
    private IFileMapManager fileMapManager;
    private IBufferCache bufferCache;
    private ITransactionSubsystem txnSubsystem;
    private ILSMIOOperationScheduler lsmIOScheduler;
    private PersistentLocalResourceRepository localResourceRepository;
    private IIOManager ioManager;
    private boolean isShuttingdown;
    private ActiveManager activeManager;
    private IReplicationChannel replicationChannel;
    private IReplicationManager replicationManager;
    private IRemoteRecoveryManager remoteRecoveryManager;
    private IReplicaResourcesManager replicaResourcesManager;
    private final ILibraryManager libraryManager;
    private final NCExtensionManager ncExtensionManager;
    private final IStorageComponentProvider componentProvider;

    public NCAppRuntimeContext(INCServiceContext ncServiceContext, List<AsterixExtension> extensions) throws AsterixException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        ArrayList<AsterixExtension> allExtensions = new ArrayList<AsterixExtension>();
        this.ncServiceContext = ncServiceContext;
        PropertiesAccessor propertiesAccessor = PropertiesAccessor.getInstance((IApplicationConfig)ncServiceContext.getAppConfig());
        this.compilerProperties = new CompilerProperties(propertiesAccessor);
        this.externalProperties = new ExternalProperties(propertiesAccessor);
        this.metadataProperties = new MetadataProperties(propertiesAccessor);
        this.storageProperties = new StorageProperties(propertiesAccessor);
        this.txnProperties = new TransactionProperties(propertiesAccessor);
        this.activeProperties = new ActiveProperties(propertiesAccessor);
        this.buildProperties = new BuildProperties(propertiesAccessor);
        this.replicationProperties = new ReplicationProperties(propertiesAccessor);
        this.messagingProperties = new MessagingProperties(propertiesAccessor);
        this.nodeProperties = new NodeProperties(propertiesAccessor);
        this.libraryManager = new ExternalLibraryManager();
        if (extensions != null) {
            allExtensions.addAll(extensions);
        }
        allExtensions.addAll(new ExtensionProperties(propertiesAccessor).getExtensions());
        this.ncExtensionManager = new NCExtensionManager(allExtensions);
        this.componentProvider = new StorageComponentProvider();
        this.resourceIdFactory = new GlobalResourceIdFactoryProvider(ncServiceContext).createResourceIdFactory();
    }

    public void initialize(boolean initialRun) throws IOException, ACIDException {
        this.ioManager = this.ncServiceContext.getIoManager();
        this.threadExecutor = new ThreadExecutor(this.ncServiceContext.getThreadFactory());
        this.fileMapManager = new FileMapManager(this.ioManager);
        HeapBufferAllocator allocator = new HeapBufferAllocator();
        DelayPageCleanerPolicy pcp = new DelayPageCleanerPolicy(600000L);
        ClockPageReplacementStrategy prs = new ClockPageReplacementStrategy((ICacheMemoryAllocator)allocator, this.storageProperties.getBufferCachePageSize(), this.storageProperties.getBufferCacheNumPages());
        AsynchronousScheduler.INSTANCE.init(this.ncServiceContext.getThreadFactory());
        this.lsmIOScheduler = AsynchronousScheduler.INSTANCE;
        this.metadataMergePolicyFactory = new PrefixMergePolicyFactory();
        PersistentLocalResourceRepositoryFactory persistentLocalResourceRepositoryFactory = new PersistentLocalResourceRepositoryFactory(this.ioManager, this.ncServiceContext.getNodeId(), this.metadataProperties);
        this.localResourceRepository = (PersistentLocalResourceRepository)persistentLocalResourceRepositoryFactory.createRepository();
        AppRuntimeContextProviderForRecovery asterixAppRuntimeContextProvider = new AppRuntimeContextProviderForRecovery(this);
        this.txnSubsystem = new TransactionSubsystem(this.ncServiceContext, this.ncServiceContext.getNodeId(), asterixAppRuntimeContextProvider, this.txnProperties);
        IRecoveryManager recoveryMgr = this.txnSubsystem.getRecoveryManager();
        IRecoveryManager.SystemState systemState = recoveryMgr.getSystemState();
        if (initialRun || systemState == IRecoveryManager.SystemState.PERMANENT_DATA_LOSS) {
            this.localResourceRepository.deleteStorageData(true);
        }
        this.datasetLifecycleManager = new DatasetLifecycleManager(this.storageProperties, (ILocalResourceRepository)this.localResourceRepository, 100, this.txnSubsystem.getLogManager(), this.ioManager.getIODevices().size());
        this.isShuttingdown = false;
        this.activeManager = new ActiveManager(this.threadExecutor, this.ncServiceContext.getNodeId(), this.activeProperties.getMemoryComponentGlobalBudget(), this.compilerProperties.getFrameSize());
        if (this.replicationProperties.isParticipant(this.ncServiceContext.getNodeId())) {
            String nodeId = this.ncServiceContext.getNodeId();
            this.replicaResourcesManager = new ReplicaResourcesManager((ILocalResourceRepository)this.localResourceRepository, this.metadataProperties);
            this.replicationManager = new ReplicationManager(nodeId, this.replicationProperties, this.replicaResourcesManager, this.txnSubsystem.getLogManager(), (IAppRuntimeContextProvider)asterixAppRuntimeContextProvider);
            this.txnSubsystem.getLogManager().setReplicationManager(this.replicationManager);
            this.localResourceRepository.setReplicationManager(this.replicationManager);
            Set remotePrimaryReplicas = this.replicationProperties.getRemotePrimaryReplicasIds(nodeId);
            for (String clientId : remotePrimaryReplicas) {
                ClusterPartition[] clientPartitions;
                for (ClusterPartition partition : clientPartitions = (ClusterPartition[])this.metadataProperties.getNodePartitions().get(clientId)) {
                    this.localResourceRepository.addInactivePartition(partition.getPartitionId());
                }
            }
            this.replicationChannel = new ReplicationChannel(nodeId, this.replicationProperties, this.txnSubsystem.getLogManager(), this.replicaResourcesManager, this.replicationManager, this.ncServiceContext, (IAppRuntimeContextProvider)asterixAppRuntimeContextProvider);
            this.remoteRecoveryManager = new RemoteRecoveryManager(this.replicationManager, (IAppRuntimeContext)this, this.replicationProperties);
            this.bufferCache = new BufferCache(this.ioManager, (IPageReplacementStrategy)prs, (IPageCleanerPolicy)pcp, this.fileMapManager, this.storageProperties.getBufferCacheMaxOpenFiles(), this.ncServiceContext.getThreadFactory(), (IIOReplicationManager)this.replicationManager);
        } else {
            this.bufferCache = new BufferCache(this.ioManager, (IPageReplacementStrategy)prs, (IPageCleanerPolicy)pcp, this.fileMapManager, this.storageProperties.getBufferCacheMaxOpenFiles(), this.ncServiceContext.getThreadFactory());
        }
        ILifeCycleComponentManager lccm = this.ncServiceContext.getLifeCycleComponentManager();
        lccm.register((ILifeCycleComponent)this.bufferCache);
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getLogManager());
        if (this.replicationManager != null) {
            lccm.register((ILifeCycleComponent)this.replicationManager);
        }
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getRecoveryManager());
        lccm.register((ILifeCycleComponent)this.datasetLifecycleManager);
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getTransactionManager());
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getLockManager());
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getCheckpointManager());
    }

    public boolean isShuttingdown() {
        return this.isShuttingdown;
    }

    public void setShuttingdown(boolean isShuttingdown) {
        this.isShuttingdown = isShuttingdown;
    }

    public void preStop() throws Exception {
        this.activeManager.shutdown();
    }

    public void deinitialize() throws HyracksDataException {
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    public IFileMapProvider getFileMapManager() {
        return this.fileMapManager;
    }

    public ITransactionSubsystem getTransactionSubsystem() {
        return this.txnSubsystem;
    }

    public IDatasetLifecycleManager getDatasetLifecycleManager() {
        return this.datasetLifecycleManager;
    }

    public double getBloomFilterFalsePositiveRate() {
        return this.storageProperties.getBloomFilterFalsePositiveRate();
    }

    public ILSMIOOperationScheduler getLSMIOScheduler() {
        return this.lsmIOScheduler;
    }

    public ILocalResourceRepository getLocalResourceRepository() {
        return this.localResourceRepository;
    }

    public IResourceIdFactory getResourceIdFactory() {
        return this.resourceIdFactory;
    }

    public IIOManager getIOManager() {
        return this.ioManager;
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public CompilerProperties getCompilerProperties() {
        return this.compilerProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public ExternalProperties getExternalProperties() {
        return this.externalProperties;
    }

    public ActiveProperties getActiveProperties() {
        return this.activeProperties;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public MessagingProperties getMessagingProperties() {
        return this.messagingProperties;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public ILSMOperationTracker getLSMBTreeOperationTracker(int datasetID) {
        return this.datasetLifecycleManager.getOperationTracker(datasetID);
    }

    public ThreadExecutor getThreadExecutor() {
        return this.threadExecutor;
    }

    public ILSMMergePolicyFactory getMetadataMergePolicyFactory() {
        return this.metadataMergePolicyFactory;
    }

    public ActiveManager getActiveManager() {
        return this.activeManager;
    }

    public ReplicationProperties getReplicationProperties() {
        return this.replicationProperties;
    }

    public IReplicationChannel getReplicationChannel() {
        return this.replicationChannel;
    }

    public IReplicaResourcesManager getReplicaResourcesManager() {
        return this.replicaResourcesManager;
    }

    public IRemoteRecoveryManager getRemoteRecoveryManager() {
        return this.remoteRecoveryManager;
    }

    public IReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public void initializeMetadata(boolean newUniverse) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bootstrapping metadata");
        }
        MetadataNode.INSTANCE.initialize((IAppRuntimeContext)this, this.ncExtensionManager.getMetadataTupleTranslatorProvider(), this.ncExtensionManager.getMetadataExtensions());
        IAsterixStateProxy proxy = (IAsterixStateProxy)this.ncServiceContext.getDistributedState();
        if (proxy == null) {
            throw new IllegalStateException("Metadata node cannot access distributed state");
        }
        MetadataManager.initialize((IAsterixStateProxy)proxy, (MetadataNode)MetadataNode.INSTANCE);
        MetadataBootstrap.startUniverse((INCServiceContext)this.ncServiceContext, (boolean)newUniverse);
        MetadataBootstrap.startDDLRecovery();
        this.ncExtensionManager.initializeMetadata(this.ncServiceContext);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Metadata node bound");
        }
    }

    public void exportMetadataNodeStub() throws RemoteException {
        IMetadataNode stub = (IMetadataNode)UnicastRemoteObject.exportObject((Remote)MetadataNode.INSTANCE, this.getMetadataProperties().getMetadataPort());
        ((IAsterixStateProxy)this.ncServiceContext.getDistributedState()).setMetadataNode(stub);
    }

    public void unexportMetadataNodeStub() throws RemoteException {
        UnicastRemoteObject.unexportObject((Remote)MetadataNode.INSTANCE, false);
    }

    public NCExtensionManager getNcExtensionManager() {
        return this.ncExtensionManager;
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.componentProvider;
    }
}

