/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.external;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.app.external.ExternalLibraryClassLoader;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.library.ExternalLibrary;
import org.apache.asterix.external.library.LibraryAdapter;
import org.apache.asterix.external.library.LibraryFunction;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Library;

public class ExternalLibraryUtils {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibraryUtils.class.getName());

    private ExternalLibraryUtils() {
    }

    public static void setUpExternaLibraries(ILibraryManager externalLibraryManager, boolean isMetadataNode) throws Exception {
        File installLibDir;
        Map<String, List<String>> uninstalledLibs = null;
        if (isMetadataNode) {
            uninstalledLibs = ExternalLibraryUtils.uninstallLibraries();
        }
        if ((installLibDir = ExternalLibraryUtils.getLibraryInstallDir()).exists()) {
            for (String dataverse : installLibDir.list()) {
                String[] libraries;
                File dataverseDir = new File(installLibDir, dataverse);
                for (String library : libraries = dataverseDir.list()) {
                    ExternalLibraryUtils.registerLibrary(externalLibraryManager, dataverse, library);
                    if (!isMetadataNode) continue;
                    File libraryDir = new File(installLibDir.getAbsolutePath() + File.separator + dataverse + File.separator + library);
                    ExternalLibraryUtils.installLibraryIfNeeded(dataverse, libraryDir, uninstalledLibs);
                }
            }
        }
    }

    private static Map<String, List<String>> uninstallLibraries() throws Exception {
        HashMap<String, List<String>> uninstalledLibs = new HashMap<String, List<String>>();
        File uninstallLibDir = ExternalLibraryUtils.getLibraryUninstallDir();
        if (uninstallLibDir.exists()) {
            String[] uninstallLibNames;
            for (String uninstallLibName : uninstallLibNames = uninstallLibDir.list()) {
                String[] components = uninstallLibName.split("\\.");
                String dataverse = components[0];
                String libName = components[1];
                ExternalLibraryUtils.uninstallLibrary(dataverse, libName);
                new File(uninstallLibDir, uninstallLibName).delete();
                ArrayList<String> uinstalledLibsInDv = (ArrayList<String>)uninstalledLibs.get(dataverse);
                if (uinstalledLibsInDv == null) {
                    uinstalledLibsInDv = new ArrayList<String>();
                    uninstalledLibs.put(dataverse, uinstalledLibsInDv);
                }
                uinstalledLibsInDv.add(libName);
            }
        }
        return uninstalledLibs;
    }

    protected static boolean uninstallLibrary(String dataverse, String libraryName) throws AsterixException, RemoteException, ACIDException {
        MetadataTransactionContext mdTxnCtx = null;
        try {
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse);
            if (dv == null) {
                return false;
            }
            Library library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, dataverse, libraryName);
            if (library == null) {
                return false;
            }
            List functions = MetadataManager.INSTANCE.getDataverseFunctions(mdTxnCtx, dataverse);
            for (Function function : functions) {
                if (!function.getName().startsWith(libraryName + "#")) continue;
                MetadataManager.INSTANCE.dropFunction(mdTxnCtx, new FunctionSignature(dataverse, function.getName(), function.getArity()));
            }
            List adapters = MetadataManager.INSTANCE.getDataverseAdapters(mdTxnCtx, dataverse);
            for (DatasourceAdapter adapter : adapters) {
                if (!adapter.getAdapterIdentifier().getName().startsWith(libraryName + "#")) continue;
                MetadataManager.INSTANCE.dropAdapter(mdTxnCtx, dataverse, adapter.getAdapterIdentifier().getName());
            }
            MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, dataverse, libraryName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            throw new AsterixException((Throwable)e);
        }
        return true;
    }

    protected static void installLibraryIfNeeded(String dataverse, File libraryDir, Map<String, List<String>> uninstalledLibs) throws Exception {
        String libraryName = libraryDir.getName().trim();
        List<String> uninstalledLibsInDv = uninstalledLibs.get(dataverse);
        boolean wasUninstalled = uninstalledLibsInDv != null && uninstalledLibsInDv.contains(libraryName);
        MetadataTransactionContext mdTxnCtx = null;
        try {
            String[] libraryDescriptors;
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            Library libraryInMetadata = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, dataverse, libraryName);
            if (libraryInMetadata != null && !wasUninstalled) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            MetadataManager.INSTANCE.addLibrary(mdTxnCtx, new Library(dataverse, libraryName));
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Added library " + libraryName + " to Metadata");
            }
            if ((libraryDescriptors = libraryDir.list((dir, name) -> name.endsWith(".xml"))) == null) {
                throw new IOException("Unable to list files in directory " + libraryDir);
            }
            if (libraryDescriptors.length == 0) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            if (libraryDescriptors.length > 1) {
                throw new IllegalStateException("More than 1 library descriptors defined");
            }
            ExternalLibrary library = ExternalLibraryUtils.getLibrary(new File(libraryDir + File.separator + libraryDescriptors[0]));
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse);
            if (dv == null) {
                MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(dataverse, "org.apache.asterix.runtime.formats.NonTaggedDataFormat", 0));
            }
            if (library.getLibraryFunctions() != null) {
                for (LibraryFunction function : library.getLibraryFunctions().getLibraryFunction()) {
                    String[] fargs = function.getArguments().trim().split(",");
                    ArrayList<String> args = new ArrayList<String>();
                    for (String arg : fargs) {
                        args.add(arg);
                    }
                    Function f = new Function(dataverse, libraryName + "#" + function.getName().trim(), args.size(), args, function.getReturnType().trim(), function.getDefinition().trim(), library.getLanguage().trim(), function.getFunctionType().trim());
                    MetadataManager.INSTANCE.addFunction(mdTxnCtx, f);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Installed function: " + libraryName + "#" + function.getName().trim());
                }
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Installed functions in library :" + libraryName);
            }
            if (library.getLibraryAdapters() != null) {
                for (LibraryAdapter adapter : library.getLibraryAdapters().getLibraryAdapter()) {
                    String adapterFactoryClass = adapter.getFactoryClass().trim();
                    String adapterName = libraryName + "#" + adapter.getName().trim();
                    AdapterIdentifier aid = new AdapterIdentifier(dataverse, adapterName);
                    DatasourceAdapter dsa = new DatasourceAdapter(aid, adapterFactoryClass, IDataSourceAdapter.AdapterType.EXTERNAL);
                    MetadataManager.INSTANCE.addAdapter(mdTxnCtx, dsa);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Installed adapter: " + adapterName);
                }
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Installed adapters in library :" + libraryName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Exception in installing library " + libraryName, e);
            }
            MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
        }
    }

    protected static void registerLibrary(ILibraryManager externalLibraryManager, String dataverse, String libraryName) throws Exception {
        ClassLoader classLoader = ExternalLibraryUtils.getLibraryClassLoader(dataverse, libraryName);
        externalLibraryManager.registerLibraryClassLoader(dataverse, libraryName, classLoader);
    }

    private static ExternalLibrary getLibrary(File libraryXMLPath) throws Exception {
        JAXBContext configCtx = JAXBContext.newInstance((Class[])new Class[]{ExternalLibrary.class});
        Unmarshaller unmarshaller = configCtx.createUnmarshaller();
        ExternalLibrary library = (ExternalLibrary)unmarshaller.unmarshal(libraryXMLPath);
        return library;
    }

    private static ClassLoader getLibraryClassLoader(String dataverse, String libraryName) throws Exception {
        FilenameFilter jarFileFilter;
        File libDir;
        String[] jarsInLibDir;
        File installDir = ExternalLibraryUtils.getLibraryInstallDir();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Installing lirbary " + libraryName + " in dataverse " + dataverse + ". Install Directory: " + installDir.getAbsolutePath());
        }
        if ((jarsInLibDir = (libDir = new File(installDir.getAbsolutePath() + File.separator + dataverse + File.separator + libraryName)).list(jarFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })).length > 1) {
            throw new Exception("Incorrect library structure: found multiple library jars");
        }
        if (jarsInLibDir.length < 0) {
            throw new Exception("Incorrect library structure: could not find library jar");
        }
        File libJar = new File(libDir, jarsInLibDir[0]);
        File libDependencyDir = new File(libDir.getAbsolutePath() + File.separator + "lib");
        int numDependencies = 1;
        String[] libraryDependencies = null;
        if (libDependencyDir.exists()) {
            libraryDependencies = libDependencyDir.list(jarFileFilter);
            numDependencies += libraryDependencies.length;
        }
        ClassLoader parentClassLoader = ExternalLibraryUtils.class.getClassLoader();
        URL[] urls = new URL[numDependencies];
        int count = 0;
        urls[count++] = libJar.toURI().toURL();
        if (libraryDependencies != null && libraryDependencies.length > 0) {
            for (String dependency : libraryDependencies) {
                File file = new File(libDependencyDir + File.separator + dependency);
                urls[count++] = file.toURI().toURL();
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder logMesg = new StringBuilder("Classpath for library " + libraryName + "\n");
            for (URL url : urls) {
                logMesg.append(url.getFile() + "\n");
            }
            LOGGER.info(logMesg.toString());
        }
        return new ExternalLibraryClassLoader(urls, parentClassLoader);
    }

    protected static File getLibraryInstallDir() {
        String workingDir = System.getProperty("user.dir");
        return new File(workingDir, "library");
    }

    protected static File getLibraryUninstallDir() {
        String workingDir = System.getProperty("user.dir");
        return new File(workingDir, "uninstall");
    }
}

