/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class VersionApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(VersionApiServlet.class.getName());

    public VersionApiServlet(ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
    }

    protected void get(IServletRequest request, IServletResponse response) {
        response.setStatus(HttpResponseStatus.OK);
        IPropertiesProvider props = (IPropertiesProvider)this.ctx.get("org.apache.asterix.APP_CONTEXT_INFO");
        Map buildProperties = props.getBuildProperties().getAllProps();
        ObjectMapper om = new ObjectMapper();
        ObjectNode responseObject = om.createObjectNode();
        for (Map.Entry e : buildProperties.entrySet()) {
            responseObject.put((String)e.getKey(), (String)e.getValue());
        }
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"text/plain", (String)"utf-8");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failure handling request", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        PrintWriter responseWriter = response.writer();
        responseWriter.write(responseObject.toString());
        responseWriter.flush();
    }
}

