/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.ctx.StatementExecutorContext;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.SessionConfig;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;

public class QueryServiceServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = Logger.getLogger(QueryServiceServlet.class.getName());
    private final ILangCompilationProvider compilationProvider;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider componentProvider;
    private final IStatementExecutorContext queryCtx = new StatementExecutorContext();

    public QueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider) {
        super(ctx, paths);
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
        ctx.put("org.apache.asterix.RUNINNG_QUERIES", this.queryCtx);
    }

    protected void post(IServletRequest request, IServletResponse response) {
        try {
            this.handleRequest(this.getRequestParameters(request), response);
        }
        catch (IOException e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static String getParameterValue(String content, String attribute) {
        if (content == null || attribute == null) {
            return null;
        }
        int sc = content.indexOf(59);
        if (sc < 0) {
            return null;
        }
        int eq = content.indexOf(61, sc + 1);
        if (eq < 0) {
            return null;
        }
        if (content.substring(sc + 1, eq).trim().equalsIgnoreCase(attribute)) {
            return content.substring(eq + 1).trim().toLowerCase();
        }
        return null;
    }

    private static String toLower(String s) {
        return s != null ? s.toLowerCase() : s;
    }

    private static SessionConfig.OutputFormat getFormat(String format) {
        if (format != null) {
            if (format.startsWith("text/csv")) {
                return SessionConfig.OutputFormat.CSV;
            }
            if (format.equals("application/x-adm")) {
                return SessionConfig.OutputFormat.ADM;
            }
            if (format.startsWith("application/json")) {
                return Boolean.parseBoolean(QueryServiceServlet.getParameterValue(format, Attribute.LOSSLESS.str())) ? SessionConfig.OutputFormat.LOSSLESS_JSON : SessionConfig.OutputFormat.CLEAN_JSON;
            }
        }
        return SessionConfig.OutputFormat.CLEAN_JSON;
    }

    private static SessionConfig createSessionConfig(RequestParameters param, String handleUrl, PrintWriter resultWriter) {
        SessionConfig.ResultDecorator resultPrefix = new SessionConfig.ResultDecorator(){
            int resultNo = -1;

            public AlgebricksAppendable append(AlgebricksAppendable app) throws AlgebricksException {
                app.append((CharSequence)"\t\"");
                app.append((CharSequence)AbstractQueryApiServlet.ResultFields.RESULTS.str());
                if (this.resultNo >= 0) {
                    app.append('-').append((CharSequence)String.valueOf(this.resultNo));
                }
                ++this.resultNo;
                app.append((CharSequence)"\": ");
                return app;
            }
        };
        SessionConfig.ResultDecorator resultPostfix = app -> app.append((CharSequence)"\t,\n");
        SessionConfig.ResultAppender appendHandle = (app, handle) -> app.append((CharSequence)"\t\"").append((CharSequence)AbstractQueryApiServlet.ResultFields.HANDLE.str()).append((CharSequence)"\": \"").append((CharSequence)handleUrl).append((CharSequence)handle).append((CharSequence)"\",\n");
        SessionConfig.ResultAppender appendStatus = (app, status) -> app.append((CharSequence)"\t\"").append((CharSequence)AbstractQueryApiServlet.ResultFields.STATUS.str()).append((CharSequence)"\": \"").append((CharSequence)status).append((CharSequence)"\",\n");
        SessionConfig.OutputFormat format = QueryServiceServlet.getFormat(param.format);
        SessionConfig sessionConfig = new SessionConfig(resultWriter, format, resultPrefix, resultPostfix, appendHandle, appendStatus);
        sessionConfig.set("format-wrapper-array", true);
        sessionConfig.set("indent-json", param.pretty);
        sessionConfig.set("quote-record", format != SessionConfig.OutputFormat.CLEAN_JSON && format != SessionConfig.OutputFormat.LOSSLESS_JSON);
        sessionConfig.set("format-csv-header", format == SessionConfig.OutputFormat.CSV && "present".equals(QueryServiceServlet.getParameterValue(param.format, Attribute.HEADER.str())));
        return sessionConfig;
    }

    private static void printClientContextID(PrintWriter pw, RequestParameters params) {
        if (params.clientContextID != null && !params.clientContextID.isEmpty()) {
            ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.CLIENT_ID.str(), params.clientContextID);
        }
    }

    private static void printSignature(PrintWriter pw) {
        ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.SIGNATURE.str(), "*");
    }

    private static void printType(PrintWriter pw, SessionConfig sessionConfig) {
        switch (sessionConfig.fmt()) {
            case ADM: {
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), "application/x-adm");
                break;
            }
            case CSV: {
                String contentType = "text/csv; header=" + (sessionConfig.is("format-csv-header") ? "present" : "absent");
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), contentType);
                break;
            }
        }
    }

    private static void printMetrics(PrintWriter pw, long elapsedTime, long executionTime, long resultCount, long resultSize) {
        pw.print("\t\"");
        pw.print(AbstractQueryApiServlet.ResultFields.METRICS.str());
        pw.print("\": {\n");
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.ELAPSED_TIME.str(), TimeUnit.formatNanos(elapsedTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.EXECUTION_TIME.str(), TimeUnit.formatNanos(executionTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_COUNT.str(), resultCount, true);
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_SIZE.str(), resultSize, false);
        pw.print("\t}\n");
    }

    private String getOptText(JsonNode node, String fieldName) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asText() : null;
    }

    private boolean getOptBoolean(JsonNode node, String fieldName, boolean defaultValue) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asBoolean() : defaultValue;
    }

    private RequestParameters getRequestParameters(IServletRequest request) throws IOException {
        String contentTypeParam = request.getHttpRequest().headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        int sep = contentTypeParam.indexOf(59);
        String contentType = sep < 0 ? contentTypeParam.trim() : contentTypeParam.substring(0, sep).trim();
        RequestParameters param = new RequestParameters();
        param.host = this.host(request);
        param.path = this.servletPath(request);
        if ("application/json".equals(contentType)) {
            try {
                JsonNode jsonRequest = new ObjectMapper().readTree(QueryServiceServlet.getRequestBody(request));
                param.statement = jsonRequest.get(Parameter.STATEMENT.str()).asText();
                param.format = QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.FORMAT.str()));
                param.pretty = this.getOptBoolean(jsonRequest, Parameter.PRETTY.str(), false);
                param.mode = QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.MODE.str()));
                param.clientContextID = this.getOptText(jsonRequest, Parameter.CLIENT_ID.str());
            }
            catch (JsonParseException | JsonMappingException e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            param.statement = request.getParameter((CharSequence)Parameter.STATEMENT.str());
            if (param.statement == null) {
                param.statement = QueryServiceServlet.getRequestBody(request);
            }
            param.format = QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.FORMAT.str()));
            param.pretty = Boolean.parseBoolean(request.getParameter((CharSequence)Parameter.PRETTY.str()));
            param.mode = QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.MODE.str()));
            param.clientContextID = request.getParameter((CharSequence)Parameter.CLIENT_ID.str());
        }
        return param;
    }

    private static String getRequestBody(IServletRequest request) throws IOException {
        return request.getHttpRequest().content().toString(StandardCharsets.UTF_8);
    }

    private static IStatementExecutor.ResultDelivery parseResultDelivery(String mode) {
        if ("async".equals(mode)) {
            return IStatementExecutor.ResultDelivery.ASYNC;
        }
        if ("deferred".equals(mode)) {
            return IStatementExecutor.ResultDelivery.DEFERRED;
        }
        return IStatementExecutor.ResultDelivery.IMMEDIATE;
    }

    private static String handlePath(IStatementExecutor.ResultDelivery delivery) {
        switch (delivery) {
            case ASYNC: {
                return "/status/";
            }
            case DEFERRED: {
                return "/result/";
            }
        }
        return "";
    }

    protected String getHandleUrl(String host, String path, IStatementExecutor.ResultDelivery delivery) {
        return "http://" + host + path + QueryServiceServlet.handlePath(delivery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(RequestParameters param, IServletResponse response) throws IOException {
        LOGGER.info(param.toString());
        long elapsedStart = System.nanoTime();
        StringWriter stringWriter = new StringWriter();
        PrintWriter resultWriter = new PrintWriter(stringWriter);
        IStatementExecutor.ResultDelivery delivery = QueryServiceServlet.parseResultDelivery(param.mode);
        String handleUrl = this.getHandleUrl(param.host, param.path, delivery);
        SessionConfig sessionConfig = QueryServiceServlet.createSessionConfig(param, handleUrl, resultWriter);
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        HttpResponseStatus status = HttpResponseStatus.OK;
        IStatementExecutor.Stats stats = new IStatementExecutor.Stats();
        long execStart = -1L;
        long execEnd = -1L;
        resultWriter.print("{\n");
        QueryServiceServlet.printRequestId(resultWriter);
        QueryServiceServlet.printClientContextID(resultWriter, param);
        QueryServiceServlet.printSignature(resultWriter);
        QueryServiceServlet.printType(resultWriter, sessionConfig);
        try {
            IClusterManagementWork.ClusterState clusterState = ClusterStateManager.INSTANCE.getState();
            if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
                throw new IllegalStateException("Cannot execute request, cluster is " + clusterState);
            }
            if (param.statement == null || param.statement.isEmpty()) {
                throw new AsterixException("Empty request, no statement provided");
            }
            IParser parser = this.compilationProvider.getParserFactory().createParser(param.statement + ";");
            List statements = parser.parse();
            MetadataManager.INSTANCE.init();
            IStatementExecutor translator = this.statementExecutorFactory.create(statements, sessionConfig, this.compilationProvider, this.componentProvider);
            execStart = System.nanoTime();
            translator.compileAndExecute(this.getHyracksClientConnection(), this.getHyracksDataset(), delivery, stats, param.clientContextID, this.queryCtx);
            execEnd = System.nanoTime();
            if (IStatementExecutor.ResultDelivery.IMMEDIATE == delivery || IStatementExecutor.ResultDelivery.DEFERRED == delivery) {
                ResultUtil.printStatus(sessionConfig, AbstractQueryApiServlet.ResultStatus.SUCCESS);
            }
        }
        catch (org.apache.asterix.aqlplus.parser.TokenMgrError | AsterixException | TokenMgrError pe) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, pe.getMessage(), pe);
            ResultUtil.printError(resultWriter, pe);
            ResultUtil.printStatus(sessionConfig, AbstractQueryApiServlet.ResultStatus.FATAL);
            status = HttpResponseStatus.BAD_REQUEST;
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            ResultUtil.printError(resultWriter, e);
            ResultUtil.printStatus(sessionConfig, AbstractQueryApiServlet.ResultStatus.FATAL);
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        }
        finally {
            if (execStart == -1L) {
                execEnd = -1L;
            } else if (execEnd == -1L) {
                execEnd = System.nanoTime();
            }
        }
        QueryServiceServlet.printMetrics(resultWriter, System.nanoTime() - elapsedStart, execEnd - execStart, stats.getCount(), stats.getSize());
        resultWriter.print("}\n");
        resultWriter.flush();
        String result = stringWriter.toString();
        GlobalConfig.ASTERIX_LOGGER.log(Level.FINE, result);
        response.setStatus(status);
        response.writer().print(result);
        if (response.writer().checkError()) {
            LOGGER.warning("Error flushing output writer");
        }
    }

    static class RequestParameters {
        String host;
        String path;
        String statement;
        String format;
        boolean pretty;
        String clientContextID;
        String mode;

        RequestParameters() {
        }

        public String toString() {
            try {
                ObjectMapper om = new ObjectMapper();
                ObjectNode on = om.createObjectNode();
                on.put("host", this.host);
                on.put("path", this.path);
                on.put("statement", JSONUtil.escape((StringBuilder)new StringBuilder(), (String)this.statement).toString());
                on.put("pretty", this.pretty);
                on.put("mode", this.mode);
                on.put("clientContextID", this.clientContextID);
                return om.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)on);
            }
            catch (JsonProcessingException e) {
                return e.getMessage();
            }
        }
    }

    public static enum TimeUnit {
        SEC("s", 9),
        MILLI("ms", 6),
        MICRO("\u00b5s", 3),
        NANO("ns", 0);

        String unit;
        int nanoDigits;

        private TimeUnit(String unit, int nanoDigits) {
            this.unit = unit;
            this.nanoDigits = nanoDigits;
        }

        public static String formatNanos(long nanoTime) {
            String strTime = String.valueOf(nanoTime);
            int len = strTime.length();
            for (TimeUnit tu : TimeUnit.values()) {
                if (len <= tu.nanoDigits) continue;
                String integer = strTime.substring(0, len - tu.nanoDigits);
                String fractional = strTime.substring(len - tu.nanoDigits);
                return integer + (fractional.length() > 0 ? "." + fractional : "") + tu.unit;
            }
            return "illegal string value: " + strTime;
        }
    }

    private static enum Metrics {
        ELAPSED_TIME("elapsedTime"),
        EXECUTION_TIME("executionTime"),
        RESULT_COUNT("resultCount"),
        RESULT_SIZE("resultSize");

        private final String str;

        private Metrics(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    private static enum Attribute {
        HEADER("header"),
        LOSSLESS("lossless");

        private final String str;

        private Attribute(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum Parameter {
        STATEMENT("statement"),
        FORMAT("format"),
        CLIENT_ID("client_context_id"),
        PRETTY("pretty"),
        MODE("mode");

        private final String str;

        private Parameter(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

