/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class NodeControllerDetailsApiServlet
extends ClusterApiServlet {
    private static final Logger LOGGER = Logger.getLogger(NodeControllerDetailsApiServlet.class.getName());
    private final ObjectMapper om = new ObjectMapper();

    public NodeControllerDetailsApiServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
        this.om.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        PrintWriter responseWriter = response.writer();
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        try {
            ObjectNode json;
            response.setStatus(HttpResponseStatus.OK);
            if ("".equals(this.localPath(request))) {
                json = this.om.createObjectNode();
                json.set("ncs", this.getClusterStateJSON(request, "../").get("ncs"));
            } else {
                json = this.processNode(request, hcc);
            }
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
            responseWriter.write(this.om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
        }
        catch (IllegalStateException e) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    private ObjectNode processNode(IServletRequest request, IHyracksClientConnection hcc) throws Exception {
        String localPath = this.localPath(request);
        if (localPath.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String[] parts = localPath.substring(1).split("/");
        String node = parts[0];
        if (parts.length == 1) {
            ArrayNode ncs = (ArrayNode)this.getClusterStateJSON(request, "../../").get("ncs");
            for (int i = 0; i < ncs.size(); ++i) {
                if (!node.equals(ncs.get(i).get("node_id").asText())) continue;
                return (ObjectNode)ncs.get(i);
            }
            if ("cc".equals(node)) {
                return this.om.createObjectNode();
            }
            throw new IllegalArgumentException();
        }
        if (parts.length == 2) {
            ObjectNode json;
            switch (parts[1]) {
                case "config": {
                    json = this.processNodeConfig(hcc, node);
                    break;
                }
                case "stats": {
                    json = this.processNodeStats(hcc, node);
                    break;
                }
                case "threaddump": {
                    return this.processNodeThreadDump(hcc, node);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.fixupKeys(json);
            return json;
        }
        throw new IllegalArgumentException();
    }

    protected ObjectNode fixupKeys(ObjectNode json) {
        ArrayList keys = new ArrayList();
        Iterator iter = json.fieldNames();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        for (String key : keys) {
            String newKey = key.replace('-', '_');
            if (newKey.equals(key)) continue;
            json.set(newKey, json.remove(key));
        }
        return json;
    }

    protected ObjectNode processNodeStats(IHyracksClientConnection hcc, String node) throws Exception {
        String details = hcc.getNodeDetailsJSON(node, true, false);
        if (details == null) {
            throw new IllegalArgumentException();
        }
        ObjectNode json = (ObjectNode)this.om.readTree(details);
        int index = json.get("rrd-ptr").asInt() - 1;
        json.remove("rrd-ptr");
        ArrayList keys = new ArrayList();
        Iterator iter = json.fieldNames();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        ArrayNode gcNames = (ArrayNode)json.get("gc-names");
        ArrayNode gcCollectionTimes = (ArrayNode)json.get("gc-collection-times");
        ArrayNode gcCollectionCounts = (ArrayNode)json.get("gc-collection-counts");
        for (String key : keys) {
            if (key.startsWith("gc-")) {
                json.remove(key);
                continue;
            }
            JsonNode keyNode = json.get(key);
            if (!(keyNode instanceof ArrayNode)) continue;
            ArrayNode valueArray = (ArrayNode)keyNode;
            if (index == -1) {
                index = valueArray.size() - 1;
            }
            JsonNode value = valueArray.get(index);
            json.remove(key);
            json.set(key.replaceAll("s$", ""), value);
        }
        ArrayNode gcs = this.om.createArrayNode();
        for (int i = 0; i < gcNames.size(); ++i) {
            ObjectNode gc = this.om.createObjectNode();
            gc.set("name", gcNames.get(i));
            gc.set("collection-time", ((ArrayNode)gcCollectionTimes.get(i)).get(index));
            gc.set("collection-count", ((ArrayNode)gcCollectionCounts.get(i)).get(index));
            gcs.add((JsonNode)gc);
        }
        json.set("gcs", (JsonNode)gcs);
        return json;
    }

    private ObjectNode processNodeConfig(IHyracksClientConnection hcc, String node) throws Exception {
        String config = hcc.getNodeDetailsJSON(node, false, true);
        if (config == null) {
            throw new IllegalArgumentException();
        }
        return (ObjectNode)this.om.readTree(config);
    }

    private ObjectNode processNodeThreadDump(IHyracksClientConnection hcc, String node) throws Exception {
        if ("cc".equals(node)) {
            return this.om.createObjectNode();
        }
        String dump = hcc.getThreadDump(node);
        if (dump == null) {
            throw ClusterStateManager.INSTANCE.getNodePartitions(node) != null ? new IllegalStateException() : new IllegalArgumentException();
        }
        return (ObjectNode)this.om.readTree(dump);
    }
}

