/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslatorFactory;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.utils.Job;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.IRuleSetFactory;
import org.apache.asterix.dataflow.data.common.ConflictingTypeResolver;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.dataflow.data.common.MergeAggregationExpressionFactory;
import org.apache.asterix.dataflow.data.common.MissableTypeComputer;
import org.apache.asterix.dataflow.data.common.PartialAggregationTypeComputer;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.jobgen.QueryLogicalExpressionJobGen;
import org.apache.asterix.lang.common.base.IAstPrintVisitorFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.transaction.management.service.transaction.JobIdFactory;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.utils.ResourceUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.compiler.api.HeuristicCompilerFactoryBuilder;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.ExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.control.common.config.OptionTypes;

public class APIFramework {
    private static final int MIN_FRAME_LIMIT_FOR_SORT = 3;
    private static final int MIN_FRAME_LIMIT_FOR_GROUP_BY = 4;
    private static final int MIN_FRAME_LIMIT_FOR_JOIN = 5;
    private static final Set<String> CONFIGURABLE_PARAMETER_NAMES = ImmutableSet.of((Object)CompilerProperties.COMPILER_JOINMEMORY_KEY, (Object)CompilerProperties.COMPILER_GROUPMEMORY_KEY, (Object)CompilerProperties.COMPILER_SORTMEMORY_KEY, (Object)CompilerProperties.COMPILER_PARALLELISM_KEY, (Object)"import-private-functions", (Object)"simfunction", (Object[])new String[]{"simthreshold", "wait-for-completion-feed", "feed-policy-name", "collect-locations", "inline_with", "hash_merge", "output-record-type"});
    private final IRewriterFactory rewriterFactory;
    private final IAstPrintVisitorFactory astPrintVisitorFactory;
    private final ILangExpressionToPlanTranslatorFactory translatorFactory;
    private final IRuleSetFactory ruleSetFactory;

    public APIFramework(ILangCompilationProvider compilationProvider) {
        this.rewriterFactory = compilationProvider.getRewriterFactory();
        this.astPrintVisitorFactory = compilationProvider.getAstPrintVisitorFactory();
        this.translatorFactory = compilationProvider.getExpressionToPlanTranslatorFactory();
        this.ruleSetFactory = compilationProvider.getRuleSetFactory();
    }

    private void printPlanPrefix(SessionConfig conf, String planName) {
        if (conf.is("format-html")) {
            conf.out().println("<h4>" + planName + ":</h4>");
            conf.out().println("<pre>");
        } else {
            conf.out().println("----------" + planName + ":");
        }
    }

    private void printPlanPostfix(SessionConfig conf) {
        if (conf.is("format-html")) {
            conf.out().println("</pre>");
        }
    }

    public Pair<IReturningStatement, Integer> reWriteQuery(List<FunctionDecl> declaredFunctions, MetadataProvider metadataProvider, IReturningStatement q, SessionConfig conf) throws CompilationException {
        if (q == null) {
            return null;
        }
        if (!conf.is("format-only-physical-ops") && conf.is("oob-expr-tree")) {
            conf.out().println();
            this.printPlanPrefix(conf, "Expression tree");
            q.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(conf.out()), (Object)0);
            this.printPlanPostfix(conf);
        }
        IQueryRewriter rw = this.rewriterFactory.createQueryRewriter();
        rw.rewrite(declaredFunctions, q, metadataProvider, new LangRewritingContext(q.getVarCounter()));
        return new Pair((Object)q, (Object)q.getVarCounter());
    }

    public JobSpecification compileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query rwQ, int varCounter, String outputDatasetName, SessionConfig conf, CompiledStatements.ICompiledDmlStatement statement) throws AlgebricksException, RemoteException, ACIDException {
        LogicalOperatorPrettyPrintVisitor pvisitor;
        if (!conf.is("format-only-physical-ops") && conf.is("oob-rewritten-expr-tree")) {
            conf.out().println();
            this.printPlanPrefix(conf, "Rewritten expression tree");
            if (rwQ != null) {
                rwQ.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(conf.out()), (Object)0);
            }
            this.printPlanPostfix(conf);
        }
        org.apache.asterix.common.transactions.JobId asterixJobId = JobIdFactory.generateJobId();
        metadataProvider.setJobId(asterixJobId);
        ILangExpressionToPlanTranslator t = this.translatorFactory.createExpressionToPlanTranslator(metadataProvider, varCounter);
        ILogicalPlan plan = statement == null || statement.getKind() != 10 ? t.translate(rwQ, outputDatasetName, statement) : t.translateLoad(statement);
        if (!conf.is("format-only-physical-ops") && conf.is("oob-logical-plan")) {
            conf.out().println();
            this.printPlanPrefix(conf, "Logical plan");
            if (rwQ != null || statement != null && statement.getKind() == 10) {
                LogicalOperatorPrettyPrintVisitor pvisitor2 = new LogicalOperatorPrettyPrintVisitor((Appendable)conf.out());
                PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (LogicalOperatorPrettyPrintVisitor)pvisitor2, (int)0);
            }
            this.printPlanPostfix(conf);
        }
        CompilerProperties compilerProperties = AppContextInfo.INSTANCE.getCompilerProperties();
        int frameSize = compilerProperties.getFrameSize();
        Map querySpecificConfig = metadataProvider.getConfig();
        APIFramework.validateConfig(querySpecificConfig);
        int sortFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_SORTMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORTMEMORY_KEY), compilerProperties.getSortMemorySize(), frameSize, 3);
        int groupFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_GROUPMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_GROUPMEMORY_KEY), compilerProperties.getGroupMemorySize(), frameSize, 4);
        int joinFrameLimit = APIFramework.getFrameLimit(CompilerProperties.COMPILER_JOINMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_JOINMEMORY_KEY), compilerProperties.getJoinMemorySize(), frameSize, 5);
        OptimizationConfUtil.getPhysicalOptimizationConfig().setFrameSize(frameSize);
        OptimizationConfUtil.getPhysicalOptimizationConfig().setMaxFramesExternalSort(sortFrameLimit);
        OptimizationConfUtil.getPhysicalOptimizationConfig().setMaxFramesExternalGroupBy(groupFrameLimit);
        OptimizationConfUtil.getPhysicalOptimizationConfig().setMaxFramesForJoin(joinFrameLimit);
        HeuristicCompilerFactoryBuilder builder = new HeuristicCompilerFactoryBuilder((IOptimizationContextFactory)OptimizationContextFactory.INSTANCE);
        builder.setPhysicalOptimizationConfig(OptimizationConfUtil.getPhysicalOptimizationConfig());
        builder.setLogicalRewrites(this.ruleSetFactory.getLogicalRewrites());
        builder.setPhysicalRewrites(this.ruleSetFactory.getPhysicalRewrites());
        IDataFormat format = metadataProvider.getFormat();
        ICompilerFactory compilerFactory = builder.create();
        builder.setExpressionEvalSizeComputer(format.getExpressionEvalSizeComputer());
        builder.setIMergeAggregationExpressionFactory((IMergeAggregationExpressionFactory)new MergeAggregationExpressionFactory());
        builder.setPartialAggregationTypeComputer((IPartialAggregationTypeComputer)new PartialAggregationTypeComputer());
        builder.setExpressionTypeComputer((IExpressionTypeComputer)ExpressionTypeComputer.INSTANCE);
        builder.setMissableTypeComputer((IMissableTypeComputer)MissableTypeComputer.INSTANCE);
        builder.setConflictingTypeResolver((IConflictingTypeResolver)ConflictingTypeResolver.INSTANCE);
        int parallelism = APIFramework.getParallelism((String)querySpecificConfig.get(CompilerProperties.COMPILER_PARALLELISM_KEY), compilerProperties.getParallelism());
        AlgebricksAbsolutePartitionConstraint computationLocations = APIFramework.chooseLocations(clusterInfoCollector, parallelism, metadataProvider.getClusterLocations());
        builder.setClusterLocations(computationLocations);
        ICompiler compiler = compilerFactory.createCompiler(plan, (IMetadataProvider)metadataProvider, t.getVarCounter());
        if (conf.isOptimize()) {
            compiler.optimize();
            if (conf.is("oob-optimized-logical-plan")) {
                if (conf.is("format-only-physical-ops")) {
                    AlgebricksAppendable buffer = new AlgebricksAppendable((Appendable)conf.out());
                    PlanPrettyPrinter.printPhysicalOps((ILogicalPlan)plan, (AlgebricksAppendable)buffer, (int)0);
                } else {
                    this.printPlanPrefix(conf, "Optimized logical plan");
                    if (rwQ != null || statement != null && statement.getKind() == 10) {
                        pvisitor = new LogicalOperatorPrettyPrintVisitor((Appendable)conf.out());
                        PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (LogicalOperatorPrettyPrintVisitor)pvisitor, (int)0);
                    }
                    this.printPlanPostfix(conf);
                }
            }
        }
        if (rwQ != null && rwQ.isExplain()) {
            try {
                pvisitor = new LogicalOperatorPrettyPrintVisitor();
                PlanPrettyPrinter.printPlan((ILogicalPlan)plan, (LogicalOperatorPrettyPrintVisitor)pvisitor, (int)0);
                ResultUtil.printResults(pvisitor.get().toString(), conf, new IStatementExecutor.Stats(), null);
                return null;
            }
            catch (IOException e) {
                throw new AlgebricksException((Throwable)e);
            }
        }
        if (!conf.isGenerateJobSpec()) {
            return null;
        }
        builder.setBinaryBooleanInspectorFactory(format.getBinaryBooleanInspectorFactory());
        builder.setBinaryIntegerInspectorFactory(format.getBinaryIntegerInspectorFactory());
        builder.setComparatorFactoryProvider(format.getBinaryComparatorFactoryProvider());
        builder.setExpressionRuntimeProvider((IExpressionRuntimeProvider)new ExpressionRuntimeProvider((ILogicalExpressionJobGen)QueryLogicalExpressionJobGen.INSTANCE));
        builder.setHashFunctionFactoryProvider(format.getBinaryHashFunctionFactoryProvider());
        builder.setHashFunctionFamilyProvider(format.getBinaryHashFunctionFamilyProvider());
        builder.setMissingWriterFactory(format.getMissingWriterFactory());
        builder.setPredicateEvaluatorFactoryProvider(format.getPredicateEvaluatorFactoryProvider());
        SessionConfig.OutputFormat outputFormat = conf.fmt();
        switch (outputFormat) {
            case LOSSLESS_JSON: {
                builder.setPrinterProvider(format.getLosslessJSONPrinterFactoryProvider());
                break;
            }
            case CSV: {
                builder.setPrinterProvider(format.getCSVPrinterFactoryProvider());
                break;
            }
            case ADM: {
                builder.setPrinterProvider(format.getADMPrinterFactoryProvider());
                break;
            }
            case CLEAN_JSON: {
                builder.setPrinterProvider(format.getCleanJSONPrinterFactoryProvider());
                break;
            }
            default: {
                throw new AlgebricksException("Unexpected OutputFormat: " + outputFormat);
            }
        }
        builder.setSerializerDeserializerProvider(format.getSerdeProvider());
        builder.setTypeTraitProvider(format.getTypeTraitProvider());
        builder.setNormalizedKeyComputerFactoryProvider(format.getNormalizedKeyComputerFactoryProvider());
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(asterixJobId, metadataProvider.isWriteTransaction());
        JobSpecification spec = compiler.createJob((Object)AppContextInfo.INSTANCE, (IJobletEventListenerFactory)jobEventListenerFactory);
        if (statement == null) {
            spec.setRequiredClusterCapacity(ResourceUtils.getRequiredCompacity(plan, computationLocations, sortFrameLimit, groupFrameLimit, joinFrameLimit, frameSize));
        }
        if (conf.is("oob-hyracks-job")) {
            this.printPlanPrefix(conf, "Hyracks job");
            if (rwQ != null) {
                try {
                    conf.out().println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)spec.toJSON()));
                }
                catch (IOException e) {
                    throw new AlgebricksException((Throwable)e);
                }
                conf.out().println(spec.getUserConstraints());
            }
            this.printPlanPostfix(conf);
        }
        return spec;
    }

    public void executeJobArray(IHyracksClientConnection hcc, JobSpecification[] specs, PrintWriter out) throws Exception {
        for (JobSpecification spec : specs) {
            spec.setMaxReattempts(0);
            JobId jobId = hcc.startJob(spec);
            long startTime = System.currentTimeMillis();
            hcc.waitForCompletion(jobId);
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    public void executeJobArray(IHyracksClientConnection hcc, Job[] jobs, PrintWriter out) throws Exception {
        for (Job job : jobs) {
            job.getJobSpec().setMaxReattempts(0);
            long startTime = System.currentTimeMillis();
            try {
                JobId jobId = hcc.startJob(job.getJobSpec());
                if (job.getSubmissionMode() == Job.SubmissionMode.ASYNCHRONOUS) continue;
                hcc.waitForCompletion(jobId);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    private static AlgebricksAbsolutePartitionConstraint chooseLocations(IClusterInfoCollector clusterInfoCollector, int parallelismHint, AlgebricksAbsolutePartitionConstraint storageLocations) throws AlgebricksException {
        try {
            Map ncMap = clusterInfoCollector.getNodeControllerInfos();
            int totalNumCores = APIFramework.getTotalNumCores(ncMap);
            if (parallelismHint == 0 && storageLocations.getLocations().length <= totalNumCores) {
                return storageLocations;
            }
            return APIFramework.getComputationLocations(ncMap, parallelismHint);
        }
        catch (HyracksException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private static AlgebricksAbsolutePartitionConstraint getComputationLocations(Map<String, NodeControllerInfo> ncMap, int parallelismHint) {
        int parallelism = parallelismHint <= 0 ? -2 * ncMap.size() : parallelismHint;
        int numNodes = ncMap.size();
        int numNodesWithOneMorePartition = parallelism % numNodes;
        int perNodeParallelismMin = parallelism / numNodes;
        int perNodeParallelismMax = parallelism / numNodes + 1;
        ArrayList<String> allNodes = new ArrayList<String>();
        HashSet selectedNodesWithOneMorePartition = new HashSet();
        for (Map.Entry<String, NodeControllerInfo> entry : ncMap.entrySet()) {
            allNodes.add(entry.getKey());
        }
        Random random = new Random();
        for (int index = numNodesWithOneMorePartition; index >= 1; --index) {
            int pick = random.nextInt(index);
            selectedNodesWithOneMorePartition.add(allNodes.get(pick));
            Collections.swap(allNodes, pick, index - 1);
        }
        ArrayList<String> locations = new ArrayList<String>();
        for (Map.Entry<String, NodeControllerInfo> entry : ncMap.entrySet()) {
            String nodeId = entry.getKey();
            int availableCores = entry.getValue().getNumAvailableCores();
            int nodeParallelism = selectedNodesWithOneMorePartition.contains(nodeId) ? perNodeParallelismMax : perNodeParallelismMin;
            int coresToUse = nodeParallelism >= 0 && nodeParallelism < availableCores ? nodeParallelism : availableCores;
            for (int count = 0; count < coresToUse; ++count) {
                locations.add(nodeId);
            }
        }
        return new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
    }

    private static int getTotalNumCores(Map<String, NodeControllerInfo> ncMap) {
        int sum = 0;
        for (Map.Entry<String, NodeControllerInfo> entry : ncMap.entrySet()) {
            sum += entry.getValue().getNumAvailableCores();
        }
        return sum;
    }

    private static int getFrameLimit(String parameterName, String parameter, long memBudgetInConfiguration, int frameSize, int minFrameLimit) throws AlgebricksException {
        IOptionType longBytePropertyInterpreter = OptionTypes.LONG_BYTE_UNIT;
        long memBudget = parameter == null ? memBudgetInConfiguration : (Long)longBytePropertyInterpreter.parse(parameter);
        int frameLimit = (int)(memBudget / (long)frameSize);
        if (frameLimit < minFrameLimit) {
            throw AsterixException.create((int)1037, (Serializable[])new Serializable[]{parameterName, Integer.valueOf(frameSize * minFrameLimit)});
        }
        return Math.max(frameLimit, minFrameLimit);
    }

    private static int getParallelism(String parameter, int parallelismInConfiguration) {
        IOptionType integerIPropertyInterpreter = OptionTypes.INTEGER;
        return parameter == null ? parallelismInConfiguration : (Integer)integerIPropertyInterpreter.parse(parameter);
    }

    private static void validateConfig(Map<String, String> config) throws AlgebricksException {
        for (String parameterName : config.keySet()) {
            if (CONFIGURABLE_PARAMETER_NAMES.contains(parameterName)) continue;
            throw AsterixException.create((int)1028, (Serializable[])new Serializable[]{parameterName});
        }
    }

    private static class OptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final OptimizationContextFactory INSTANCE = new OptimizationContextFactory();

        private OptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IConflictingTypeResolver conflictingTypeResolver, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations) {
            return new AlgebricksOptimizationContext(varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, missableTypeComputer, conflictingTypeResolver, physicalOptimizationConfig, clusterLocations);
        }
    }
}

