/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.filecache;

import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.filecache.FileCacheKey;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;

public class LazyFileCacheKey
extends FileCacheKey {
    private final HttpRequestPacket request;
    private boolean isInitialized;

    public LazyFileCacheKey(HttpRequestPacket request) {
        this.request = request;
    }

    @Override
    protected String getHost() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return super.getHost();
    }

    @Override
    protected String getUri() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return super.getUri();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        String otherHost = other.host;
        DataChunk hostDC = this.getHostLazy();
        if (hostDC == null || hostDC.isNull() ? otherHost != null : !hostDC.equals(otherHost)) {
            return false;
        }
        String otherUri = other.uri;
        DataChunk uriDC = this.getUriLazy();
        return !(uriDC == null || uriDC.isNull() ? otherUri != null : !uriDC.equals(otherUri));
    }

    @Override
    public int hashCode() {
        int hash = 3;
        DataChunk hostDC = this.getHostLazy();
        DataChunk uriDC = this.getUriLazy();
        hash = 23 * hash + (hostDC != null ? hostDC.hashCode() : 0);
        hash = 23 * hash + (uriDC != null ? uriDC.hashCode() : 0);
        return hash;
    }

    private void initialize() {
        this.host = this.request.getHeader(Header.Host);
        this.uri = this.request.getRequestURI();
    }

    private DataChunk getHostLazy() {
        return this.request.getHeaders().getValue(Header.Host);
    }

    private DataChunk getUriLazy() {
        return this.request.getRequestURIRef().getRequestURIBC();
    }
}

