/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.file;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class TransientLocalResourceRepository
implements ILocalResourceRepository {
    private Map<String, LocalResource> name2ResourceMap = new HashMap<String, LocalResource>();
    private Map<Long, LocalResource> id2ResourceMap = new HashMap<Long, LocalResource>();

    @Override
    public LocalResource get(String path) throws HyracksDataException {
        return this.name2ResourceMap.get(path);
    }

    @Override
    public synchronized void insert(LocalResource resource) throws HyracksDataException {
        long id = resource.getId();
        if (this.id2ResourceMap.containsKey(id)) {
            throw new HyracksDataException("Duplicate resource");
        }
        this.id2ResourceMap.put(id, resource);
        this.name2ResourceMap.put(resource.getPath(), resource);
    }

    @Override
    public synchronized void delete(String path) throws HyracksDataException {
        LocalResource resource = this.name2ResourceMap.get(path);
        if (resource == null) {
            throw new HyracksDataException("Resource doesn't exist");
        }
        this.id2ResourceMap.remove(resource.getId());
        this.name2ResourceMap.remove(path);
    }

    @Override
    public long maxId() throws HyracksDataException {
        long maxResourceId = 0L;
        for (Long resourceId : this.id2ResourceMap.keySet()) {
            maxResourceId = Math.max(maxResourceId, resourceId);
        }
        return maxResourceId;
    }
}

