/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.IBufferCacheInternal;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;

public class ClockPageReplacementStrategy
implements IPageReplacementStrategy {
    private static final Logger LOGGER = Logger.getLogger(ClockPageReplacementStrategy.class.getName());
    private static final int MAX_UNSUCCESSFUL_CYCLE_COUNT = 3;
    private IBufferCacheInternal bufferCache;
    private AtomicInteger clockPtr;
    private ICacheMemoryAllocator allocator;
    private AtomicInteger numPages;
    private AtomicInteger cpIdCounter;
    private final int pageSize;
    private final int maxAllowedNumPages;
    private final ConcurrentLinkedQueue<Integer> cpIdFreeList;

    public ClockPageReplacementStrategy(ICacheMemoryAllocator allocator, int pageSize, int maxAllowedNumPages) {
        this.allocator = allocator;
        this.pageSize = pageSize;
        this.maxAllowedNumPages = maxAllowedNumPages;
        this.clockPtr = new AtomicInteger(0);
        this.numPages = new AtomicInteger(0);
        this.cpIdCounter = new AtomicInteger(0);
        this.cpIdFreeList = new ConcurrentLinkedQueue();
    }

    @Override
    public Object createPerPageStrategyObject(int cpid) {
        return new AtomicBoolean();
    }

    @Override
    public void setBufferCache(IBufferCacheInternal bufferCache) {
        this.bufferCache = bufferCache;
    }

    @Override
    public IBufferCacheInternal getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public void notifyCachePageReset(ICachedPageInternal cPage) {
        this.getPerPageObject(cPage).set(false);
    }

    @Override
    public void notifyCachePageAccess(ICachedPageInternal cPage) {
        this.getPerPageObject(cPage).set(true);
    }

    @Override
    public ICachedPageInternal findVictim() {
        return this.findVictim(1);
    }

    @Override
    public ICachedPageInternal findVictim(int multiplier) {
        while (this.numPages.get() + multiplier > this.maxAllowedNumPages) {
            ICachedPageInternal victim = this.findVictimByEviction();
            if (victim == null) {
                return null;
            }
            int multiple = victim.getFrameSizeMultiplier();
            if (multiple == multiplier) {
                return victim;
            }
            if (!this.bufferCache.removePage(victim)) continue;
            this.cpIdFreeList.add(victim.getCachedPageId());
            this.numPages.getAndAdd(-multiple);
        }
        return this.allocatePage(multiplier);
    }

    private ICachedPageInternal findVictimByEviction() {
        int clockPtr;
        assert (this.maxAllowedNumPages > 0);
        int startClockPtr = clockPtr = this.advanceClock();
        int lastClockPtr = -1;
        int cycleCount = 0;
        boolean looped = false;
        AtomicBoolean accessedFlag;
        ICachedPageInternal cPage;
        while ((cPage = this.bufferCache.getPage(clockPtr)) == null || (accessedFlag = this.getPerPageObject(cPage)).compareAndSet(true, false) || !cPage.isGoodVictim()) {
            if (clockPtr < lastClockPtr) {
                looped = true;
            }
            if (looped && clockPtr >= startClockPtr) {
                ++cycleCount;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("completed " + cycleCount + "/" + 3 + " clock cycle(s) without finding victim");
                }
                if (cycleCount >= 3) {
                    return null;
                }
                looped = false;
            }
            lastClockPtr = clockPtr;
            clockPtr = this.advanceClock();
        }
        return cPage;
    }

    @Override
    public int getNumPages() {
        return this.numPages.get();
    }

    private ICachedPageInternal allocatePage(int multiplier) {
        Integer cpId = this.cpIdFreeList.poll();
        if (cpId == null) {
            cpId = this.cpIdCounter.getAndIncrement();
        }
        CachedPage cPage = new CachedPage(cpId, this.allocator.allocate(this.pageSize * multiplier, 1)[0], this);
        cPage.setFrameSizeMultiplier(multiplier);
        this.bufferCache.addPage(cPage);
        this.numPages.getAndAdd(multiplier);
        return cPage;
    }

    @Override
    public void resizePage(ICachedPageInternal cPage, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        int origMultiplier = cPage.getFrameSizeMultiplier();
        if (origMultiplier == multiplier) {
            return;
        }
        int newSize = this.pageSize * multiplier;
        ByteBuffer oldBuffer = ((CachedPage)cPage).buffer;
        oldBuffer.position(0);
        int delta = multiplier - origMultiplier;
        if (multiplier < origMultiplier) {
            oldBuffer.limit(newSize);
            int gap = -delta;
            extraPageBlockHelper.returnFreePageBlock(cPage.getExtraBlockPageId() + gap, gap);
        } else {
            this.ensureBudgetForLargePages(delta);
            if (origMultiplier != 1) {
                extraPageBlockHelper.returnFreePageBlock(cPage.getExtraBlockPageId(), origMultiplier);
            }
            cPage.setExtraBlockPageId(extraPageBlockHelper.getFreeBlock(multiplier));
        }
        cPage.setFrameSizeMultiplier(multiplier);
        ByteBuffer newBuffer = this.allocator.allocate(newSize, 1)[0];
        newBuffer.put(oldBuffer);
        this.numPages.getAndAdd(delta);
        ((CachedPage)cPage).buffer = newBuffer;
    }

    @Override
    public void fixupCapacityOnLargeRead(ICachedPageInternal cPage) throws HyracksDataException {
        ByteBuffer oldBuffer = ((CachedPage)cPage).buffer;
        int multiplier = cPage.getFrameSizeMultiplier();
        int newSize = this.pageSize * multiplier;
        int delta = multiplier - 1;
        oldBuffer.position(0);
        this.ensureBudgetForLargePages(delta);
        ByteBuffer newBuffer = this.allocator.allocate(newSize, 1)[0];
        newBuffer.put(oldBuffer);
        this.numPages.getAndAdd(delta);
        ((CachedPage)cPage).buffer = newBuffer;
    }

    private void ensureBudgetForLargePages(int delta) {
        while (this.numPages.get() + delta > this.maxAllowedNumPages) {
            ICachedPageInternal victim = this.findVictimByEviction();
            if (victim != null) {
                int victimMultiplier = victim.getFrameSizeMultiplier();
                if (!this.bufferCache.removePage(victim)) continue;
                this.cpIdFreeList.add(victim.getCachedPageId());
                this.numPages.getAndAdd(-victimMultiplier);
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) break;
            LOGGER.warning("Exceeding buffer cache budget of " + this.maxAllowedNumPages + " by " + (this.numPages.get() + delta - this.maxAllowedNumPages) + " pages in order to satisfy large page read");
            break;
        }
    }

    private int advanceClock() {
        int newClockPtr;
        int currClockPtr;
        boolean clockInDial;
        while (!(clockInDial = this.clockPtr.compareAndSet(currClockPtr = this.clockPtr.get(), newClockPtr = (currClockPtr + 1) % this.cpIdCounter.get()))) {
        }
        return currClockPtr;
    }

    private AtomicBoolean getPerPageObject(ICachedPageInternal cPage) {
        return (AtomicBoolean)cPage.getReplacementStrategyObject();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getMaxAllowedNumPages() {
        return this.maxAllowedNumPages;
    }

    @Override
    public void adviseWontNeed(ICachedPageInternal cPage) {
        this.getPerPageObject(cPage).set(false);
    }
}

