/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.compiler.api;

import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.compiler.api.AbstractCompilerFactoryBuilder;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.PlanCompiler;
import org.apache.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.HeuristicOptimizer;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobSpecification;

public class HeuristicCompilerFactoryBuilder
extends AbstractCompilerFactoryBuilder {
    private IOptimizationContextFactory optCtxFactory;

    public HeuristicCompilerFactoryBuilder() {
        this.optCtxFactory = DefaultOptimizationContextFactory.INSTANCE;
    }

    public HeuristicCompilerFactoryBuilder(IOptimizationContextFactory optCtxFactory) {
        this.optCtxFactory = optCtxFactory;
    }

    @Override
    public ICompilerFactory create() {
        return new ICompilerFactory(){

            @Override
            public ICompiler createCompiler(final ILogicalPlan plan, final IMetadataProvider<?, ?> metadata, int varCounter) {
                final IOptimizationContext oc = HeuristicCompilerFactoryBuilder.this.optCtxFactory.createOptimizationContext(varCounter, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.mergeAggregationExpressionFactory, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, HeuristicCompilerFactoryBuilder.this.missableTypeComputer, HeuristicCompilerFactoryBuilder.this.conflictingTypeResolver, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig, (AlgebricksPartitionConstraint)HeuristicCompilerFactoryBuilder.this.clusterLocations);
                oc.setMetadataDeclarations(metadata);
                final HeuristicOptimizer opt = new HeuristicOptimizer(plan, HeuristicCompilerFactoryBuilder.this.logicalRewrites, HeuristicCompilerFactoryBuilder.this.physicalRewrites, oc);
                return new ICompiler(){

                    @Override
                    public void optimize() throws AlgebricksException {
                        opt.optimize();
                    }

                    @Override
                    public JobSpecification createJob(Object appContext, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
                        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting Job Generation.\n");
                        JobGenContext context = new JobGenContext(null, metadata, appContext, HeuristicCompilerFactoryBuilder.this.serializerDeserializerProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFactoryProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFamilyProvider, HeuristicCompilerFactoryBuilder.this.comparatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.typeTraitProvider, HeuristicCompilerFactoryBuilder.this.binaryBooleanInspectorFactory, HeuristicCompilerFactoryBuilder.this.binaryIntegerInspectorFactory, HeuristicCompilerFactoryBuilder.this.printerProvider, HeuristicCompilerFactoryBuilder.this.missingWriterFactory, HeuristicCompilerFactoryBuilder.this.normalizedKeyComputerFactoryProvider, HeuristicCompilerFactoryBuilder.this.expressionRuntimeProvider, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, (ITypingContext)oc, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.partialAggregationTypeComputer, HeuristicCompilerFactoryBuilder.this.predEvaluatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig.getFrameSize(), HeuristicCompilerFactoryBuilder.this.clusterLocations);
                        PlanCompiler pc = new PlanCompiler(context);
                        return pc.compilePlan(plan, null, jobEventListenerFactory);
                    }
                };
            }
        };
    }

    public static class DefaultOptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final DefaultOptimizationContextFactory INSTANCE = new DefaultOptimizationContextFactory();

        private DefaultOptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IConflictingTypeResolver conflictingTypeResolver, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations) {
            LogicalOperatorPrettyPrintVisitor prettyPrintVisitor = new LogicalOperatorPrettyPrintVisitor();
            return new AlgebricksOptimizationContext(varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, missableTypeComputer, conflictingTypeResolver, physicalOptimizationConfig, clusterLocations, prettyPrintVisitor);
        }
    }
}

