/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.work;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class WorkQueue {
    private static final Logger LOGGER = Logger.getLogger(WorkQueue.class.getName());
    private static final boolean DEBUG = false;
    private final LinkedBlockingQueue<AbstractWork> queue;
    private final WorkerThread thread;
    private boolean stopped;
    private AtomicInteger enqueueCount;
    private AtomicInteger dequeueCount;
    private int threadPriority = 10;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public WorkQueue(String id, int threadPriority) {
        if (threadPriority != 10 && threadPriority != 5 && threadPriority != 1) {
            throw new IllegalArgumentException("Illegal thread priority number.");
        }
        this.threadPriority = threadPriority;
        this.queue = new LinkedBlockingQueue();
        this.thread = new WorkerThread(id);
        this.stopped = true;
    }

    public void start() throws HyracksException {
        this.stopped = false;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws HyracksException {
        WorkQueue workQueue = this;
        synchronized (workQueue) {
            this.stopped = true;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HyracksException((Throwable)e);
        }
    }

    public void schedule(AbstractWork event) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Scheduling: " + event);
        }
        this.queue.offer(event);
    }

    public void scheduleAndSync(SynchronizableWork sRunnable) throws Exception {
        this.schedule(sRunnable);
        sRunnable.sync();
    }

    private class WorkerThread
    extends Thread {
        WorkerThread(String id) {
            this.setName("Worker:" + id);
            this.setDaemon(true);
            this.setPriority(WorkQueue.this.threadPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                AbstractWork r;
                WorkQueue workQueue = WorkQueue.this;
                synchronized (workQueue) {
                    if (WorkQueue.this.stopped) {
                        return;
                    }
                }
                try {
                    r = (AbstractWork)WorkQueue.this.queue.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                if (LOGGER.isLoggable(r.logLevel())) {
                    LOGGER.log(r.logLevel(), "Executing: " + r);
                }
                ThreadInfo before = WorkQueue.this.threadMXBean.getThreadInfo(WorkQueue.this.thread.getId());
                try {
                    r.run();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception while executing " + r, e);
                    continue;
                }
                finally {
                    this.auditWaitsAndBlocks(r, before);
                    continue;
                }
                break;
            }
        }

        protected void auditWaitsAndBlocks(AbstractWork r, ThreadInfo before) {
            ThreadInfo after = WorkQueue.this.threadMXBean.getThreadInfo(WorkQueue.this.thread.getId());
            long waitedDelta = after.getWaitedCount() - before.getWaitedCount();
            long blockedDelta = after.getBlockedCount() - before.getBlockedCount();
            if (waitedDelta > 0L || blockedDelta > 0L) {
                LOGGER.warning("Work " + r + " waited " + waitedDelta + " times (~" + (after.getWaitedTime() - before.getWaitedTime()) + "ms), blocked " + blockedDelta + " times (~" + (after.getBlockedTime() - before.getBlockedTime()) + "ms)");
            }
        }
    }
}

