/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.utils;

import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static List<Exception> getActualExceptions(List<Exception> allExceptions) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Exception exception : allExceptions) {
            if (!ExceptionUtils.possibleRootCause(exception)) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    public static void setNodeIds(Collection<Exception> exceptions, String nodeId) {
        ArrayList<HyracksDataException> newExceptions = new ArrayList<HyracksDataException>();
        for (Exception e : exceptions) {
            if (e instanceof HyracksDataException) {
                newExceptions.add(HyracksDataException.create((HyracksDataException)((HyracksDataException)e), (String)nodeId));
                continue;
            }
            newExceptions.add(new HyracksDataException("HYR", 3, e.getMessage(), (Throwable)e, nodeId, new Serializable[0]));
        }
        exceptions.clear();
        exceptions.addAll(newExceptions);
    }

    private static boolean possibleRootCause(Throwable exception) {
        Throwable cause = exception;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof InterruptedException) && !(cause instanceof ClosedChannelException)) continue;
            return false;
        }
        return true;
    }
}

