/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.control.common.job.profiling.om.AbstractProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;

public class JobletProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private String nodeId;
    private Map<TaskAttemptId, TaskProfile> taskProfiles;

    public static JobletProfile create(DataInput dis) throws IOException {
        JobletProfile jobletProfile = new JobletProfile();
        jobletProfile.readFields(dis);
        return jobletProfile;
    }

    private JobletProfile() {
    }

    public JobletProfile(String nodeId) {
        this.nodeId = nodeId;
        this.taskProfiles = new HashMap<TaskAttemptId, TaskProfile>();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Map<TaskAttemptId, TaskProfile> getTaskProfiles() {
        return this.taskProfiles;
    }

    @Override
    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("node-id", this.nodeId.toString());
        this.populateCounters(json);
        ArrayNode tasks = om.createArrayNode();
        for (TaskProfile p : this.taskProfiles.values()) {
            tasks.add((JsonNode)p.toJSON());
        }
        json.set("tasks", (JsonNode)tasks);
        return json;
    }

    public void merge(JobletProfile jp) {
        super.merge(this);
        for (TaskProfile tp : jp.taskProfiles.values()) {
            if (this.taskProfiles.containsKey(tp.getTaskId())) {
                this.taskProfiles.get(tp.getTaskId()).merge(tp);
                continue;
            }
            this.taskProfiles.put(tp.getTaskId(), tp);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.nodeId = input.readUTF();
        int size = input.readInt();
        this.taskProfiles = new HashMap<TaskAttemptId, TaskProfile>();
        for (int i = 0; i < size; ++i) {
            TaskAttemptId key = TaskAttemptId.create((DataInput)input);
            TaskProfile value = TaskProfile.create(input);
            this.taskProfiles.put(key, value);
        }
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        super.writeFields(output);
        output.writeUTF(this.nodeId);
        output.writeInt(this.taskProfiles.size());
        for (Map.Entry<TaskAttemptId, TaskProfile> entry : this.taskProfiles.entrySet()) {
            entry.getKey().writeFields(output);
            entry.getValue().writeFields(output);
        }
    }
}

