/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.io.IWritable;

public abstract class AbstractProfile
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Long> counters = new HashMap<String, Long>();

    public Map<String, Long> getCounters() {
        return this.counters;
    }

    public abstract ObjectNode toJSON();

    protected void populateCounters(ObjectNode jo) {
        ObjectMapper om = new ObjectMapper();
        ArrayNode countersObj = om.createArrayNode();
        for (Map.Entry<String, Long> e : this.counters.entrySet()) {
            ObjectNode jpe = om.createObjectNode();
            jpe.put("name", e.getKey());
            jpe.put("value", e.getValue());
            countersObj.add((JsonNode)jpe);
        }
        jo.set("counters", (JsonNode)countersObj);
    }

    protected void merge(AbstractProfile profile) {
        this.counters.putAll(profile.counters);
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeInt(this.counters.size());
        for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
            output.writeUTF(entry.getKey());
            output.writeLong(entry.getValue());
        }
    }

    public void readFields(DataInput input) throws IOException {
        int size = input.readInt();
        this.counters = new HashMap<String, Long>();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            long value = input.readLong();
            this.counters.put(key, value);
        }
    }
}

