/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.deployment;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobSerializerDeserializer;
import org.apache.hyracks.api.util.JavaSerializationUtils;

public class ClassLoaderJobSerializerDeserializer
implements IJobSerializerDeserializer {
    private MutableURLClassLoader classLoader;

    public Object deserialize(byte[] jsBytes) throws HyracksException {
        try {
            if (this.classLoader == null) {
                return JavaSerializationUtils.deserialize((byte[])jsBytes);
            }
            return JavaSerializationUtils.deserialize((byte[])jsBytes, (ClassLoader)this.classLoader);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public byte[] serialize(Serializable jobSpec) throws HyracksException {
        try {
            if (this.classLoader == null) {
                return JavaSerializationUtils.serialize((Serializable)jobSpec);
            }
            return JavaSerializationUtils.serialize((Serializable)jobSpec, (ClassLoader)this.classLoader);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void addClassPathURLs(List<URL> binaryURLs) throws HyracksException {
        Collections.sort(binaryURLs, new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.getFile().compareTo(o2.getFile());
            }
        });
        try {
            if (this.classLoader == null) {
                URL[] urls = binaryURLs.toArray(new URL[binaryURLs.size()]);
                this.classLoader = new MutableURLClassLoader(urls, this.getClass().getClassLoader());
            } else {
                for (URL url : binaryURLs) {
                    this.classLoader.addURL(url);
                }
            }
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public Class<?> loadClass(String className) throws HyracksException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() throws HyracksException {
        return this.classLoader;
    }

    public String toString() {
        return this.classLoader.toString();
    }

    private static class MutableURLClassLoader
    extends URLClassLoader {
        public MutableURLClassLoader(URL[] urls, ClassLoader classLoader) {
            super(urls, classLoader);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }
}

