/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.controllers;

import java.io.Serializable;
import java.net.URL;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.file.FileUtil;

public class ControllerConfig
implements Serializable {
    public static String defaultDir = FileUtil.joinPath((String[])new String[]{System.getProperty("java.io.tmpdir"), "hyracks"});
    protected final ConfigManager configManager;

    protected ControllerConfig(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public IApplicationConfig getAppConfig() {
        return this.configManager.getAppConfig();
    }

    public String getConfigFile() {
        return this.getAppConfig().getString((IOption)Option.CONFIG_FILE);
    }

    public void setConfigFile(String configFile) {
        this.configManager.set(Option.CONFIG_FILE, configFile);
    }

    public URL getConfigFileUrl() {
        return (URL)this.getAppConfig().get((IOption)Option.CONFIG_FILE_URL);
    }

    public void setConfigFileUrl(URL configFileUrl) {
        this.configManager.set(Option.CONFIG_FILE_URL, configFileUrl);
    }

    public static enum Option implements IOption
    {
        CONFIG_FILE(OptionTypes.STRING, "Specify path to master configuration file"),
        CONFIG_FILE_URL(OptionTypes.URL, "Specify URL to master configuration file");

        private final IOptionType type;
        private final String description;

        private Option(IOptionType type, String description) {
            this.type = type;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return null;
        }
    }
}

