/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.util.StorageUtil;

public class OptionTypes {
    public static final IOptionType<Integer> INTEGER_BYTE_UNIT = new IOptionType<Integer>(){

        public Integer parse(String s) {
            long result1 = StorageUtil.getByteValue((String)s);
            if (result1 > Integer.MAX_VALUE || result1 < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("The given value: " + result1 + " is not within the int range.");
            }
            return (int)result1;
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Integer)value).intValue()) + ")";
        }
    };
    public static final IOptionType<Long> LONG_BYTE_UNIT = new IOptionType<Long>(){

        public Long parse(String s) {
            return StorageUtil.getByteValue((String)s);
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Long)value)) + ")";
        }
    };
    public static final IOptionType<Integer> INTEGER = new IOptionType<Integer>(){

        public Integer parse(String s) {
            return Integer.parseInt(s);
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }
    };
    public static final IOptionType<Double> DOUBLE = new IOptionType<Double>(){

        public Double parse(String s) {
            return Double.parseDouble(s);
        }

        public Class<Double> targetType() {
            return Double.class;
        }
    };
    public static final IOptionType<String> STRING = new IOptionType<String>(){

        public String parse(String s) {
            return s;
        }

        public Class<String> targetType() {
            return String.class;
        }
    };
    public static final IOptionType<Long> LONG = new IOptionType<Long>(){

        public Long parse(String s) {
            return Long.parseLong(s);
        }

        public Class<Long> targetType() {
            return Long.class;
        }
    };
    public static final IOptionType<Boolean> BOOLEAN = new IOptionType<Boolean>(){

        public Boolean parse(String s) {
            return Boolean.parseBoolean(s);
        }

        public Class<Boolean> targetType() {
            return Boolean.class;
        }
    };
    public static final IOptionType<Level> LEVEL = new IOptionType<Level>(){

        public Level parse(String s) {
            return Level.parse(s);
        }

        public Class<Level> targetType() {
            return Level.class;
        }

        public Object serializeToJSON(Object value) {
            return ((Level)value).getName();
        }

        public String serializeToIni(Object value) {
            return ((Level)value).getName();
        }
    };
    public static final IOptionType<String[]> STRING_ARRAY = new IOptionType<String[]>(){

        public String[] parse(String s) {
            return s.split("\\s*,\\s*");
        }

        public Class<String[]> targetType() {
            return String[].class;
        }

        public String serializeToIni(Object value) {
            return String.join((CharSequence)",", (String[])value);
        }
    };
    public static final IOptionType<URL> URL = new IOptionType<URL>(){

        public URL parse(String s) {
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Class<URL> targetType() {
            return URL.class;
        }
    };

    private OptionTypes() {
    }
}

