/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.CompositeMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IConfigurator;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.common.application.ConfigManagerApplicationConfig;
import org.apache.hyracks.control.common.config.Args4jArgument;
import org.apache.hyracks.control.common.config.Args4jOption;
import org.apache.hyracks.control.common.config.Args4jSetter;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.config.IConfigSetter;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.spi.Setter;

public class ConfigManager
implements IConfigManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ConfigManager.class.getName());
    private HashSet<IOption> registeredOptions = new HashSet();
    private HashMap<IOption, Object> definedMap = new HashMap();
    private HashMap<IOption, Object> defaultMap = new HashMap();
    private CompositeMap<IOption, Object> configurationMap = new CompositeMap(this.definedMap, this.defaultMap, (CompositeMap.MapMutator)new NoOpMapMutator());
    private EnumMap<Section, Map<String, IOption>> sectionMap = new EnumMap(Section.class);
    private TreeMap<String, Map<IOption, Object>> nodeSpecificMap = new TreeMap();
    private transient ArrayListValuedHashMap<IOption, IConfigSetter> optionSetters = new ArrayListValuedHashMap();
    private final String[] args;
    private ConfigManagerApplicationConfig appConfig = new ConfigManagerApplicationConfig(this);
    private Set<String> allSections = new HashSet<String>();
    private transient Collection<Consumer<List<String>>> argListeners = new ArrayList<Consumer<List<String>>>();
    private transient Collection<IOption> iniPointerOptions = new ArrayList<IOption>();
    private transient Collection<Section> cmdLineSections = new ArrayList<Section>();
    private transient OptionHandlerFilter usageFilter;
    private transient SortedMap<Integer, List<IConfigurator>> configurators = new TreeMap<Integer, List<IConfigurator>>();
    private boolean configured;
    private String versionString = "version undefined";

    public ConfigManager() {
        this(null);
    }

    public ConfigManager(String[] args) {
        this.args = args;
        for (Section section : Section.values()) {
            this.allSections.add(section.sectionName());
        }
        this.addConfigurator(IConfigManager.ConfiguratorMetric.PARSE_INI_POINTERS, this::extractIniPointersFromCommandLine);
        this.addConfigurator(IConfigManager.ConfiguratorMetric.PARSE_INI, this::parseIni);
        this.addConfigurator(IConfigManager.ConfiguratorMetric.PARSE_COMMAND_LINE, this::processCommandLine);
        this.addConfigurator(IConfigManager.ConfiguratorMetric.APPLY_DEFAULTS, this::applyDefaults);
    }

    public void addConfigurator(int metric, IConfigurator configurator) {
        this.configurators.computeIfAbsent(metric, metric1 -> new ArrayList()).add(configurator);
    }

    private void addConfigurator(IConfigManager.ConfiguratorMetric metric, IConfigurator configurator) {
        this.addConfigurator(metric.metric(), configurator);
    }

    public void addIniParamOptions(IOption ... options) {
        Stream.of(options).forEach(this.iniPointerOptions::add);
    }

    public void addCmdLineSections(Section ... sections) {
        Stream.of(sections).forEach(this.cmdLineSections::add);
    }

    public void setUsageFilter(OptionHandlerFilter usageFilter) {
        this.usageFilter = usageFilter;
    }

    public void register(IOption ... options) {
        for (IOption option : options) {
            if (option.section() == Section.VIRTUAL || this.registeredOptions.contains(option)) continue;
            if (this.configured) {
                throw new IllegalStateException("configuration already processed");
            }
            LOGGER.fine("registering option: " + option.toIniString());
            Map optionMap = this.sectionMap.computeIfAbsent(option.section(), section -> new HashMap());
            IOption prev = optionMap.put(option.ini(), option);
            if (prev != null) {
                if (prev == option) continue;
                throw new IllegalStateException("An option cannot be defined multiple times: " + option.toIniString() + ": " + Arrays.asList(option.getClass(), prev.getClass()));
            }
            this.registeredOptions.add(option);
            this.optionSetters.put((Object)option, (node, value, isDefault) -> this.correctedMap(node, isDefault).put(option, value));
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            this.optionSetters.put((Object)option, (node, value, isDefault) -> LOGGER.fine((isDefault ? "defaulting" : "setting ") + option.toIniString() + " to " + value));
        }
    }

    private Map<IOption, Object> correctedMap(String node, boolean isDefault) {
        return node == null ? (isDefault ? this.defaultMap : this.definedMap) : this.nodeSpecificMap.computeIfAbsent(node, this::createNodeSpecificMap);
    }

    public void registerVirtualNode(String nodeId) {
        LOGGER.fine("registerVirtualNode: " + nodeId);
        this.nodeSpecificMap.computeIfAbsent(nodeId, this::createNodeSpecificMap);
    }

    private Map<IOption, Object> createNodeSpecificMap(String nodeId) {
        LOGGER.fine("createNodeSpecificMap: " + nodeId);
        return new HashMap<IOption, Object>();
    }

    @SafeVarargs
    public final void register(Class<? extends IOption> ... optionClasses) {
        for (Class<? extends IOption> optionClass : optionClasses) {
            this.register(optionClass.getEnumConstants());
        }
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public IOption lookupOption(String section, String key) {
        Map<String, IOption> map = this.getSectionOptionMap(Section.parseSectionName((String)section));
        return map == null ? null : map.get(key);
    }

    public void processConfig() throws CmdLineException, IOException {
        if (!this.configured) {
            for (List<IConfigurator> configuratorList : this.configurators.values()) {
                for (IConfigurator configurator : configuratorList) {
                    configurator.run();
                }
            }
            this.configured = true;
        }
    }

    private void processCommandLine() throws CmdLineException {
        List<String> appArgs = this.processCommandLine(this.cmdLineSections, this.usageFilter, this::cmdLineSet);
        this.argListeners.forEach(l -> l.accept(appArgs));
    }

    private void extractIniPointersFromCommandLine() throws CmdLineException {
        HashMap cmdLineOptions = new HashMap();
        this.processCommandLine(this.cmdLineSections, this.usageFilter, cmdLineOptions::put);
        for (IOption option : this.iniPointerOptions) {
            if (!cmdLineOptions.containsKey(option)) continue;
            this.set(option, cmdLineOptions.get(option));
        }
    }

    private void cmdLineSet(IOption option, Object value) {
        this.invokeSetters(option, option.type().parse(String.valueOf(value)), null);
    }

    private void invokeSetters(IOption option, Object value, String nodeId) {
        this.optionSetters.get((Object)option).forEach(setter -> setter.set(nodeId, value, false));
    }

    private List<String> processCommandLine(Collection<Section> sections, OptionHandlerFilter usageFilter, BiConsumer<IOption, Object> setAction) throws CmdLineException {
        Args4jBean bean = new Args4jBean();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)bean);
        ArrayList<String> appArgs = new ArrayList<String>();
        ArrayList<IOption> commandLineOptions = new ArrayList<IOption>();
        for (Map.Entry<Section, Map<String, IOption>> sectionMapEntry : this.sectionMap.entrySet()) {
            if (!sections.contains(sectionMapEntry.getKey())) continue;
            for (IOption option2 : sectionMapEntry.getValue().values()) {
                if (option2.section() == Section.VIRTUAL) continue;
                commandLineOptions.add(option2);
            }
        }
        commandLineOptions.sort(Comparator.comparing(IOption::cmdline));
        commandLineOptions.forEach(option -> cmdLineParser.addOption((Setter)new Args4jSetter((IOption)option, setAction, false), (Option)new Args4jOption((IOption)option, this, option.type().targetType())));
        if (!this.argListeners.isEmpty()) {
            cmdLineParser.addArgument((Setter)new Args4jSetter(o -> appArgs.add(String.valueOf(o)), true, String.class), (Argument)new Args4jArgument());
        }
        LOGGER.fine("parsing cmdline: " + Arrays.toString(this.args));
        if (this.args == null || this.args.length == 0) {
            LOGGER.info("no command line args supplied");
            return appArgs;
        }
        try {
            cmdLineParser.parseArgument(this.args);
        }
        catch (CmdLineException e) {
            if (!bean.help) {
                ConfigUtils.printUsage(e, usageFilter, System.err);
                throw e;
            }
            LOGGER.log(Level.FINE, "Ignoring parse exception due to -help", e);
        }
        if (bean.help) {
            ConfigUtils.printUsage(cmdLineParser, usageFilter, System.err);
            System.exit(0);
        } else if (bean.version) {
            System.err.println(this.versionString);
            System.exit(0);
        }
        return appArgs;
    }

    private void parseIni() throws IOException {
        Ini ini = null;
        for (IOption option : this.iniPointerOptions) {
            Object pointer = this.get(option);
            if (pointer instanceof String) {
                ini = ConfigUtils.loadINIFile((String)pointer);
                continue;
            }
            if (pointer instanceof URL) {
                ini = ConfigUtils.loadINIFile((URL)pointer);
                continue;
            }
            if (pointer == null) continue;
            throw new IllegalArgumentException("config file pointer options must be of type String (for file) or URL, instead of " + option.type().targetType());
        }
        if (ini == null) {
            LOGGER.info("no INI file specified; skipping parsing");
            return;
        }
        LOGGER.info("parsing INI file: " + ini);
        for (Profile.Section section : ini.values()) {
            String node;
            this.allSections.add(section.getName());
            Section rootSection = Section.parseSectionName((String)(section.getParent() == null ? section.getName() : section.getParent().getName()));
            if (rootSection == Section.EXTENSION) {
                this.parseExtensionIniSection(section);
                continue;
            }
            if (rootSection == Section.NC) {
                node = section.getName().equals(section.getSimpleName()) ? null : section.getSimpleName();
            } else if (Section.parseSectionName((String)section.getName()) != null) {
                node = null;
            } else {
                throw new HyracksException("Unknown section in ini: " + section.getName());
            }
            Map<String, IOption> optionMap = this.getSectionOptionMap(rootSection);
            for (Map.Entry iniOption : section.entrySet()) {
                IOption option;
                String name = (String)iniOption.getKey();
                IOption iOption = option = optionMap == null ? null : optionMap.get(name);
                if (option == null) {
                    this.handleUnknownOption(section, name);
                    return;
                }
                String value = (String)iniOption.getValue();
                LOGGER.fine("setting " + option.toIniString() + " to " + value);
                Object parsed = option.type().parse(value);
                this.invokeSetters(option, parsed, node);
            }
        }
    }

    private void parseExtensionIniSection(Profile.Section section) {
    }

    private void handleUnknownOption(Profile.Section section, String name) throws HyracksException {
        HashSet<String> matches = new HashSet<String>();
        for (IOption registeredOption : this.registeredOptions) {
            if (!registeredOption.ini().equals(name)) continue;
            matches.add(registeredOption.section().sectionName());
        }
        if (!matches.isEmpty()) {
            throw new HyracksException("Section mismatch for [" + section.getName() + "] " + name + ", expected section(s) " + matches);
        }
        throw new HyracksException("Unknown option in ini: [" + section.getName() + "] " + name);
    }

    private void applyDefaults() {
        LOGGER.fine("applying defaults");
        for (Map.Entry<Section, Map<String, IOption>> entry : this.sectionMap.entrySet()) {
            if (entry.getKey() == Section.NC) {
                entry.getValue().values().forEach(option -> this.getNodeNames().forEach(node -> this.getOrDefault((Map<IOption, Object>)this.getNodeEffectiveMap((String)node), (IOption)option, (String)node)));
                for (Map.Entry<String, Map<IOption, Object>> nodeMap : this.nodeSpecificMap.entrySet()) {
                    entry.getValue().values().forEach(option -> this.getOrDefault((Map<IOption, Object>)new CompositeMap((Map)nodeMap.getValue(), this.definedMap, (CompositeMap.MapMutator)new NoOpMapMutator()), (IOption)option, (String)nodeMap.getKey()));
                }
                continue;
            }
            entry.getValue().values().forEach(option -> this.getOrDefault((Map<IOption, Object>)this.configurationMap, (IOption)option, null));
        }
    }

    private Object getOrDefault(final Map<IOption, Object> map, IOption option, final String nodeId) {
        if (map.containsKey(option)) {
            return map.get(option);
        }
        Object value = this.resolveDefault(option, new ConfigManagerApplicationConfig(this){

            @Override
            public Object getStatic(IOption option) {
                return ConfigManager.this.getOrDefault(map, option, nodeId);
            }
        });
        if (value != null && this.optionSetters != null) {
            this.optionSetters.get((Object)option).forEach(setter -> setter.set(nodeId, value, true));
        }
        return value;
    }

    public Object resolveDefault(IOption option, IApplicationConfig applicationConfig) {
        Object value = option.defaultValue();
        if (value instanceof IOption) {
            return applicationConfig.get((IOption)value);
        }
        if (value instanceof Supplier) {
            return ((Supplier)value).get();
        }
        if (value instanceof Function) {
            return ((Function)value).apply(applicationConfig);
        }
        return value;
    }

    public Set<Section> getSections(Predicate<Section> predicate) {
        return Arrays.stream(Section.values()).filter(predicate).collect(Collectors.toSet());
    }

    public Set<Section> getSections() {
        return this.getSections(section -> true);
    }

    public Set<String> getSectionNames() {
        return Collections.unmodifiableSet(this.allSections);
    }

    public Set<String> getOptionNames(String sectionName) {
        HashSet<String> optionNames = new HashSet<String>();
        Section section = Section.parseSectionName((String)sectionName);
        for (IOption option : this.getSectionOptionMap(section).values()) {
            optionNames.add(option.ini());
        }
        return optionNames;
    }

    public Set<IOption> getOptions(Section section) {
        return this.getSectionOptionMap(section).values().stream().collect(Collectors.toSet());
    }

    private Map<String, IOption> getSectionOptionMap(Section section) {
        Map<String, IOption> map = this.sectionMap.get(section);
        return map != null ? map : Collections.emptyMap();
    }

    public List<String> getNodeNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.nodeSpecificMap.keySet()));
    }

    public IApplicationConfig getNodeEffectiveConfig(String nodeId) {
        Map nodeMap = this.nodeSpecificMap.computeIfAbsent(nodeId, this::createNodeSpecificMap);
        CompositeMap<IOption, Object> nodeEffectiveMap = this.getNodeEffectiveMap(nodeId);
        return new ConfigManagerApplicationConfig(this, (Map)nodeEffectiveMap, nodeMap, nodeId){
            final /* synthetic */ Map val$nodeEffectiveMap;
            final /* synthetic */ Map val$nodeMap;
            final /* synthetic */ String val$nodeId;
            {
                this.val$nodeEffectiveMap = map;
                this.val$nodeMap = map2;
                this.val$nodeId = string;
                super(configManager);
            }

            @Override
            public Object getStatic(IOption option) {
                if (!this.val$nodeEffectiveMap.containsKey(option)) {
                    this.val$nodeMap.put(option, ConfigManager.this.getOrDefault(this.val$nodeEffectiveMap, option, this.val$nodeId));
                }
                return this.val$nodeEffectiveMap.get(option);
            }
        };
    }

    private CompositeMap<IOption, Object> getNodeEffectiveMap(String nodeId) {
        return new CompositeMap(this.nodeSpecificMap.get(nodeId), this.definedMap, (CompositeMap.MapMutator)new NoOpMapMutator());
    }

    public Ini toIni(boolean includeDefaults) {
        Ini ini = new Ini();
        for (Map.Entry entry : ((Map)(includeDefaults ? this.configurationMap : this.definedMap)).entrySet()) {
            if (entry.getValue() == null) continue;
            IOption option = (IOption)entry.getKey();
            ini.add(option.section().sectionName(), option.ini(), (Object)option.type().serializeToIni(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.nodeSpecificMap.entrySet()) {
            String section = Section.NC.sectionName() + "/" + (String)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (entry2.getValue() == null) continue;
                IOption option = (IOption)entry2.getKey();
                ini.add(section, option.ini(), (Object)option.type().serializeToIni(entry2.getValue()));
            }
        }
        return ini;
    }

    public void set(IOption option, Object value) {
        this.set(null, option, value);
    }

    public void set(String nodeId, IOption option, Object value) {
        this.invokeSetters(option, value, nodeId);
    }

    public Object get(IOption option) {
        if (!this.registeredOptions.contains(option)) {
            throw new IllegalStateException("Option not registered with ConfigManager: " + option.toIniString() + "(" + option.getClass() + "." + option + ")");
        }
        if (option.section() == Section.NC) {
            LOGGER.warning("NC option " + option.toIniString() + " being accessed outside of NC-scoped configuration.");
        }
        return this.getOrDefault((Map<IOption, Object>)this.configurationMap, option, null);
    }

    public Set<IOption> getOptions() {
        return Collections.unmodifiableSet(this.registeredOptions);
    }

    public IApplicationConfig getAppConfig() {
        return this.appConfig;
    }

    public void registerArgsListener(Consumer<List<String>> argListener) {
        this.argListeners.add(argListener);
    }

    String getUsage(IOption option) {
        String description = option.description();
        StringBuilder usage = new StringBuilder();
        if (description != null && !"".equals(description)) {
            usage.append(description).append(" ");
        } else {
            LOGGER.warning("missing description for option: " + option.getClass().getName().substring(option.getClass().getName().lastIndexOf(".") + 1) + "." + option.name());
        }
        usage.append("(default: ");
        usage.append(this.defaultTextForUsage(option, IOption::cmdline));
        usage.append(")");
        return usage.toString();
    }

    public String defaultTextForUsage(IOption option, Function<IOption, String> optionPrinter) {
        StringBuilder buf = new StringBuilder();
        String override = option.usageDefaultOverride((IApplicationConfig)this.appConfig, optionPrinter);
        if (override != null) {
            buf.append(override);
        } else {
            Object value = option.defaultValue();
            if (value instanceof IOption) {
                buf.append("same as ").append(optionPrinter.apply((IOption)value));
            } else if (value instanceof Function) {
                buf.append("<function>");
            } else if (value == null) {
                buf.append("<undefined>");
            } else {
                buf.append(option.type().serializeToHumanReadable(this.resolveDefault(option, this.appConfig)));
            }
        }
        return buf.toString();
    }

    private static class Args4jBean {
        @Option(name="-help", help=true)
        boolean help;
        @Option(name="-version", help=true)
        boolean version;

        private Args4jBean() {
        }
    }

    private static class NoOpMapMutator
    implements CompositeMap.MapMutator<IOption, Object> {
        private NoOpMapMutator() {
        }

        public Object put(CompositeMap<IOption, Object> compositeMap, Map<IOption, Object>[] maps, IOption iOption, Object o) {
            throw new UnsupportedOperationException("mutations are not allowed");
        }

        public void putAll(CompositeMap<IOption, Object> compositeMap, Map<IOption, Object>[] maps, Map<? extends IOption, ?> map) {
            throw new UnsupportedOperationException("mutations are not allowed");
        }

        public void resolveCollision(CompositeMap<IOption, Object> compositeMap, Map<IOption, Object> map, Map<IOption, Object> map1, Collection<IOption> collection) {
        }
    }
}

