/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.ServiceConstants;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class TriggerNCWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(TriggerNCWork.class.getName());
    private final ClusterControllerService ccs;
    private final String ncHost;
    private final int ncPort;
    private final String ncId;

    public TriggerNCWork(ClusterControllerService ccs, String ncHost, int ncPort, String ncId) {
        this.ccs = ccs;
        this.ncHost = ncHost;
        this.ncPort = ncPort;
        this.ncId = ncId;
    }

    public final void run() {
        this.ccs.getExecutor().execute(() -> {
            while (true) {
                LOGGER.info("Connecting NC service '" + this.ncId + "' at " + this.ncHost + ":" + this.ncPort);
                try (Socket s = new Socket(this.ncHost, this.ncPort);){
                    ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                    oos.writeUTF("hyncmagic2");
                    oos.writeUTF(ServiceConstants.ServiceCommand.START_NC.name());
                    oos.writeUTF(this.serializeIni(this.ccs.getCCConfig().getIni()));
                    oos.close();
                    return;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to contact NC service at " + this.ncHost + ":" + this.ncPort + "; will retry", e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
            }
        });
    }

    private String serializeIni(Ini ccini) throws IOException {
        StringWriter iniString = new StringWriter();
        ((Profile.Section)ccini.get((Object)Section.NC.sectionName())).putIfAbsent((Object)NCConfig.Option.CLUSTER_ADDRESS.ini(), (Object)this.ccs.getCCConfig().getClusterPublicAddress());
        ((Profile.Section)ccini.get((Object)Section.NC.sectionName())).putIfAbsent((Object)NCConfig.Option.CLUSTER_PORT.ini(), (Object)String.valueOf(this.ccs.getCCConfig().getClusterPublicPort()));
        ccini.put(Section.LOCALNC.sectionName(), NCConfig.Option.NODE_ID.ini(), (Object)this.ncId);
        ccini.store((Writer)iniString);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Returning Ini file:\n" + iniString.toString());
        }
        return iniString.toString();
    }
}

