/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.base.INodeController;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.ipc.NodeControllerRemoteProxy;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.ipc.api.IIPCHandle;

public class RegisterNodeWork
extends SynchronizableWork {
    private static final Logger LOGGER = Logger.getLogger(RegisterNodeWork.class.getName());
    private final ClusterControllerService ccs;
    private final NodeRegistration reg;

    public RegisterNodeWork(ClusterControllerService ccs, NodeRegistration reg) {
        this.ccs = ccs;
        this.reg = reg;
    }

    protected void doRun() throws Exception {
        CCNCFunctions.NodeRegistrationResult result;
        String id = this.reg.getNodeId();
        IIPCHandle ncIPCHandle = this.ccs.getClusterIPC().getHandle(this.reg.getNodeControllerAddress());
        HashMap<IOption, Object> ncConfiguration = new HashMap<IOption, Object>();
        try {
            NodeControllerRemoteProxy nodeController = new NodeControllerRemoteProxy(ncIPCHandle);
            NodeControllerState state = new NodeControllerState((INodeController)nodeController, this.reg);
            INodeManager nodeManager = this.ccs.getNodeManager();
            nodeManager.addNode(id, state);
            IApplicationConfig cfg = state.getNCConfig().getConfigManager().getNodeEffectiveConfig(id);
            for (IOption option : cfg.getOptions()) {
                ncConfiguration.put(option, cfg.get(option));
            }
            LOGGER.log(Level.INFO, "Registered INodeController: id = " + id);
            NodeParameters params = new NodeParameters();
            params.setClusterControllerInfo(this.ccs.getClusterControllerInfo());
            params.setDistributedState(this.ccs.getContext().getDistributedState());
            params.setHeartbeatPeriod(this.ccs.getCCConfig().getHeartbeatPeriod());
            params.setProfileDumpPeriod(this.ccs.getCCConfig().getProfileDumpPeriod());
            result = new CCNCFunctions.NodeRegistrationResult(params, null);
        }
        catch (Exception e) {
            result = new CCNCFunctions.NodeRegistrationResult(null, e);
        }
        ncIPCHandle.send(-1L, (Object)result, null);
        this.ccs.getContext().notifyNodeJoin(id, ncConfiguration);
    }
}

